/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.tools.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.eclipse.AdtImportBuilder;
import com.android.tools.idea.gradle.eclipse.AdtImportProvider;
import com.google.common.collect.Maps;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.EditableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

class AdtWorkspaceForm
extends ProjectImportWizardStep {
    private JBTable myPathMapTable;
    private TextFieldWithBrowseButton myWorkspaceField;
    private JPanel myPanel;
    private Map<String, File> myPathMap;
    private boolean myIgnore;
    private static final int WORKSPACE_PATH_COLUMN = 0;
    private static final int FILE_COLUMN = 1;

    AdtWorkspaceForm(WizardContext context) {
        super(context);
        this.$$$setupUI$$$();
        this.myPathMap = Maps.newHashMap();
        this.myPathMapTable.setSelectionMode(0);
        this.myPathMapTable.setStriped(true);
        JTextField textField = new JTextField();
        DefaultCellEditor cellEditor = new DefaultCellEditor(textField);
        cellEditor.setClickCountToStart(1);
        this.myPathMapTable.setDefaultEditor(String.class, (TableCellEditor)cellEditor);
        this.myWorkspaceField.addBrowseFolderListener("Select Eclipse Workspace", null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myWorkspaceField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GradleImport importer;
                AdtImportBuilder builder;
                File workspace = new File(AdtWorkspaceForm.this.myWorkspaceField.getText());
                boolean workspaceValid = GradleImport.isEclipseWorkspaceDir((File)workspace);
                if (workspaceValid && (builder = AdtImportBuilder.getBuilder(AdtWorkspaceForm.this.getWizardContext())) != null && (importer = builder.getImporter()) != null) {
                    importer.setEclipseWorkspace(workspace);
                    builder.readProjects();
                    AdtWorkspaceForm.this.updateStep();
                }
            }
        });
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStep() {
        if (this.myIgnore) {
            return;
        }
        super.updateStep();
        GradleImport importer = AdtImportProvider.getImporter(this.getWizardContext());
        if (importer != null) {
            File eclipseWorkspace = importer.getEclipseWorkspace();
            if (eclipseWorkspace != null && eclipseWorkspace.exists()) {
                try {
                    this.myIgnore = true;
                    this.myWorkspaceField.setText(eclipseWorkspace.getPath());
                }
                finally {
                    this.myIgnore = false;
                }
            }
            Map map = importer.getPathMap();
            for (Map.Entry entry : map.entrySet()) {
                if (this.myPathMap.get(entry.getKey()) != null) continue;
                this.myPathMap.put((String)entry.getKey(), (File)entry.getValue());
            }
            PathMapModel model = new PathMapModel(this.myPathMap);
            this.myPathMapTable.setModel((TableModel)model);
        }
    }

    public void updateDataModel() {
        AdtImportBuilder builder = AdtImportBuilder.getBuilder(this.getWizardContext());
        if (builder != null) {
            GradleImport importer = builder.getImporter();
            if (importer != null) {
                File workspace = new File(this.myWorkspaceField.getText().trim());
                if (workspace.exists()) {
                    importer.setEclipseWorkspace(workspace);
                }
                importer.getPathMap().putAll(this.myPathMap);
            }
            builder.readProjects();
        }
    }

    public boolean isStepVisible() {
        GradleImport importer = AdtImportProvider.getImporter(this.getWizardContext());
        return importer != null && !importer.getPathMap().isEmpty();
    }

    public boolean validate() throws ConfigurationException {
        for (Map.Entry<String, File> entry : this.myPathMap.entrySet()) {
            String path = entry.getKey();
            File file = entry.getValue();
            if (file == null) {
                throw new ConfigurationException("Enter a value for workspace path " + path);
            }
            if (file.exists()) continue;
            throw new ConfigurationException(file.getPath() + " does not exist");
        }
        return super.validate();
    }

    public String getName() {
        return "Eclipse Workspace Location";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myWorkspaceField.getTextField();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(500, 149));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>This project refers to Eclipse workspace relative paths in its project metadata. To help import the project, please point to an Eclipse workspace directory.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 7, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html>Alternatively, you can fill in the actual path map in the table below:</html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 9, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 9, 0, 1, 0, null, new Dimension(-1, 20), null));
        this.myWorkspaceField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPathMapTable = jBTable = new JBTable();
        jPanel.add((Component)jBTable, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class PathMapModel
    extends AbstractTableModel
    implements EditableModel {
        private Map<String, File> myPathMap;
        private String[] myKeys;

        public PathMapModel(Map<String, File> map) {
            this.myKeys = map.keySet().toArray(new String[map.size()]);
            Arrays.sort(this.myKeys);
            this.myPathMap = map;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myKeys.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            String key = this.myKeys[row];
            switch (col) {
                case 0: {
                    return key;
                }
            }
            File file = this.myPathMap.get(key);
            if (file != null) {
                return file.getPath();
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Workspace Path";
                }
                case 1: {
                    return "Actual Path";
                }
            }
            assert (false) : column;
            return "";
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            String string = aValue.toString();
            this.myPathMap.put(this.myKeys[row], !string.isEmpty() ? new File(string) : null);
            AdtImportBuilder builder = AdtImportBuilder.getBuilder(AdtWorkspaceForm.this.getWizardContext());
            if (builder != null) {
                builder.readProjects();
            }
        }

        public void addRow() {
            throw new UnsupportedOperationException();
        }

        public void removeRow(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            String temp = this.myKeys[oldIndex];
            this.myKeys[oldIndex] = this.myKeys[newIndex];
            this.myKeys[newIndex] = temp;
        }
    }
}

