/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependency;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.dependency.DependencySet;
import com.android.tools.idea.gradle.dependency.LibraryDependency;
import com.android.tools.idea.gradle.dependency.ModuleDependency;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class Dependency {
    static final List<DependencyScope> SUPPORTED_SCOPES = Lists.newArrayList((Object[])new DependencyScope[]{DependencyScope.COMPILE, DependencyScope.TEST});
    @NotNull
    private DependencyScope myScope;

    Dependency() {
        this(DependencyScope.COMPILE);
    }

    Dependency(@NotNull DependencyScope scope) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "<init>"));
        }
        this.setScope(scope);
    }

    @NotNull
    public final DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/Dependency", "getScope"));
        }
        return dependencyScope;
    }

    void setScope(@NotNull DependencyScope scope) throws IllegalArgumentException {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "setScope"));
        }
        if (!SUPPORTED_SCOPES.contains(scope)) {
            String msg = String.format("'%1$s' is not a supported scope. Supported scopes are %2$s.", scope, SUPPORTED_SCOPES);
            throw new IllegalArgumentException(msg);
        }
        this.myScope = scope;
    }

    @NotNull
    public static DependencySet extractFrom(@NotNull IdeaAndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "extractFrom"));
        }
        DependencySet dependencies = new DependencySet();
        Variant selectedVariant = androidProject.getSelectedVariant();
        AndroidArtifact testArtifact = androidProject.findInstrumentationTestArtifactInSelectedVariant();
        if (testArtifact != null) {
            Dependency.populate(dependencies, testArtifact, DependencyScope.TEST);
        }
        AndroidArtifact mainArtifact = selectedVariant.getMainArtifact();
        Dependency.populate(dependencies, mainArtifact, DependencyScope.COMPILE);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/Dependency", "extractFrom"));
        }
        return dependencySet;
    }

    private static void populate(@NotNull DependencySet dependencies, @NotNull AndroidArtifact androidArtifact, @NotNull DependencyScope scope) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "populate"));
        }
        if (androidArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/dependency/Dependency", "populate"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/dependency/Dependency", "populate"));
        }
        Dependency.addJavaLibraries(dependencies, androidArtifact.getDependencies().getJavaLibraries(), scope);
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary lib : androidArtifact.getDependencies().getLibraries()) {
            ModuleDependency mainDependency = null;
            String gradleProjectPath = lib.getProject();
            if (StringUtil.isNotEmpty((String)gradleProjectPath)) {
                mainDependency = new ModuleDependency(gradleProjectPath, scope);
                dependencies.add(mainDependency);
            }
            if (mainDependency == null) {
                Dependency.addLibrary(lib, dependencies, scope, unique);
                continue;
            }
            LibraryDependency backup = Dependency.createLibraryDependency(lib, scope);
            mainDependency.setBackupDependency(backup);
        }
        for (String gradleProjectPath : androidArtifact.getDependencies().getProjects()) {
            if (gradleProjectPath == null || gradleProjectPath.isEmpty()) continue;
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependencies.add(dependency);
        }
    }

    @NotNull
    private static String getLibraryName(@NotNull AndroidLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "getLibraryName"));
        }
        File bundle = library.getBundle();
        String string = FileUtil.getNameWithoutExtension((File)bundle);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/Dependency", "getLibraryName"));
        }
        return string;
    }

    private static void addLibrary(@NotNull AndroidLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "addLibrary"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/dependency/Dependency", "addLibrary"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/dependency/Dependency", "addLibrary"));
        }
        if (unique == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/gradle/dependency/Dependency", "addLibrary"));
        }
        File folder = library.getFolder();
        if (unique.contains(folder)) {
            return;
        }
        unique.add(folder);
        LibraryDependency dependency = Dependency.createLibraryDependency(library, scope);
        dependencies.add(dependency);
        for (AndroidLibrary dependentLibrary : library.getLibraryDependencies()) {
            Dependency.addLibrary(dependentLibrary, dependencies, scope, unique);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependency(@NotNull AndroidLibrary library, @NotNull DependencyScope scope) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "createLibraryDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/dependency/Dependency", "createLibraryDependency"));
        }
        LibraryDependency dependency = new LibraryDependency(Dependency.getLibraryName(library), scope);
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getJarFile());
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getResFolder());
        for (File localJar : library.getLocalJars()) {
            dependency.addPath(LibraryDependency.PathType.BINARY, localJar);
        }
        LibraryDependency libraryDependency = dependency;
        if (libraryDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependency/Dependency", "createLibraryDependency"));
        }
        return libraryDependency;
    }

    private static void addJavaLibraries(@NotNull DependencySet dependencies, @NotNull Collection<JavaLibrary> libraries, @NotNull DependencyScope scope) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/dependency/Dependency", "addJavaLibraries"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/dependency/Dependency", "addJavaLibraries"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/dependency/Dependency", "addJavaLibraries"));
        }
        for (JavaLibrary library : libraries) {
            File jar = library.getJarFile();
            dependencies.add(new LibraryDependency(jar, scope));
        }
    }
}

