/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer;

import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.FilePaths;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class AbstractContentRootModuleCustomizer<T>
implements ModuleCustomizer<T> {
    private static final Logger LOG = Logger.getInstance(AbstractContentRootModuleCustomizer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customizeModule(@NotNull Module module, @NotNull Project project, @Nullable T model) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "customizeModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "customizeModule"));
        }
        if (model == null) {
            return;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        try {
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                rootModel.removeContentEntry(contentEntry);
            }
            Collection<ContentEntry> contentEntries = this.findOrCreateContentEntries(rootModel, model);
            ArrayList orphans = Lists.newArrayList();
            this.setUpContentEntries(module, contentEntries, model, orphans);
            for (RootSourceFolder orphan : orphans) {
                File path = orphan.getPath();
                ContentEntry contentEntry = rootModel.addContentEntry(FilePaths.pathToIdeaUrl(path));
                AbstractContentRootModuleCustomizer.addSourceFolder(contentEntry, path, orphan.getType(), orphan.isGenerated());
            }
        }
        finally {
            rootModel.commit();
        }
    }

    @NotNull
    protected abstract Collection<ContentEntry> findOrCreateContentEntries(@NotNull ModifiableRootModel var1, @NotNull T var2);

    protected abstract void setUpContentEntries(@NotNull Module var1, @NotNull Collection<ContentEntry> var2, @NotNull T var3, @NotNull List<RootSourceFolder> var4);

    protected void addSourceFolder(@NotNull Collection<ContentEntry> contentEntries, @NotNull File folderPath, @NotNull JpsModuleSourceRootType type, boolean generated, @NotNull List<RootSourceFolder> orphans) {
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (orphans == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addSourceFolder"));
        }
        ContentEntry parent = this.findParentContentEntry(contentEntries, folderPath);
        if (parent == null) {
            orphans.add(new RootSourceFolder(folderPath, type, generated));
            return;
        }
        AbstractContentRootModuleCustomizer.addSourceFolder(parent, folderPath, type, generated);
    }

    private static void addSourceFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath, @NotNull JpsModuleSourceRootType type, boolean generated) {
        JpsModuleSourceRoot sourceRoot;
        JpsElement properties;
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addSourceFolder"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addSourceFolder"));
        }
        String url = FilePaths.pathToIdeaUrl(folderPath);
        SourceFolder sourceFolder = contentEntry.addSourceFolder(url, type);
        if (generated && (properties = (sourceRoot = sourceFolder.getJpsElement()).getProperties()) instanceof JavaSourceRootProperties) {
            ((JavaSourceRootProperties)properties).setForGeneratedSources(true);
        }
    }

    protected boolean addExcludedFolder(@NotNull ContentEntry contentEntry, @NotNull File dirPath) {
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addExcludedFolder"));
        }
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "addExcludedFolder"));
        }
        if (!FilePaths.isPathInContentEntry(dirPath, contentEntry)) {
            return false;
        }
        contentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(dirPath));
        return true;
    }

    @Nullable
    protected ContentEntry findParentContentEntry(@NotNull Collection<ContentEntry> contentEntries, @NotNull File dirPath) {
        if (contentEntries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "findParentContentEntry"));
        }
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer", "findParentContentEntry"));
        }
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(dirPath, contentEntry)) continue;
            return contentEntry;
        }
        LOG.info(String.format("Failed to find content entry for file '%1$s'", dirPath.getPath()));
        return null;
    }

    protected static class RootSourceFolder {
        @NotNull
        private final File myPath;
        @NotNull
        private final JpsModuleSourceRootType myType;
        private final boolean myGenerated;

        protected RootSourceFolder(@NotNull File path, @NotNull JpsModuleSourceRootType type, boolean generated) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer$RootSourceFolder", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer$RootSourceFolder", "<init>"));
            }
            this.myPath = path;
            this.myType = type;
            this.myGenerated = generated;
        }

        @NotNull
        protected File getPath() {
            File file = this.myPath;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer$RootSourceFolder", "getPath"));
            }
            return file;
        }

        @NotNull
        protected JpsModuleSourceRootType getType() {
            JpsModuleSourceRootType jpsModuleSourceRootType = this.myType;
            if (jpsModuleSourceRootType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/AbstractContentRootModuleCustomizer$RootSourceFolder", "getType"));
            }
            return jpsModuleSourceRootType;
        }

        protected boolean isGenerated() {
            return this.myGenerated;
        }
    }
}

