/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanImportProjectAction
extends AnAction {
    private static final String MESSAGE_FORMAT = "This action will:\n1. Close project '%1$s'\n2. Delete all project files (.idea folder and .iml files)\n3. Import the project\n\nYou will lose custom project-wide settings. Are you sure you want to continue?";
    private static final String TITLE = "Close, Clean and Re-Import Project";
    private static final Logger LOG = Logger.getInstance(CleanImportProjectAction.class);

    public CleanImportProjectAction() {
        super(TITLE);
    }

    public void actionPerformed(AnActionEvent e) {
        String projectName;
        int answer;
        Project project = e.getProject();
        if (project != null && CleanImportProjectAction.isGradleProject(project) && (answer = Messages.showYesNoDialog((Project)project, (String)String.format(MESSAGE_FORMAT, projectName = project.getName()), (String)TITLE, null)) == 0) {
            LOG.info(String.format("Closing, cleaning and re-importing project '%1$s'...", projectName));
            List<File> filesToDelete = CleanImportProjectAction.collectFilesToDelete(project);
            File projectDir = new File(project.getBasePath());
            CleanImportProjectAction.close(project);
            CleanImportProjectAction.delete(filesToDelete, projectName);
            try {
                LOG.info(String.format("About to import project '%1$s'.", projectName));
                GradleProjectImporter.getInstance().importProject(projectName, projectDir, null);
                LOG.info(String.format("Done importing project '%1$s'.", projectName));
            }
            catch (Exception error) {
                String title = CleanImportProjectAction.getErrorMessageTitle(error);
                Messages.showErrorDialog((String)error.getMessage(), (String)title);
                LOG.info(String.format("Failed to import project '%1$s'.", projectName));
            }
        }
    }

    @NotNull
    private static List<File> collectFilesToDelete(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "collectFilesToDelete"));
        }
        VirtualFile projectFile = project.getProjectFile();
        if (projectFile == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "collectFilesToDelete"));
            }
            return list;
        }
        ArrayList filesToDelete = Lists.newArrayList();
        filesToDelete.add(VfsUtilCore.virtualToIoFile((VirtualFile)projectFile.getParent()));
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            VirtualFile moduleFile = module.getModuleFile();
            if (moduleFile == null) continue;
            filesToDelete.add(VfsUtilCore.virtualToIoFile((VirtualFile)moduleFile));
        }
        ArrayList arrayList = filesToDelete;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "collectFilesToDelete"));
        }
        return arrayList;
    }

    private static void close(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "close"));
        }
        String projectName = project.getName();
        ProjectUtil.closeAndDispose((Project)project);
        RecentProjectsManagerBase.getInstance().updateLastProjectPath();
        WelcomeFrame.showIfNoProjectOpened();
        LOG.info(String.format("Closed project '%1$s'.", projectName));
    }

    private static void delete(final @NotNull List<File> files, @NotNull String projectName) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "delete"));
        }
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "delete"));
        }
        Project project = ProjectManager.getInstance().getDefaultProject();
        String title = String.format("Cleaning up project '%1$s", projectName);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/actions/CleanImportProjectAction$1", "run"));
                }
                indicator.setFraction(0.0);
                int fileCount = files.size();
                for (int i = 0; i < fileCount; ++i) {
                    File file = (File)files.get(i);
                    String path = file.getPath();
                    LOG.info(String.format("About to delete file '%1$s'", path));
                    if (!FileUtil.delete((File)file)) {
                        LOG.info(String.format("Failed to delete file '%1$s'", path));
                    }
                    indicator.setFraction((double)(i / fileCount));
                }
                indicator.setFraction(1.0);
            }
        });
    }

    @NotNull
    private static String getErrorMessageTitle(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "getErrorMessageTitle"));
        }
        if (e instanceof ConfigurationException) {
            String string = ((ConfigurationException)((Object)e)).getTitle();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "getErrorMessageTitle"));
            }
            return string;
        }
        if (TITLE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/actions/CleanImportProjectAction", "getErrorMessageTitle"));
        }
        return TITLE;
    }

    public void update(AnActionEvent e) {
        boolean isGradleProject = CleanImportProjectAction.isGradleProject(e.getProject());
        Presentation presentation = e.getPresentation();
        presentation.setVisible(isGradleProject);
        presentation.setEnabled(isGradleProject);
    }

    private static boolean isGradleProject(@Nullable Project project) {
        return project != null && Projects.isGradleProject(project);
    }
}

