/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.ProjectValidator;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.stats.StatsTimeCollector;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleSyncState {
    private static final Logger LOG = Logger.getInstance(GradleSyncState.class);
    private static final List<String> PROJECT_PREFERENCES_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsConfigurable", "com.intellij.uiDesigner.GuiDesignerConfigurable", "org.jetbrains.plugins.groovy.gant.GantConfigurable", "org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable", "org.jetbrains.android.compiler.AndroidDexCompilerSettingsConfigurable", "org.jetbrains.idea.maven.utils.MavenSettings", "com.intellij.compiler.options.CompilerConfigurable"});
    public static final Topic<GradleSyncListener> GRADLE_SYNC_TOPIC = new Topic("Project sync with Gradle", GradleSyncListener.class);
    private static final Key<Long> PROJECT_LAST_SYNC_TIMESTAMP_KEY = Key.create((String)"android.gradle.project.last.sync.timestamp");
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    private volatile boolean mySyncInProgress;

    @NotNull
    public static GradleSyncState getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/GradleSyncState", "getInstance"));
        }
        GradleSyncState gradleSyncState = (GradleSyncState)ServiceManager.getService((Project)project, GradleSyncState.class);
        if (gradleSyncState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleSyncState", "getInstance"));
        }
        return gradleSyncState;
    }

    public GradleSyncState(@NotNull Project project, @NotNull MessageBus messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/GradleSyncState", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/GradleSyncState", "<init>"));
        }
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    public void syncStarted(boolean notifyUser) {
        StatsTimeCollector.start("sync-time");
        this.mySyncInProgress = true;
        if (notifyUser) {
            this.notifyUser();
        }
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncStarted(GradleSyncState.this.myProject);
            }
        });
    }

    public void syncFailed(final @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/GradleSyncState", "syncFailed"));
        }
        this.syncFinished();
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncFailed(GradleSyncState.this.myProject, message);
                ProjectValidator.mergeQueuedMessages(GradleSyncState.this.myProject);
            }
        });
    }

    public void syncEnded() {
        LintUtils.sTryPrefixLookup = true;
        this.syncFinished();
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleSyncListener)GradleSyncState.this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSucceeded(GradleSyncState.this.myProject);
                ProjectValidator.mergeQueuedMessages(GradleSyncState.this.myProject);
            }
        });
    }

    private void syncFinished() {
        this.mySyncInProgress = false;
        this.setLastGradleSyncTimestamp(System.currentTimeMillis());
        StatsTimeCollector.stop("sync-time");
        this.notifyUser();
        this.cleanUpProjectPreferences();
    }

    private void syncPublisher(@NotNull Runnable publishingTask) {
        if (publishingTask == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/GradleSyncState", "syncPublisher"));
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)publishingTask);
    }

    public void notifyUser() {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                VirtualFile[] files;
                EditorNotifications notifications = EditorNotifications.getInstance((Project)GradleSyncState.this.myProject);
                for (VirtualFile file : files = FileEditorManager.getInstance((Project)GradleSyncState.this.myProject).getOpenFiles()) {
                    try {
                        notifications.updateNotifications(file);
                    }
                    catch (Throwable e) {
                        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
                        String msg = String.format("Failed to update editor notifications for file '%1$s'", filePath);
                        LOG.info(msg, e);
                    }
                }
                notifications.updateAllNotifications();
                BuildVariantView.getInstance(GradleSyncState.this.myProject).updateContents();
            }
        });
    }

    public boolean isSyncInProgress() {
        return this.mySyncInProgress;
    }

    public void setLastGradleSyncTimestamp(long timestamp) {
        this.myProject.putUserData(PROJECT_LAST_SYNC_TIMESTAMP_KEY, (Object)timestamp);
    }

    public long getLastGradleSyncTimestamp() {
        Long timestamp = (Long)this.myProject.getUserData(PROJECT_LAST_SYNC_TIMESTAMP_KEY);
        return timestamp != null ? timestamp : -1L;
    }

    @NotNull
    public ThreeState isSyncNeeded() {
        long lastSync = this.getLastGradleSyncTimestamp();
        if (lastSync < 0L) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleSyncState", "isSyncNeeded"));
            }
            return threeState;
        }
        ThreeState threeState = this.isSyncNeeded(lastSync) ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleSyncState", "isSyncNeeded"));
        }
        return threeState;
    }

    public boolean isSyncNeeded(long referenceTimeInMillis) {
        assert (referenceTimeInMillis > 0L);
        if (this.mySyncInProgress) {
            return false;
        }
        File settingsFilePath = new File(this.myProject.getBasePath(), "settings.gradle");
        if (settingsFilePath.exists() && settingsFilePath.lastModified() > referenceTimeInMillis) {
            return true;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            File buildFilePath;
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            if (buildFile == null || (buildFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile)).lastModified() <= referenceTimeInMillis) continue;
            return true;
        }
        return false;
    }

    private void cleanUpProjectPreferences() {
        if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
            return;
        }
        try {
            ExtensionPoint projectConfigurable = Extensions.getArea((AreaInstance)this.myProject).getExtensionPoint(Configurable.PROJECT_CONFIGURABLE);
            GradleUtil.cleanUpPreferences((ExtensionPoint<ConfigurableEP<Configurable>>)projectConfigurable, PROJECT_PREFERENCES_TO_REMOVE);
        }
        catch (Throwable e) {
            String msg = String.format("Failed to clean up preferences for project '%1$s'", this.myProject.getName());
            LOG.info(msg, e);
        }
    }
}

