/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.navigation.ActivityState;
import com.android.navigation.Dimension;
import com.android.navigation.Listener;
import com.android.navigation.Locator;
import com.android.navigation.MenuState;
import com.android.navigation.NavigationModel;
import com.android.navigation.Point;
import com.android.navigation.State;
import com.android.navigation.Transition;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.AndroidRootComponent;
import com.android.tools.idea.editors.navigation.Assoc;
import com.android.tools.idea.editors.navigation.NavigationEditor;
import com.android.tools.idea.editors.navigation.RenderingParameters;
import com.android.tools.idea.editors.navigation.Selections;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.Analyser;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.ShadowPainter;
import com.android.tools.idea.wizard.NewTemplateObjectWizard;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationView
extends JComponent {
    private static final Logger LOG = Logger.getInstance((String)("#" + NavigationView.class.getName()));
    public static final Dimension GAP = new Dimension(500, 100);
    private static final Color BACKGROUND_COLOR = new JBColor((Color)Gray.get((int)192), (Color)Gray.get((int)70));
    private static final Color SNAP_GRID_LINE_COLOR_MINOR = new JBColor((Color)Gray.get((int)180), (Color)Gray.get((int)60));
    private static final Color SNAP_GRID_LINE_COLOR_MIDDLE = new JBColor((Color)Gray.get((int)170), (Color)Gray.get((int)50));
    private static final Color SNAP_GRID_LINE_COLOR_MAJOR = new JBColor((Color)Gray.get((int)160), (Color)Gray.get((int)40));
    private static final float ZOOM_FACTOR = 1.1f;
    private static final int MINOR_SNAP = 32;
    private static final int MIDDLE_COUNT = 5;
    private static final int MAJOR_COUNT = 10;
    public static final java.awt.Dimension MINOR_SNAP_GRID = new java.awt.Dimension(32, 32);
    public static final java.awt.Dimension MIDDLE_SNAP_GRID = Utilities.scale(MINOR_SNAP_GRID, 5.0f);
    public static final java.awt.Dimension MAJOR_SNAP_GRID = Utilities.scale(MINOR_SNAP_GRID, 10.0f);
    public static final int MIN_GRID_LINE_SEPARATION = 8;
    public static final int LINE_WIDTH = 12;
    private static final java.awt.Point MULTIPLE_DROP_STRIDE = Utilities.point(MAJOR_SNAP_GRID);
    private static final String ID_PREFIX = "@+id/";
    private static final Color TRANSITION_LINE_COLOR = new JBColor(new Color(80, 80, 255), new Color(40, 40, 255));
    private static final Condition<Component> SCREENS = Utilities.instanceOf(AndroidRootComponent.class);
    private static final Condition<Component> EDITORS = Utilities.not(SCREENS);
    private static final boolean DRAW_DESTINATION_RECTANGLES = false;
    private static final boolean DEBUG = false;
    private final RenderingParameters myRenderingParams;
    private final NavigationModel myNavigationModel;
    private final Assoc<State, AndroidRootComponent> myStateComponentAssociation = new Assoc();
    private final Assoc<Transition, Component> myTransitionEditorAssociation = new Assoc();
    private boolean myStateCacheIsValid;
    private boolean myTransitionEditorCacheIsValid;
    @NotNull
    private Selections.Selection mySelection = Selections.NULL;
    private Map<State, Map<String, RenderedView>> myLocationToRenderedView = new IdentityHashMap<State, Map<String, RenderedView>>();
    private Image myBackgroundImage;
    private java.awt.Point myMouseLocation;
    private Transform myTransform = new Transform(0.25f);
    private boolean showRollover = false;
    private boolean mDrawGrid = false;

    @Nullable
    private static AndroidFacet getAndroidFacet(@NotNull Project project, @NotNull NavigationEditor.ErrorHandler handler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationView", "getAndroidFacet"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/navigation/NavigationView", "getAndroidFacet"));
        }
        AndroidFacet result = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            if (result == null) {
                result = facet;
                continue;
            }
            handler.handleError("", "Sorry, Navigation Editor does not yet support multiple module projects. ");
            return null;
        }
        return result;
    }

    @Nullable
    public static RenderingParameters getRenderingParams(@NotNull Project project, @NotNull VirtualFile file, @NotNull NavigationEditor.ErrorHandler handler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationView", "getRenderingParams"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/navigation/NavigationView", "getRenderingParams"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/navigation/NavigationView", "getRenderingParams"));
        }
        AndroidFacet facet = NavigationView.getAndroidFacet(project, handler);
        if (facet == null) {
            return null;
        }
        Configuration configuration = facet.getConfigurationManager().getConfiguration(file);
        return new RenderingParameters(project, configuration, facet);
    }

    public NavigationView(RenderingParameters renderingParams, NavigationModel model) {
        this.myRenderingParams = renderingParams;
        this.myNavigationModel = model;
        this.setFocusable(true);
        this.setLayout(null);
        MyMouseListener mouseListener = new MyMouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                NavigationView.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NavigationView.this.repaint();
            }
        });
        DnDManager dndManager = DnDManager.getInstance();
        dndManager.registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this);
        AbstractAction remove = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigationView.this.mySelection.remove();
                NavigationView.this.setSelection(Selections.NULL);
            }
        };
        this.registerKeyBinding(127, "delete", remove);
        this.registerKeyBinding(8, "backspace", remove);
        this.myNavigationModel.getListeners().add((NavigationModel.Event)((Object)new Listener<NavigationModel.Event>(){

            @Override
            public void notify(@NotNull NavigationModel.Event event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationView$3", "notify"));
                }
                if (event.operandType.isAssignableFrom(State.class)) {
                    NavigationView.this.myStateCacheIsValid = false;
                }
                if (event.operandType.isAssignableFrom(Transition.class)) {
                    NavigationView.this.myTransitionEditorCacheIsValid = false;
                }
                NavigationView.this.revalidate();
                NavigationView.this.repaint();
            }
        }));
    }

    @Nullable
    private static RenderedView getRenderedView(AndroidRootComponent c, java.awt.Point location) {
        return c.getRenderedView(Utilities.diff(location, c.getLocation()));
    }

    @Nullable
    Transition getTransition(AndroidRootComponent sourceComponent, @Nullable RenderedView namedSourceLeaf, java.awt.Point mouseUpLocation) {
        Component destComponent = this.getComponentAt(mouseUpLocation);
        if (sourceComponent != destComponent && destComponent instanceof AndroidRootComponent) {
            AndroidRootComponent destinationRoot = (AndroidRootComponent)destComponent;
            RenderedView endLeaf = NavigationView.getRenderedView(destinationRoot, mouseUpLocation);
            RenderedView namedEndLeaf = NavigationView.getNamedParent(endLeaf);
            Map rootComponentToState = this.getStateComponentAssociation().valueToKey;
            Locator sourceLocator = Locator.of((State)rootComponentToState.get(sourceComponent), NavigationView.getViewId(namedSourceLeaf));
            Locator destinationLocator = Locator.of((State)rootComponentToState.get(destComponent), NavigationView.getViewId(namedEndLeaf));
            return new Transition("", sourceLocator, destinationLocator);
        }
        return null;
    }

    static Rectangle getBounds(AndroidRootComponent c, @Nullable RenderedView leaf) {
        if (leaf == null) {
            return c.getBounds();
        }
        Rectangle r = c.transform.getBounds(leaf);
        return new Rectangle(c.getX() + r.x, c.getY() + r.y, r.width, r.height);
    }

    Rectangle getNamedLeafBoundsAt(Component sourceComponent, java.awt.Point location) {
        Component destComponent = this.getComponentAt(location);
        if (sourceComponent != destComponent && destComponent instanceof AndroidRootComponent) {
            AndroidRootComponent destinationRoot = (AndroidRootComponent)destComponent;
            RenderedView endLeaf = NavigationView.getRenderedView(destinationRoot, location);
            RenderedView namedEndLeaf = NavigationView.getNamedParent(endLeaf);
            return NavigationView.getBounds(destinationRoot, namedEndLeaf);
        }
        return new Rectangle(location);
    }

    public float getScale() {
        return this.myTransform.myScale;
    }

    public void setScale(float scale) {
        this.myTransform = new Transform(scale);
        this.myBackgroundImage = null;
        for (AndroidRootComponent root : this.getStateComponentAssociation().keyToValue.values()) {
            root.setScale(scale);
        }
        this.setPreferredSize();
        this.revalidate();
        this.repaint();
    }

    public void zoom(boolean in) {
        this.setScale(this.myTransform.myScale * (in ? 1.1f : 0.9090909f));
    }

    private Assoc<State, AndroidRootComponent> getStateComponentAssociation() {
        if (!this.myStateCacheIsValid) {
            this.syncStateCache(this.myStateComponentAssociation);
            this.myStateCacheIsValid = true;
        }
        return this.myStateComponentAssociation;
    }

    private Assoc<Transition, Component> getTransitionEditorAssociation() {
        if (!this.myTransitionEditorCacheIsValid) {
            this.syncTransitionCache(this.myTransitionEditorAssociation);
            this.myTransitionEditorCacheIsValid = true;
        }
        return this.myTransitionEditorAssociation;
    }

    @Nullable
    static String getViewId(@Nullable RenderedView leaf) {
        String attributeValue;
        XmlTag tag;
        if (leaf != null && (tag = leaf.tag) != null && (attributeValue = tag.getAttributeValue("android:id")) != null && attributeValue.startsWith(ID_PREFIX)) {
            return attributeValue.substring(ID_PREFIX.length());
        }
        return null;
    }

    @Nullable
    static RenderedView getNamedParent(@Nullable RenderedView view) {
        while (view != null && NavigationView.getViewId(view) == null) {
            view = view.getParent();
        }
        return view;
    }

    private Map<String, RenderedView> getNameToRenderedView(State state) {
        Map<String, RenderedView> result = this.myLocationToRenderedView.get(state);
        if (result == null) {
            RenderedView root = ((AndroidRootComponent)this.getStateComponentAssociation().keyToValue.get(state)).getRootView();
            if (root != null) {
                result = NavigationView.createViewNameToRenderedView(root);
                this.myLocationToRenderedView.put(state, result);
            } else {
                return Collections.emptyMap();
            }
        }
        return result;
    }

    private static Map<String, RenderedView> createViewNameToRenderedView(@NotNull RenderedView root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationView", "createViewNameToRenderedView"));
        }
        final HashMap<String, RenderedView> result = new HashMap<String, RenderedView>();
        new Object(){

            void walk(RenderedView parent) {
                for (RenderedView child : parent.getChildren()) {
                    String id = NavigationView.getViewId(child);
                    if (id != null) {
                        result.put(id, child);
                    }
                    this.walk(child);
                }
            }
        }.walk(root);
        return result;
    }

    static void paintLeaf(Graphics g, @Nullable RenderedView leaf, Color color, AndroidRootComponent component) {
        if (leaf != null) {
            Color oldColor = g.getColor();
            g.setColor(color);
            NavigationView.drawRectangle(g, NavigationView.getBounds(component, leaf));
            g.setColor(oldColor);
        }
    }

    private void registerKeyBinding(int keyCode, String name, Action action) {
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(keyCode, 0), name);
        this.getActionMap().put(name, action);
    }

    private void setSelection(@NotNull Selections.Selection selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationView", "setSelection"));
        }
        this.mySelection = selection;
        this.revalidate();
        this.repaint();
    }

    private void moveSelection(java.awt.Point location) {
        this.mySelection.moveTo(location);
        this.revalidate();
        this.repaint();
    }

    private void setMouseLocation(java.awt.Point mouseLocation) {
        this.myMouseLocation = mouseLocation;
        if (this.showRollover) {
            this.repaint();
        }
    }

    private void finaliseSelectionLocation(java.awt.Point location) {
        this.mySelection = this.mySelection.finaliseSelectionLocation(location);
        this.revalidate();
        this.repaint();
    }

    private void drawGrid(Graphics g, Color c, java.awt.Dimension modelSize, int width, int height) {
        g.setColor(c);
        java.awt.Dimension viewSize = this.myTransform.modelToView(Dimension.create(modelSize));
        if (viewSize.width < 8 || viewSize.height < 8) {
            return;
        }
        for (int x = 0; x < this.myTransform.viewToModelW(width); x += modelSize.width) {
            int vx = this.myTransform.modelToViewX(x);
            g.drawLine(vx, 0, vx, this.getHeight());
        }
        for (int y = 0; y < this.myTransform.viewToModelH(height); y += modelSize.height) {
            int vy = this.myTransform.modelToViewY(y);
            g.drawLine(0, vy, this.getWidth(), vy);
        }
    }

    private void drawBackground(Graphics g, int width, int height) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, width, height);
        this.drawGrid(g, SNAP_GRID_LINE_COLOR_MINOR, MINOR_SNAP_GRID, width, height);
        this.drawGrid(g, SNAP_GRID_LINE_COLOR_MIDDLE, MIDDLE_SNAP_GRID, width, height);
        this.drawGrid(g, SNAP_GRID_LINE_COLOR_MAJOR, MAJOR_SNAP_GRID, width, height);
    }

    private Image getBackGroundImage() {
        if (this.myBackgroundImage == null || this.myBackgroundImage.getWidth(null) != this.getWidth() || this.myBackgroundImage.getHeight(null) != this.getHeight()) {
            this.myBackgroundImage = UIUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)1);
            this.drawBackground(this.myBackgroundImage.getGraphics(), this.getWidth(), this.getHeight());
        }
        return this.myBackgroundImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mDrawGrid) {
            g.drawImage(this.getBackGroundImage(), 0, 0, null);
        } else {
            Color tmp = this.getBackground();
            g.setColor(BACKGROUND_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(tmp);
        }
        for (AndroidRootComponent c : this.getStateComponentAssociation().keyToValue.values()) {
            Rectangle r = c.getBounds();
            ShadowPainter.drawRectangleShadow(g, r.x, r.y, r.width, r.height);
        }
    }

    public static Graphics2D createLineGraphics(Graphics g, int lineWidth) {
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setColor(TRANSITION_LINE_COLOR);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setStroke(new BasicStroke(lineWidth));
        return g2D;
    }

    private static Rectangle getCorner(java.awt.Point a, int cornerDiameter) {
        int cornerRadius = cornerDiameter / 2;
        return new Rectangle(a.x - cornerRadius, a.y - cornerRadius, cornerDiameter, cornerDiameter);
    }

    private static void drawLine(Graphics g, java.awt.Point a, java.awt.Point b) {
        g.drawLine(a.x, a.y, b.x, b.y);
    }

    private static void drawArrow(Graphics g, java.awt.Point a, java.awt.Point b, int lineWidth) {
        Utilities.drawArrow(g, a.x, a.y, b.x, b.y, lineWidth);
    }

    private static void drawRectangle(Graphics g, Rectangle r) {
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private static int x1(Rectangle src) {
        return src.x;
    }

    private static int x2(Rectangle dst) {
        return dst.x + dst.width;
    }

    private static int y1(Rectangle src) {
        return src.y;
    }

    private static int y2(Rectangle dst) {
        return dst.y + dst.height;
    }

    static Line getMidLine(Rectangle src, Rectangle dst) {
        int dy;
        boolean horizontal;
        java.awt.Point midSrc = Utilities.centre(src);
        java.awt.Point midDst = Utilities.centre(dst);
        int dx = Math.abs(midSrc.x - midDst.x);
        boolean bl = horizontal = dx >= (dy = Math.abs(midSrc.y - midDst.y));
        int middle = horizontal ? (NavigationView.x1(src) - NavigationView.x2(dst) > 0 ? (NavigationView.x2(dst) + NavigationView.x1(src)) / 2 : (NavigationView.x2(src) + NavigationView.x1(dst)) / 2) : (NavigationView.y1(src) - NavigationView.y2(dst) > 0 ? (NavigationView.y2(dst) + NavigationView.y1(src)) / 2 : (NavigationView.y2(src) + NavigationView.y1(dst)) / 2);
        java.awt.Point a = horizontal ? new java.awt.Point(middle, midSrc.y) : new java.awt.Point(midSrc.x, middle);
        java.awt.Point b = horizontal ? new java.awt.Point(middle, midDst.y) : new java.awt.Point(midDst.x, middle);
        return new Line(a, b);
    }

    private Line getMidLine(Transition t) {
        Map m = this.getStateComponentAssociation().keyToValue;
        State src = t.getSource().getState();
        State dst = t.getDestination().getState();
        return NavigationView.getMidLine(((AndroidRootComponent)m.get(src)).getBounds(), ((AndroidRootComponent)m.get(dst)).getBounds());
    }

    static java.awt.Point[] getControlPoints(Rectangle src, Rectangle dst, Line midLine) {
        java.awt.Point a = midLine.project(Utilities.centre(src));
        java.awt.Point b = midLine.project(Utilities.centre(dst));
        return new java.awt.Point[]{Utilities.project(a, src), a, b, Utilities.project(b, dst)};
    }

    private java.awt.Point[] getControlPoints(Transition t) {
        return NavigationView.getControlPoints(this.getBounds(t.getSource()), this.getBounds(t.getDestination()), this.getMidLine(t));
    }

    private static int getTurnLength(java.awt.Point[] points, float scale) {
        int N = points.length;
        int cornerDiameter = (int)((float)Math.min(NavigationView.MAJOR_SNAP_GRID.width, NavigationView.MAJOR_SNAP_GRID.height) * scale);
        for (int i = 0; i < N - 1; ++i) {
            java.awt.Point a = points[i];
            java.awt.Point b = points[i + 1];
            int length = (int)Utilities.length(Utilities.diff(b, a));
            if (i != 0 && i != N - 2) {
                length /= 2;
            }
            cornerDiameter = Math.min(cornerDiameter, length);
        }
        return cornerDiameter;
    }

    private static void drawCurve(Graphics g, java.awt.Point[] points, float scale) {
        int N = points.length;
        int cornerDiameter = NavigationView.getTurnLength(points, scale);
        boolean horizontal = points[0].x != points[1].x;
        java.awt.Point previous = points[0];
        for (int i = 1; i < N - 1; ++i) {
            Rectangle turn = NavigationView.getCorner(points[i], cornerDiameter);
            java.awt.Point startTurn = Utilities.project(previous, turn);
            NavigationView.drawLine(g, previous, startTurn);
            java.awt.Point endTurn = Utilities.project(points[i + 1], turn);
            NavigationView.drawCorner(g, startTurn, endTurn, horizontal);
            previous = endTurn;
            horizontal = !horizontal;
        }
        java.awt.Point endPoint = points[N - 1];
        if (Utilities.length(Utilities.diff(previous, endPoint)) > 1.0) {
            NavigationView.drawArrow(g, previous, endPoint, (int)(12.0f * scale));
        }
    }

    public void drawTransition(Graphics g, Rectangle src, Rectangle dst, java.awt.Point[] controlPoints) {
        NavigationView.drawRectangle(g, src);
        NavigationView.drawCurve(g, controlPoints, this.myTransform.myScale);
    }

    private void drawTransition(Graphics g, Transition t) {
        this.drawTransition(g, this.getBounds(t.getSource()), this.getBounds(t.getDestination()), this.getControlPoints(t));
    }

    public void paintTransitions(Graphics g) {
        for (Transition transition : this.myNavigationModel.getTransitions()) {
            this.drawTransition(g, transition);
        }
    }

    private static int angle(java.awt.Point p) {
        return p.x > 0 ? 0 : (p.y < 0 ? 90 : (p.x < 0 ? 180 : 270));
    }

    private static void drawCorner(Graphics g, java.awt.Point a, java.awt.Point b, boolean horizontal) {
        int radiusX = Math.abs(a.x - b.x);
        int radiusY = Math.abs(a.y - b.y);
        java.awt.Point centre = horizontal ? new java.awt.Point(a.x, b.y) : new java.awt.Point(b.x, a.y);
        int startAngle = NavigationView.angle(Utilities.diff(a, centre));
        int endAngle = NavigationView.angle(Utilities.diff(b, centre));
        int dangle = endAngle - startAngle;
        int angle = dangle - (Math.abs(dangle) <= 180 ? 0 : 360 * Utilities.sign(dangle));
        g.drawArc(centre.x - radiusX, centre.y - radiusY, radiusX * 2, radiusY * 2, startAngle, angle);
    }

    private RenderedView getRenderedView(Locator locator) {
        return this.getNameToRenderedView(locator.getState()).get(locator.getViewName());
    }

    private void paintRollover(Graphics2D lineGraphics) {
        if (this.myMouseLocation == null || !this.showRollover) {
            return;
        }
        Component component = this.getComponentAt(this.myMouseLocation);
        if (component instanceof AndroidRootComponent) {
            Stroke oldStroke = lineGraphics.getStroke();
            lineGraphics.setStroke(new BasicStroke(1.0f));
            AndroidRootComponent androidRootComponent = (AndroidRootComponent)component;
            RenderedView leaf = NavigationView.getRenderedView(androidRootComponent, this.myMouseLocation);
            RenderedView namedLeaf = NavigationView.getNamedParent(leaf);
            NavigationView.paintLeaf(lineGraphics, leaf, (Color)JBColor.RED, androidRootComponent);
            NavigationView.paintLeaf(lineGraphics, namedLeaf, (Color)JBColor.BLUE, androidRootComponent);
            lineGraphics.setStroke(oldStroke);
        }
    }

    private void paintSelection(Graphics g) {
        this.mySelection.paint(g, this.hasFocus());
        this.mySelection.paintOver(g);
    }

    private void paintChildren(Graphics g, Condition<Component> condition) {
        Rectangle bounds = new Rectangle();
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component child = this.getComponent(i);
            if (!condition.value((Object)child)) continue;
            child.getBounds(bounds);
            Graphics cg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            child.paint(cg);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.paintChildren(g, SCREENS);
        Graphics2D lineGraphics = NavigationView.createLineGraphics(g, this.myTransform.modelToViewW(12));
        this.paintTransitions(lineGraphics);
        this.paintRollover(lineGraphics);
        this.paintSelection(g);
        this.paintChildren(g, EDITORS);
    }

    private Rectangle getBounds(Locator source) {
        Map stateToComponent = this.getStateComponentAssociation().keyToValue;
        AndroidRootComponent component = (AndroidRootComponent)stateToComponent.get(source.getState());
        return NavigationView.getBounds(component, this.getRenderedView(source));
    }

    @Override
    public void doLayout() {
        Map transitionToEditor = this.getTransitionEditorAssociation().keyToValue;
        Map stateToComponent = this.getStateComponentAssociation().keyToValue;
        for (State state : stateToComponent.keySet()) {
            AndroidRootComponent root = (AndroidRootComponent)stateToComponent.get(state);
            root.setLocation(this.myTransform.modelToView(this.myNavigationModel.getStateToLocation().get(state)));
            root.setSize(root.getPreferredSize());
        }
        for (Transition transition : this.myNavigationModel.getTransitions()) {
            Component editor;
            String gesture = transition.getType();
            if (gesture == null || (editor = (Component)transitionToEditor.get(transition)) == null) continue;
            java.awt.Dimension preferredSize = editor.getPreferredSize();
            java.awt.Point[] points = this.getControlPoints(transition);
            java.awt.Point location = Utilities.diff(Utilities.midPoint(points[1], points[2]), Utilities.midPoint(preferredSize));
            editor.setLocation(location);
            editor.setSize(preferredSize);
        }
    }

    private <K, V extends Component> void removeLeftovers(Assoc<K, V> assoc, Collection<K> a) {
        for (Map.Entry e : new ArrayList(assoc.keyToValue.entrySet())) {
            Object k = e.getKey();
            Component v = (Component)e.getValue();
            if (a.contains(k)) continue;
            assoc.remove(k, v);
            this.remove(v);
            this.repaint();
        }
    }

    private JComboBox createEditorFor(final Transition transition) {
        String gesture = transition.getType();
        ComboBox c = new ComboBox(new DefaultComboBoxModel<Object>(new Object[]{"press", "swipe"}));
        c.setSelectedItem(gesture);
        c.setForeground(this.getForeground());
        c.setBackground(BACKGROUND_COLOR);
        c.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                transition.setType((String)itemEvent.getItem());
                NavigationView.this.myNavigationModel.getListeners().notify(NavigationModel.Event.update(Transition.class));
            }
        });
        return c;
    }

    private void syncTransitionCache(Assoc<Transition, Component> assoc) {
        for (Transition transition : this.myNavigationModel.getTransitions()) {
            if (assoc.keyToValue.containsKey(transition)) continue;
            JComboBox editor = this.createEditorFor(transition);
            this.add(editor);
            assoc.add(transition, editor);
        }
        this.removeLeftovers(assoc, this.myNavigationModel.getTransitions());
    }

    @Nullable
    public static PsiFile getLayoutXmlFile(boolean menu, @Nullable String resourceName, Configuration configuration, Project project) {
        ResourceType resourceType = menu ? ResourceType.MENU : ResourceType.LAYOUT;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        if (resourceResolver == null) {
            return null;
        }
        ResourceValue projectResource = resourceResolver.getProjectResource(resourceType, resourceName);
        if (projectResource == null) {
            return null;
        }
        VirtualFile file = Utilities.virtualFile(new File(projectResource.getValue()));
        return file == null ? null : psiManager.findFile(file);
    }

    private AndroidRootComponent createRootComponentFor(State state) {
        boolean isMenu = state instanceof MenuState;
        Module module = this.myRenderingParams.myFacet.getModule();
        String resourceName = isMenu ? state.getXmlResourceName() : Analyser.getXMLFileName(module, state.getClassName(), true);
        PsiFile psiFile = NavigationView.getLayoutXmlFile(isMenu, resourceName, this.myRenderingParams.myConfiguration, this.myRenderingParams.myProject);
        AndroidRootComponent result = new AndroidRootComponent(this.myRenderingParams, psiFile, isMenu);
        result.setScale(this.myTransform.myScale);
        return result;
    }

    private void syncStateCache(Assoc<State, AndroidRootComponent> assoc) {
        assoc.clear();
        this.removeAll();
        for (State state : this.myNavigationModel.getStates()) {
            if (assoc.keyToValue.containsKey(state)) continue;
            AndroidRootComponent root = this.createRootComponentFor(state);
            assoc.add(state, root);
            this.add(root);
        }
        this.setPreferredSize();
    }

    private static Point getMaxLoc(Collection<Point> locations) {
        int maxX = 0;
        int maxY = 0;
        for (Point location : locations) {
            maxX = Math.max(maxX, location.x);
            maxY = Math.max(maxY, location.y);
        }
        return new Point(maxX, maxY);
    }

    private void setPreferredSize() {
        Dimension size = this.myRenderingParams.getDeviceScreenSize();
        Dimension gridSize = new Dimension(size.width + NavigationView.GAP.width, size.height + NavigationView.GAP.height);
        Point maxLoc = NavigationView.getMaxLoc(this.myNavigationModel.getStateToLocation().values());
        java.awt.Dimension max = this.myTransform.modelToView(new Dimension(maxLoc.x + gridSize.width, maxLoc.y + gridSize.height));
        this.setPreferredSize(max);
    }

    private Selections.Selection createSelection(java.awt.Point mouseDownLocation, boolean shiftDown) {
        Component component = this.getComponentAt(mouseDownLocation);
        if (component instanceof NavigationView) {
            return Selections.NULL;
        }
        Transition transition = (Transition)this.getTransitionEditorAssociation().valueToKey.get(component);
        if (component instanceof AndroidRootComponent) {
            AndroidRootComponent androidRootComponent = (AndroidRootComponent)component;
            if (!shiftDown) {
                return new Selections.AndroidRootComponentSelection(this.myNavigationModel, androidRootComponent, mouseDownLocation, transition, (State)this.getStateComponentAssociation().valueToKey.get(androidRootComponent), this.myTransform);
            }
            RenderedView leaf = NavigationView.getRenderedView(androidRootComponent, mouseDownLocation);
            return new Selections.RelationSelection(this.myNavigationModel, androidRootComponent, mouseDownLocation, NavigationView.getNamedParent(leaf), this);
        }
        return new Selections.ComponentSelection<Component>(this.myNavigationModel, component, transition);
    }

    private class MyDnDTarget
    implements DnDTarget {
        private int applicableDropCount = 0;

        private MyDnDTarget() {
        }

        private void execute(State state, boolean execute) {
            if (!((NavigationView)NavigationView.this).getStateComponentAssociation().keyToValue.containsKey(state)) {
                if (execute) {
                    NavigationView.this.myNavigationModel.addState(state);
                } else {
                    ++this.applicableDropCount;
                }
            }
        }

        private void dropOrPrepareToDrop(DnDEvent anEvent, boolean execute) {
            Object attachedObject = anEvent.getAttachedObject();
            if (attachedObject instanceof TransferableWrapper) {
                TransferableWrapper wrapper = (TransferableWrapper)attachedObject;
                PsiElement[] psiElements = wrapper.getPsiElements();
                java.awt.Point dropLoc = anEvent.getPointOn((Component)NavigationView.this);
                if (psiElements != null) {
                    for (PsiElement element : psiElements) {
                        PsiQualifiedNamedElement namedElement;
                        String qualifiedName;
                        PsiFile containingFile;
                        PsiDirectory dir;
                        if (element instanceof XmlFileImpl && (dir = (containingFile = element.getContainingFile()).getParent()) != null && dir.getName().equals("menu")) {
                            String resourceName = ResourceHelper.getResourceName(containingFile);
                            MenuState state = new MenuState(resourceName);
                            this.execute(state, execute);
                        }
                        if (!(element instanceof PsiQualifiedNamedElement) || (qualifiedName = (namedElement = (PsiQualifiedNamedElement)element).getQualifiedName()) == null) continue;
                        ActivityState state = new ActivityState(qualifiedName);
                        java.awt.Dimension size = NavigationView.this.myRenderingParams.getDeviceScreenSizeFor(NavigationView.this.myTransform);
                        java.awt.Point dropLocation = Utilities.diff(dropLoc, Utilities.midPoint(size));
                        NavigationView.this.myNavigationModel.getStateToLocation().put(state, NavigationView.this.myTransform.viewToModel(Utilities.snap(dropLocation, MIDDLE_SNAP_GRID)));
                        this.execute(state, execute);
                        dropLoc = Utilities.add(dropLocation, MULTIPLE_DROP_STRIDE);
                    }
                }
            }
            if (execute) {
                NavigationView.this.revalidate();
                NavigationView.this.repaint();
            }
        }

        public boolean update(DnDEvent anEvent) {
            this.applicableDropCount = 0;
            this.dropOrPrepareToDrop(anEvent, false);
            anEvent.setDropPossible(this.applicableDropCount > 0);
            return false;
        }

        public void drop(DnDEvent anEvent) {
            this.dropOrPrepareToDrop(anEvent, true);
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, java.awt.Point dropPoint, java.awt.Point imageOffset) {
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        private void showPopup(MouseEvent e) {
            JBPopupMenu menu = new JBPopupMenu();
            JBMenuItem anItem = new JBMenuItem("New Activity...");
            anItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Project project = ((NavigationView)NavigationView.this).myRenderingParams.myProject;
                    Module module = ((NavigationView)NavigationView.this).myRenderingParams.myFacet.getModule();
                    NewTemplateObjectWizard dialog = new NewTemplateObjectWizard(project, module, null, "activities");
                    dialog.show();
                    if (dialog.isOK()) {
                        dialog.createTemplateObject(false);
                    }
                }
            });
            menu.add((JMenuItem)anItem);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            java.awt.Point location = e.getPoint();
            boolean modified = e.isShiftDown() || e.isControlDown() || e.isMetaDown();
            NavigationView.this.setSelection(NavigationView.this.createSelection(location, modified));
            NavigationView.this.requestFocus();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            NavigationView.this.setMouseLocation(e.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            NavigationView.this.moveSelection(e.getPoint());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component child;
            if (e.getClickCount() == 2 && (child = NavigationView.this.getComponentAt(e.getPoint())) instanceof AndroidRootComponent) {
                AndroidRootComponent androidRootComponent = (AndroidRootComponent)child;
                androidRootComponent.launchLayoutEditor();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            NavigationView.this.finaliseSelectionLocation(e.getPoint());
        }
    }

    static class Line {
        public final java.awt.Point a;
        public final java.awt.Point b;

        Line(java.awt.Point a, java.awt.Point b) {
            this.a = a;
            this.b = b;
        }

        java.awt.Point project(java.awt.Point p) {
            boolean vertical;
            boolean horizontal = this.a.x == this.b.x;
            boolean bl = vertical = this.a.y == this.b.y;
            if (!horizontal && !vertical) {
                throw new UnsupportedOperationException();
            }
            return horizontal ? new java.awt.Point(this.a.x, p.y) : new java.awt.Point(p.x, this.a.y);
        }
    }
}

