/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.navigation.Dimension;
import com.android.navigation.EventDispatcher;
import com.android.navigation.Listener;
import com.android.navigation.NavigationModel;
import com.android.navigation.Point;
import com.android.navigation.State;
import com.android.navigation.Transition;
import com.android.navigation.XMLReader;
import com.android.navigation.XMLWriter;
import com.android.tools.idea.actions.AndroidShowNavigationEditor;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.NavigationView;
import com.android.tools.idea.editors.navigation.RenderingParameters;
import com.android.tools.idea.editors.navigation.macros.Analyser;
import com.android.tools.idea.editors.navigation.macros.CodeGenerator;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.intellij.AppTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationEditor
implements FileEditor {
    private static final String TOOLBAR = "NavigationEditorToolbar";
    private static final Logger LOG = Logger.getInstance((String)("#" + NavigationEditor.class.getName()));
    private static final boolean DEBUG = false;
    private static final String NAME = "Navigation";
    private static final int INITIAL_FILE_BUFFER_SIZE = 1000;
    private static final int SCROLL_UNIT_INCREMENT = 20;
    private static final NavigationModel.Event PROJECT_READ = new NavigationModel.Event(NavigationModel.Event.Operation.UPDATE, Object.class);
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @Nullable
    private RenderingParameters myRenderingParams;
    private NavigationModel myNavigationModel;
    private final VirtualFile myFile;
    private JComponent myComponent;
    private CodeGenerator myCodeGenerator;
    private boolean myModified;
    private boolean myPendingFileSystemChanges;
    private Analyser myAnalyser;
    private final Listener<NavigationModel.Event> myNavigationModelListener;
    private final ResourceFolderManager.ResourceFolderListener myResourceFolderListener;
    private VirtualFileAdapter myVirtualFileListener;
    private final ErrorHandler myErrorHandler;

    public NavigationEditor(Project project, VirtualFile file) {
        FileDocumentManagerAdapter saveListener = new FileDocumentManagerAdapter(){

            public void beforeAllDocumentsSaving() {
                try {
                    NavigationEditor.this.saveFile();
                }
                catch (IOException e) {
                    LOG.error("Unexpected exception while saving navigation file", (Throwable)e);
                }
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)saveListener);
        this.myFile = file;
        this.myErrorHandler = new ErrorHandler();
        this.myRenderingParams = NavigationView.getRenderingParams(project, file, this.myErrorHandler);
        if (this.myRenderingParams != null) {
            Configuration configuration = this.myRenderingParams.myConfiguration;
            Module module = configuration.getModule();
            this.myAnalyser = new Analyser(project, module);
            try {
                this.myNavigationModel = NavigationEditor.read(file);
                this.myCodeGenerator = new CodeGenerator(this.myNavigationModel, module);
                NavigationView editor = new NavigationView(this.myRenderingParams, this.myNavigationModel);
                JBScrollPane scrollPane = new JBScrollPane((Component)editor);
                scrollPane.getVerticalScrollBar().setUnitIncrement(20);
                JPanel p = new JPanel(new BorderLayout());
                JComponent controls = this.createToolbar(editor);
                p.add((Component)controls, "North");
                p.add((Component)scrollPane);
                this.myComponent = p;
            }
            catch (FileReadException e) {
                this.myErrorHandler.handleError("Invalid Navigation File", e.getMessage());
            }
        }
        this.myNavigationModelListener = new Listener<NavigationModel.Event>(){

            @Override
            public void notify(@NotNull NavigationModel.Event event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor$2", "notify"));
                }
                if (event.operation == NavigationModel.Event.Operation.INSERT && event.operandType == Transition.class) {
                    ArrayList<Transition> transitions = NavigationEditor.this.myNavigationModel.getTransitions();
                    Transition transition = transitions.get(transitions.size() - 1);
                    NavigationEditor.this.myCodeGenerator.implementTransition(transition);
                }
                if (event != PROJECT_READ) {
                    NavigationEditor.this.myModified = true;
                }
            }
        };
        this.myNavigationModel.getListeners().add((NavigationModel.Event)((Object)this.myNavigationModelListener));
        this.myVirtualFileListener = new VirtualFileAdapter(){

            private void somethingChanged(String changeType, @NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/navigation/NavigationEditor$3", "somethingChanged"));
                }
                NavigationEditor.this.postDelayedRefresh();
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor$3", "contentsChanged"));
                }
                this.somethingChanged("contentsChanged", event);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor$3", "fileCreated"));
                }
                this.somethingChanged("fileCreated", event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor$3", "fileDeleted"));
                }
                this.somethingChanged("fileDeleted", event);
            }
        };
        this.myResourceFolderListener = new ResourceFolderManager.ResourceFolderListener(){

            @Override
            public void resourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<VirtualFile> folders, @NotNull Collection<VirtualFile> added, @NotNull Collection<VirtualFile> removed) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "resourceFoldersChanged"));
                }
                if (folders == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "resourceFoldersChanged"));
                }
                if (added == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "resourceFoldersChanged"));
                }
                if (removed == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "resourceFoldersChanged"));
                }
                NavigationEditor.this.postDelayedRefresh();
            }
        };
    }

    private static ResourceFolderManager getResourceFolderManager(AndroidFacet facet) {
        ModuleResourceRepository.getModuleResources(facet, true);
        return facet.getResourceFolderManager();
    }

    private void postDelayedRefresh() {
        if (!this.myPendingFileSystemChanges) {
            this.myPendingFileSystemChanges = true;
            final Application app = ApplicationManager.getApplication();
            app.invokeLater(new Runnable(){

                @Override
                public void run() {
                    app.executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            app.runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    NavigationEditor.this.myPendingFileSystemChanges = false;
                                    long l = System.currentTimeMillis();
                                    NavigationEditor.this.updateNavigationModelFromProject();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    protected JComponent createToolbar(NavigationView myDesigner) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createBorder((int)8));
        final String dirName = this.myFile.getParent().getName();
        JPanel combos = new JPanel(new FlowLayout());
        String phone = "phone";
        String tablet = "tablet";
        final ComboBox deviceSelector = new ComboBox(new Object[]{"phone", "tablet"});
        String portrait = "portrait";
        String landscape = "landscape";
        final ComboBox orientationSelector = new ComboBox(new Object[]{"portrait", "landscape"});
        deviceSelector.setSelectedItem((Object)(dirName.contains("-sw600dp") ? "tablet" : "phone"));
        orientationSelector.setSelectedItem((Object)(dirName.contains("-land") ? "landscape" : "portrait"));
        ActionListener actionListener = new ActionListener(){
            boolean disabled = false;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.disabled) {
                    return;
                }
                Object device = deviceSelector.getSelectedItem();
                String deviceQualifier = device == "tablet" ? "-sw600dp" : "";
                Object orientation = orientationSelector.getSelectedItem();
                String orientationQualifier = orientation == "landscape" ? "-land" : "";
                new AndroidShowNavigationEditor().showNavigationEditor(((NavigationEditor)NavigationEditor.this).myRenderingParams.myProject, "raw" + deviceQualifier + orientationQualifier, "main.nvg.xml");
                this.disabled = true;
                deviceSelector.setSelectedItem((Object)(dirName.contains("-sw600dp") ? "tablet" : "phone"));
                orientationSelector.setSelectedItem((Object)(dirName.contains("-land") ? "landscape" : "portrait"));
                this.disabled = false;
            }
        };
        deviceSelector.addActionListener(actionListener);
        combos.add((Component)deviceSelector);
        orientationSelector.addActionListener(actionListener);
        combos.add((Component)orientationSelector);
        panel.add((Component)combos, "Center");
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar zoomToolBar = actionManager.createActionToolbar(TOOLBAR, NavigationEditor.getActions(myDesigner), true);
        panel.add((Component)zoomToolBar.getComponent(), "West");
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkTarget("http://tools.android.com/navigation-editor");
        label.setHyperlinkText(" ", "What's this?", " ");
        panel.add((Component)label, "East");
        return panel;
    }

    private static ActionGroup getActions(final NavigationView myDesigner) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(null, "Zoom Out (-)", AndroidIcons.ZoomOut){

            public void actionPerformed(AnActionEvent e) {
                myDesigner.zoom(false);
            }
        });
        group.add(new AnAction(null, "Reset Zoom to 100% (1)", AndroidIcons.ZoomActual){

            public void actionPerformed(AnActionEvent e) {
                myDesigner.setScale(1.0f);
            }
        });
        group.add(new AnAction(null, "Zoom In (+)", AndroidIcons.ZoomIn){

            public void actionPerformed(AnActionEvent e) {
                myDesigner.zoom(true);
            }
        });
        return group;
    }

    private static NavigationModel read(VirtualFile file) throws FileReadException {
        try {
            InputStream inputStream = file.getInputStream();
            if (inputStream.available() == 0) {
                return new NavigationModel();
            }
            return (NavigationModel)new XMLReader(inputStream).read();
        }
        catch (Exception e) {
            throw new FileReadException(e);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditor", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditor", "getName"));
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor", "setState"));
        }
    }

    public boolean isModified() {
        return this.myModified;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    private void layoutStatesWithUnsetLocations(NavigationModel navigationModel) {
        ArrayList<State> states = navigationModel.getStates();
        final Map<State, Point> stateToLocation = navigationModel.getStateToLocation();
        final HashSet visited = new HashSet();
        Dimension size = this.myRenderingParams.getDeviceScreenSize();
        Dimension gridSize = new Dimension(size.width + NavigationView.GAP.width, size.height + NavigationView.GAP.height);
        final java.awt.Point location = new java.awt.Point(NavigationView.GAP.width, NavigationView.GAP.height);
        final int gridWidth = gridSize.width;
        final int gridHeight = gridSize.height;
        for (State state : states) {
            if (visited.contains(state)) continue;
            new Object(){

                public void addChildrenFor(State source) {
                    visited.add(source);
                    if (!stateToLocation.containsKey(source)) {
                        stateToLocation.put(source, new Point(location.x, location.y));
                    }
                    List children = NavigationEditor.this.findDestinationsFor(source, visited);
                    location.x += gridWidth;
                    if (children.isEmpty()) {
                        location.y += gridHeight;
                    } else {
                        for (State child : children) {
                            this.addChildrenFor(child);
                        }
                    }
                    location.x -= gridWidth;
                }
            }.addChildrenFor(state);
        }
    }

    private List<State> findDestinationsFor(State source, Set<State> visited) {
        ArrayList<State> result = new ArrayList<State>();
        for (Transition transition : this.myNavigationModel.getTransitions()) {
            State destination;
            if (transition.getSource().getState() != source || visited.contains(destination = transition.getDestination().getState())) continue;
            result.add(destination);
        }
        return result;
    }

    private void updateNavigationModelFromProject() {
        if (this.myRenderingParams == null || this.myRenderingParams.myProject.isDisposed()) {
            return;
        }
        EventDispatcher<NavigationModel.Event> listeners = this.myNavigationModel.getListeners();
        boolean notificationWasEnabled = listeners.isNotificationEnabled();
        listeners.setNotificationEnabled(false);
        this.myNavigationModel.clear();
        this.myNavigationModel.getTransitions().clear();
        this.myAnalyser.deriveAllStatesAndTransitions(this.myNavigationModel, this.myRenderingParams.myConfiguration);
        this.layoutStatesWithUnsetLocations(this.myNavigationModel);
        listeners.setNotificationEnabled(notificationWasEnabled);
        this.myModified = false;
        listeners.notify(PROJECT_READ);
    }

    public void selectNotify() {
        if (this.myRenderingParams != null) {
            AndroidFacet facet = this.myRenderingParams.myFacet;
            this.updateNavigationModelFromProject();
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
            NavigationEditor.getResourceFolderManager(facet).addListener(this.myResourceFolderListener);
        }
    }

    public void deselectNotify() {
        if (this.myRenderingParams != null) {
            AndroidFacet facet = this.myRenderingParams.myFacet;
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
            NavigationEditor.getResourceFolderManager(facet).removeListener(this.myResourceFolderListener);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    private void saveFile() throws IOException {
        if (this.myModified) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1000);
            new XMLWriter(stream).write(this.myNavigationModel);
            this.myFile.setBinaryContent(stream.toByteArray());
            this.myModified = false;
        }
    }

    public void dispose() {
        try {
            this.saveFile();
        }
        catch (IOException e) {
            LOG.error("Unexpected exception while saving navigation file", (Throwable)e);
        }
        this.myNavigationModel.getListeners().remove(this.myNavigationModelListener);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor", "getUserData"));
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/navigation/NavigationEditor", "putUserData"));
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    private static class FileReadException
    extends Exception {
        private FileReadException(Throwable throwable) {
            super(throwable);
        }
    }

    public class ErrorHandler {
        public void handleError(String title, String errorMessage) {
            NavigationEditor.this.myNavigationModel = new NavigationModel();
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(title);
            label.setFont(label.getFont().deriveFont(30.0f));
            label.setHorizontalAlignment(0);
            panel.add((Component)label, "North");
            label = new JLabel(errorMessage);
            label.setFont(label.getFont().deriveFont(20.0f));
            label.setHorizontalAlignment(0);
            panel.add((Component)label, "Center");
            NavigationEditor.this.myComponent = (JComponent)new JBScrollPane((Component)panel);
        }
    }
}

