/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.AllocationsFilterUtil;
import com.android.tools.idea.editors.allocations.AllocationsTableModel;
import com.android.tools.idea.editors.allocations.AllocationsTableUtil;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.util.config.Storage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllocationsViewPanel {
    static final String GROUPING_CHECKBOX_NAME = "myGroupingCheckBox";
    static final String ALLOCATIONS_TABLE_NAME = "myAllocationsTable";
    private JPanel myContainer;
    private JBCheckBox myGroupingCheckBox;
    private JBTextField myFilterField;
    private JBCheckBox myIncludeTraceCheckBox;
    private JBTable myAllocationsTable;
    private JBScrollPane myAllocationsPane;
    private ConsoleView myConsoleView;
    private JBSplitter mySplitter;

    public AllocationsViewPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsViewPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.init(project);
    }

    private void init(Project project) {
        this.myGroupingCheckBox.setVisible(false);
        this.myAllocationsTable = new JBTable();
        this.myConsoleView = this.createConsoleView(project);
        AllocationsTableUtil.setUpTable(this.getStorage(), this.myAllocationsTable, this.myConsoleView);
        AllocationsFilterUtil.setUpFiltering(this.myAllocationsTable, this.myFilterField, this.myIncludeTraceCheckBox);
        this.myAllocationsPane = new JBScrollPane((Component)this.myAllocationsTable);
        this.mySplitter.setFirstComponent((JComponent)this.myAllocationsPane);
        if (this.myConsoleView != null) {
            this.mySplitter.setSecondComponent(this.myConsoleView.getComponent());
        }
        this.myGroupingCheckBox.setName(GROUPING_CHECKBOX_NAME);
        this.myAllocationsTable.setName(ALLOCATIONS_TABLE_NAME);
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsViewPanel", "getComponent"));
        }
        return jPanel;
    }

    private void resetView() {
        this.myFilterField.setText("");
        this.myIncludeTraceCheckBox.setSelected(false);
        this.myAllocationsTable.clearSelection();
        this.myAllocationsPane.requestFocusInWindow();
        this.myAllocationsPane.getVerticalScrollBar().setValue(0);
        this.myAllocationsPane.getHorizontalScrollBar().setValue(0);
        if (this.myConsoleView != null) {
            this.myConsoleView.clear();
        }
    }

    public void setAllocations(@NotNull AllocationInfo[] allocations) {
        if (allocations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsViewPanel", "setAllocations"));
        }
        ((AllocationsTableModel)this.myAllocationsTable.getModel()).setAllocations(allocations);
        this.resetView();
    }

    @Nullable
    ConsoleView createConsoleView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsViewPanel", "createConsoleView"));
        }
        return TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
    }

    @Nullable
    Storage.PropertiesComponentStorage getStorage() {
        return new Storage.PropertiesComponentStorage("android.allocationsview.colummns");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBSplitter jBSplitter;
        JBCheckBox jBCheckBox;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 5, 5));
        Component component = jPanel2.add(jPanel3);
        this.myGroupingCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setMargin(new Insets(2, 2, 2, 2));
        jBCheckBox2.setText("Group by allocated class");
        Component component2 = jPanel3.add((Component)jBCheckBox2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 5, 5));
        Component component3 = jPanel2.add(jPanel4);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Filter:");
        Component component4 = jPanel4.add((Component)jBLabel);
        this.myFilterField = jBTextField = new JBTextField();
        jBTextField.setPreferredSize(new Dimension(192, 23));
        Component component5 = jPanel4.add((Component)jBTextField);
        this.myIncludeTraceCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Include trace");
        Component component6 = jPanel4.add((Component)jBCheckBox);
        this.mySplitter = jBSplitter = new JBSplitter();
        jBSplitter.setOrientation(true);
        jPanel.add((Component)jBSplitter, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }
}

