/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.AllocationsTableUtil;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllocationsTableModel
extends AbstractTableModel {
    AllocationInfo[] myAllocations;

    public AllocationsTableModel(@NotNull AllocationInfo[] allocations) {
        if (allocations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsTableModel", "<init>"));
        }
        this.setAllocations(allocations);
    }

    public void setAllocations(@NotNull AllocationInfo[] allocations) {
        if (allocations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsTableModel", "setAllocations"));
        }
        this.myAllocations = allocations;
    }

    @NotNull
    public AllocationInfo getAllocation(int modelRow) {
        AllocationInfo allocationInfo = this.myAllocations[modelRow];
        if (allocationInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsTableModel", "getAllocation"));
        }
        return allocationInfo;
    }

    @Override
    public int getRowCount() {
        return this.myAllocations.length;
    }

    @Override
    public int getColumnCount() {
        return AllocationsTableUtil.Column.values().length;
    }

    @Override
    @Nullable
    public Object getValueAt(int row, int column) {
        switch (AllocationsTableUtil.Column.values()[column]) {
            case ALLOCATION_ORDER: {
                return this.myAllocations[row].getAllocNumber();
            }
            case ALLOCATED_CLASS: {
                return this.myAllocations[row].getAllocatedClass();
            }
            case ALLOCATION_SIZE: {
                return this.myAllocations[row].getSize();
            }
            case THREAD_ID: {
                return this.myAllocations[row].getThreadId();
            }
            case ALLOCATION_SITE: {
                return this.myAllocations[row].getAllocationSite();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        String string = AllocationsTableUtil.Column.values()[column].description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsTableModel", "getColumnName"));
        }
        return string;
    }

    @NotNull
    public Class getColumnClass(int c) {
        Class<?> clazz = AllocationsTableUtil.Column.values()[c].sampleData.getClass();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsTableModel", "getColumnClass"));
        }
        return clazz;
    }
}

