/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.tools.idea.editors.allocations.AllocationsTableModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class AllocationsRowFilter
extends RowFilter<TableModel, Integer> {
    private final AllocationsTableModel myModel;
    private final JBTextField myFilterField;
    private final JBCheckBox myIncludeTraceCheckBox;

    public AllocationsRowFilter(@NotNull AllocationsTableModel model, @NotNull JBTextField filterField, @NotNull JBCheckBox includeTraceCheckBox) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/editors/allocations/AllocationsRowFilter", "<init>"));
        }
        if (filterField == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/editors/allocations/AllocationsRowFilter", "<init>"));
        }
        if (includeTraceCheckBox == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/editors/allocations/AllocationsRowFilter", "<init>"));
        }
        this.myModel = model;
        this.myFilterField = filterField;
        this.myIncludeTraceCheckBox = includeTraceCheckBox;
    }

    @Override
    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        return this.myModel.getAllocation(entry.getIdentifier()).filter(this.myFilterField.getText(), this.myIncludeTraceCheckBox.isSelected(), this.myFilterField.getLocale());
    }
}

