/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.ddms.DeviceContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.AndroidIcons;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ToggleAllocationTrackingAction
extends ToggleAction {
    private final DeviceContext myDeviceContext;

    public ToggleAllocationTrackingAction(@NotNull DeviceContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/actions/ToggleAllocationTrackingAction", "<init>"));
        }
        super(AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]), null, AndroidIcons.Ddms.AllocationTracker);
        this.myDeviceContext = context;
    }

    public boolean isSelected(AnActionEvent e) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            return false;
        }
        return c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            return;
        }
        if (c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON) {
            c.requestAllocationDetails();
            c.enableAllocationTracker(false);
        } else {
            c.enableAllocationTracker(true);
        }
        c.requestAllocationStatus();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        Client c = this.myDeviceContext.getSelectedClient();
        if (c == null) {
            presentation.setEnabled(false);
            return;
        }
        String text = c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON ? AndroidBundle.message("android.ddms.actions.allocationtracker.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]);
        presentation.setText(text);
        presentation.setEnabled(true);
    }
}

