/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ShowAllocationsHandler
implements ClientData.IAllocationTrackingHandler {
    private static final Logger LOG = Logger.getInstance(ShowAllocationsHandler.class);
    private final Project myProject;

    public ShowAllocationsHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/ShowAllocationsHandler", "<init>"));
        }
        this.myProject = project;
    }

    public void onSuccess(@NotNull byte[] data, @NotNull Client client) {
        File f;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/ShowAllocationsHandler", "onSuccess"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/ddms/ShowAllocationsHandler", "onSuccess"));
        }
        try {
            f = FileUtil.createTempFile((String)"ddms", (String)".alloc");
            FileUtil.writeToFile((File)f, (byte[])data);
            LOG.info("AllocationTracking: Saved allocations to file: " + f.getAbsolutePath());
        }
        catch (IOException e) {
            this.showError("Unexpected error while saving allocations to a temporary file: " + ExceptionUtil.getRootCause((Throwable)e).getLocalizedMessage());
            return;
        }
        final VirtualFile vf = VfsUtil.findFileByIoFile((File)f, (boolean)true);
        if (vf == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(ShowAllocationsHandler.this.myProject, vf);
                FileEditorManager.getInstance((Project)ShowAllocationsHandler.this.myProject).openEditor(descriptor, true);
            }
        });
    }

    private void showError(final String message) {
        LOG.error("Allocation Tracking: " + message);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)ShowAllocationsHandler.this.myProject, (String)message, (String)"Allocation Tracker");
            }
        });
    }
}

