/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePropertyUtil {
    private static final Set<String> ourManufacturerNameIsAcronym = ImmutableSet.of((Object)"ASUS", (Object)"HTC", (Object)"LG", (Object)"LGE", (Object)"ZTE");

    static String fixManufacturerName(@NotNull String manufacturer) {
        if (manufacturer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/DevicePropertyUtil", "fixManufacturerName"));
        }
        String allCaps = manufacturer.toUpperCase(Locale.US);
        return ourManufacturerNameIsAcronym.contains(allCaps) ? allCaps : StringUtil.capitalizeWords((String)manufacturer, (boolean)true);
    }

    @Nullable
    private static String getProperty(IDevice d, String prop) {
        try {
            return d.getPropertyCacheOrSync(prop);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getManufacturer(IDevice d, String unknown) {
        String m = DevicePropertyUtil.getProperty(d, "ro.product.manufacturer");
        return m != null ? DevicePropertyUtil.fixManufacturerName(m) : unknown;
    }

    public static String getModel(IDevice d, String unknown) {
        String m = DevicePropertyUtil.getProperty(d, "ro.product.model");
        return m != null ? StringUtil.capitalizeWords((String)m, (boolean)true) : unknown;
    }

    public static String getBuild(IDevice d) {
        StringBuilder sb = new StringBuilder(20);
        String v = DevicePropertyUtil.getProperty(d, "ro.build.version.release");
        if (v != null) {
            sb.append("Android ");
            sb.append(v);
        }
        if ((v = DevicePropertyUtil.getProperty(d, "ro.build.version.sdk")) != null) {
            sb.append(String.format(" (API %1$s)", v));
        }
        return sb.toString();
    }

    @NotNull
    public static AndroidVersion getDeviceVersion(@NotNull IDevice device) {
        AndroidVersion androidVersion;
        block7: {
            String apiLevel;
            block6: {
                AndroidVersion androidVersion2;
                if (device == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/DevicePropertyUtil", "getDeviceVersion"));
                }
                try {
                    apiLevel = device.getPropertyCacheOrSync("ro.build.version.sdk");
                    if (apiLevel != null) break block6;
                    androidVersion2 = AndroidVersion.DEFAULT;
                }
                catch (Exception e) {
                    AndroidVersion androidVersion3 = AndroidVersion.DEFAULT;
                    if (androidVersion3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePropertyUtil", "getDeviceVersion"));
                    }
                    return androidVersion3;
                }
                if (androidVersion2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePropertyUtil", "getDeviceVersion"));
                }
                return androidVersion2;
            }
            androidVersion = new AndroidVersion(Integer.parseInt(apiLevel), device.getPropertyCacheOrSync("ro.build.version.codename"));
            if (androidVersion != null) break block7;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/DevicePropertyUtil", "getDeviceVersion"));
        }
        return androidVersion;
    }
}

