/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceContext {
    private final EventDispatcher<DeviceSelectionListener> myEventDispatcher = EventDispatcher.create(DeviceSelectionListener.class);
    private IDevice mySelectedDevice;
    private Client mySelectedClient;

    public void addListener(DeviceSelectionListener l, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/ddms/DeviceContext", "addListener"));
        }
        this.myEventDispatcher.addListener((EventListener)l, parentDisposable);
    }

    public void fireDeviceSelected(@Nullable IDevice d) {
        this.mySelectedDevice = d;
        ((DeviceSelectionListener)this.myEventDispatcher.getMulticaster()).deviceSelected(d);
    }

    public void fireClientSelected(@Nullable Client c) {
        this.mySelectedClient = c;
        ((DeviceSelectionListener)this.myEventDispatcher.getMulticaster()).clientSelected(c);
    }

    public void fireDeviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/ddms/DeviceContext", "fireDeviceChanged"));
        }
        ((DeviceSelectionListener)this.myEventDispatcher.getMulticaster()).deviceChanged(device, changeMask);
    }

    public IDevice getSelectedDevice() {
        return this.mySelectedDevice;
    }

    public Client getSelectedClient() {
        return this.mySelectedClient;
    }

    public static interface DeviceSelectionListener
    extends EventListener {
        public void deviceSelected(@Nullable IDevice var1);

        public void deviceChanged(@NotNull IDevice var1, int var2);

        public void clientSelected(@Nullable Client var1);
    }
}

