/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.utils.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.JList;

public class DeviceComboBoxRenderer
extends ColoredListCellRenderer {
    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (value instanceof String) {
            this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (value instanceof IDevice) {
            IDevice d = (IDevice)value;
            this.setIcon(d.isEmulator() ? AndroidIcons.Ddms.Emulator2 : AndroidIcons.Ddms.RealDevice);
            List<Pair<String, SimpleTextAttributes>> components = DevicePanel.renderDeviceName(d);
            for (Pair<String, SimpleTextAttributes> c : components) {
                this.append((String)c.getFirst(), (SimpleTextAttributes)c.getSecond());
            }
        } else if (value == null) {
            this.append("[none]", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }
}

