/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMenuAction;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetMenuAction
extends FlatComboAction {
    private final RenderContext myRenderContext;

    public TargetMenuAction(RenderContext renderContext) {
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Android version to use when rendering layouts in the IDE");
        presentation.setIcon(AndroidIcons.Targets);
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            IAndroidTarget target = configuration.getTarget();
            String brief = TargetMenuAction.getRenderingTargetLabel(target, true);
            presentation.setText(brief);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        AndroidFacet facet;
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/TargetMenuAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
        group.add((AnAction)new TogglePickBestAction(configuration.getConfigurationManager()));
        group.addSeparator();
        IAndroidTarget current = configuration.getTarget();
        IAndroidTarget[] targets = configuration.getConfigurationManager().getTargets();
        boolean haveRecent = false;
        Module module = this.myRenderContext.getModule();
        int minSdk = -1;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            minSdk = facet.getAndroidModuleInfo().getMinSdkVersion().getFeatureLevel();
        }
        for (int i = targets.length - 1; i >= 0; --i) {
            AndroidVersion version;
            IAndroidTarget target = targets[i];
            if (!ConfigurationManager.isLayoutLibTarget(target) || (version = target.getVersion()).getFeatureLevel() < minSdk) continue;
            if (version.getApiLevel() >= 7) {
                haveRecent = true;
            } else if (haveRecent) break;
            String title = TargetMenuAction.getRenderingTargetLabel(target, false);
            boolean select = current == target;
            group.add((AnAction)new SetTargetAction(this.myRenderContext, title, target, select));
        }
        group.addSeparator();
        RenderPreviewMode currentMode = RenderPreviewMode.getCurrent();
        if (currentMode != RenderPreviewMode.API_LEVELS) {
            ConfigurationMenuAction.addApiLevelPreviewAction(this.myRenderContext, group);
        } else {
            ConfigurationMenuAction.addRemovePreviewsAction(this.myRenderContext, group);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/TargetMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    public static String getRenderingTargetLabel(@Nullable IAndroidTarget target, boolean brief) {
        if (target == null) {
            return "<null>";
        }
        AndroidVersion version = target.getVersion();
        if (brief) {
            if (target.isPlatform()) {
                String codename = version.getCodename();
                if (codename != null && !codename.isEmpty()) {
                    if (codename.length() <= 3) {
                        return codename;
                    }
                    return Character.toString(codename.charAt(0));
                }
                return Integer.toString(version.getApiLevel());
            }
            return target.getName() + ':' + Integer.toString(version.getApiLevel());
        }
        return String.format("API %1$d: %2$s", version.getApiLevel(), target.getShortClasspathName());
    }

    private static class SetTargetAction
    extends ConfigurationAction {
        private final IAndroidTarget myTarget;

        public SetTargetAction(@NotNull RenderContext renderContext, @NotNull String title, @NotNull IAndroidTarget target, boolean select) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "<init>"));
            }
            super(renderContext, title);
            this.myTarget = target;
            if (select) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "updateConfiguration"));
            }
            if (commit) {
                this.setProjectWideTarget();
            } else {
                configuration.setTarget(this.myTarget);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file, @NotNull VirtualFile old) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "pickedBetterMatch"));
            }
            if (old == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "pickedBetterMatch"));
            }
            super.pickedBetterMatch(file, old);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideTarget();
            }
        }

        private void setProjectWideTarget() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setTarget(this.myTarget);
                this.myRenderContext.requestRender();
            }
        }
    }

    private static class TogglePickBestAction
    extends ToggleAction {
        private final ConfigurationManager myManager;

        TogglePickBestAction(ConfigurationManager manager) {
            super("Automatically Pick Best");
            this.myManager = manager;
            if (manager.getStateManager().getProjectState().isPickTarget()) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myManager.getStateManager().getProjectState().isPickTarget();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myManager.getStateManager().getProjectState().setPickTarget(state);
            if (state) {
                this.myManager.setTarget(null);
            }
        }
    }
}

