/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.RenderContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowSettings;
import org.jetbrains.annotations.NotNull;

public class RenderOptionsMenuBuilder {
    final DefaultActionGroup myGroup;
    final AndroidLayoutPreviewToolWindowSettings mySettings;
    private final RenderContext myContext;

    private RenderOptionsMenuBuilder(@NotNull RenderContext context, @NotNull Project project) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "<init>"));
        }
        this.myGroup = new DefaultActionGroup();
        this.mySettings = AndroidLayoutPreviewToolWindowSettings.getInstance(project);
        this.myContext = context;
    }

    public static RenderOptionsMenuBuilder create(@NotNull RenderContext context, @NotNull Project project) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "create"));
        }
        return new RenderOptionsMenuBuilder(context, project);
    }

    @NotNull
    public RenderOptionsMenuBuilder addHideOption() {
        this.myGroup.addAction((AnAction)new CheckboxAction("Hide for non-layout files"){

            public boolean isSelected(AnActionEvent e) {
                return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isHideForNonLayoutFiles();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setHideForNonLayoutFiles(state);
            }
        }).setAsSecondary(true);
        RenderOptionsMenuBuilder renderOptionsMenuBuilder = this;
        if (renderOptionsMenuBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "addHideOption"));
        }
        return renderOptionsMenuBuilder;
    }

    @NotNull
    public RenderOptionsMenuBuilder addDeviceFrameOption() {
        this.myGroup.addAction((AnAction)new CheckboxAction("Include Device Frames (if available)"){

            public boolean isSelected(AnActionEvent e) {
                return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isShowDeviceFrames();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setShowDeviceFrames(state);
                RenderOptionsMenuBuilder.this.myContext.requestRender();
            }
        }).setAsSecondary(true);
        this.myGroup.addAction((AnAction)new CheckboxAction("    Show Lighting Effects"){

            public boolean isSelected(AnActionEvent e) {
                return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isShowEffects();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setShowEffects(state);
                RenderOptionsMenuBuilder.this.myContext.requestRender();
            }
        }).setAsSecondary(true);
        RenderOptionsMenuBuilder renderOptionsMenuBuilder = this;
        if (renderOptionsMenuBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "addDeviceFrameOption"));
        }
        return renderOptionsMenuBuilder;
    }

    @NotNull
    public RenderOptionsMenuBuilder addRetinaOption() {
        if (UIUtil.isRetina()) {
            this.myGroup.addAction((AnAction)new CheckboxAction("DEBUG: Render in Retina resolution"){

                public boolean isSelected(AnActionEvent e) {
                    return RenderOptionsMenuBuilder.this.mySettings.getGlobalState().isRetina();
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    RenderOptionsMenuBuilder.this.mySettings.getGlobalState().setRetina(state);
                    RenderOptionsMenuBuilder.this.myContext.requestRender();
                }
            }).setAsSecondary(true);
        }
        RenderOptionsMenuBuilder renderOptionsMenuBuilder = this;
        if (renderOptionsMenuBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "addRetinaOption"));
        }
        return renderOptionsMenuBuilder;
    }

    @NotNull
    public ActionToolbar build() {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.myGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setSecondaryActionsTooltip("Options");
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/RenderOptionsMenuBuilder", "build"));
        }
        return actionToolbar;
    }
}

