/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.rendering.ImageUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToNinePatchAction
extends AnAction {
    public ConvertToNinePatchAction() {
        super(AndroidBundle.message("android.9patch.creator.title", new Object[0]));
    }

    public void update(AnActionEvent e) {
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        boolean isPng = ConvertToNinePatchAction.isPngFile(file);
        e.getPresentation().setEnabled(isPng);
        e.getPresentation().setVisible(isPng);
    }

    @Contract(value="null -> false")
    private static boolean isPngFile(@Nullable VirtualFile file) {
        return file != null && "png".equalsIgnoreCase(file.getExtension()) && !StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".9.png");
    }

    public void actionPerformed(AnActionEvent e) {
        final VirtualFile pngFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (!ConvertToNinePatchAction.isPngFile(pngFile)) {
            return;
        }
        FileSaverDescriptor descriptor = new FileSaverDescriptor(AndroidBundle.message("android.9patch.creator.save.title", new Object[0]), "", new String[]{"png"});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Project)null);
        VirtualFileWrapper fileWrapper = saveFileDialog.save(pngFile.getParent(), pngFile.getNameWithoutExtension().concat(".9.png"));
        if (fileWrapper == null) {
            return;
        }
        final File patchFile = fileWrapper.getFile();
        new Task.Modal(null, "Creating 9-Patch File", false){
            private IOException myException;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/actions/ConvertToNinePatchAction$1", "run"));
                }
                indicator.setIndeterminate(true);
                try {
                    BufferedImage pngImage = ImageIO.read(VfsUtilCore.virtualToIoFile((VirtualFile)pngFile));
                    BufferedImage patchImage = ImageUtils.addMargin(pngImage, 1);
                    ImageIO.write((RenderedImage)patchImage, "png", patchFile);
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(patchFile);
                }
                catch (IOException e) {
                    this.myException = e;
                }
            }

            public void onSuccess() {
                if (this.myException != null) {
                    Messages.showErrorDialog((String)AndroidBundle.message("android.9patch.creator.error", this.myException.getMessage()), (String)AndroidBundle.message("android.9patch.creator.error.title", new Object[0]));
                }
            }
        }.queue();
    }
}

