/*
 * Decompiled with CFR 0.152.
 */
package com.android.navigation;

import com.android.annotations.NonNull;
import com.android.navigation.Properties;
import com.android.navigation.Utilities;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public class XMLWriter {
    public static final String UNDEFINED = null;
    private final Map<Class, Properties.Property[]> classToProperties = new IdentityHashMap<Class, Properties.Property[]>();
    private final PrintStream out;
    private int level;
    private Map<Class, Integer> idCounts = new IdentityHashMap<Class, Integer>();
    private Map<Object, Info> objectToInfo = new IdentityHashMap<Object, Info>(){

        @Override
        public Info get(Object o) {
            Info result = (Info)super.get(o);
            if (result == null) {
                result = new Info();
                this.put(o, result);
            }
            return result;
        }
    };

    public XMLWriter(OutputStream out) {
        this.out = new PrintStream(out);
    }

    private static boolean isPrimitive(Class type) {
        return type.isPrimitive() || type == String.class;
    }

    private String nextId(Class c) {
        Integer prev = this.idCounts.get(c);
        if (prev == null) {
            prev = -1;
        }
        int result = prev + 1;
        this.idCounts.put(c, result);
        return Utilities.decapitalize(c.getSimpleName()) + result;
    }

    public Properties.Property[] getProperties(Class c) {
        Properties.Property[] result = this.classToProperties.get(c);
        if (result == null) {
            result = Properties.computeProperties(c);
            this.classToProperties.put(c, result);
        }
        return result;
    }

    public void write(Object o) {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.level = -1;
        NameValue traversal = this.traverse(Object.class, null, o, true);
        traversal.write();
    }

    private void indent() {
        for (int i = 0; i < this.level; ++i) {
            this.out.write(32);
            this.out.write(32);
        }
    }

    private void print(String s) {
        this.indent();
        this.out.print(s);
    }

    private void println(String s) {
        this.indent();
        this.out.println(s);
    }

    private void writeAttribute(String name, Object value) {
        this.print("\n");
        ++this.level;
        this.print(name + " = \"" + value + "\"");
        --this.level;
    }

    private NameValue traverse(@NonNull Class type, String name, Object value, boolean isTopLevel) {
        if (XMLWriter.isPrimitive(type)) {
            return new Attribute<Object>(name, value);
        }
        if (type == Class.class) {
            return new ClassAttribute(name, (Class)value);
        }
        Element result = new Element(type, name, value);
        Class<?> aClass = value.getClass();
        if (isTopLevel) {
            String packageName = aClass.getPackage().getName();
            result.attributes.add(new Attribute<String>("ns", "http://schemas.android.com?import=" + packageName + ".*"));
        }
        Info info = this.objectToInfo.get(value);
        ++info.count;
        if (info.count > 1) {
            return result;
        }
        for (Properties.Property p : this.getProperties(aClass)) {
            try {
                Object propertyValue = p.getValue(value);
                if (propertyValue == null) continue;
                this.traverse(p.getType(), p.getName(), propertyValue, false).addToParent(result);
            }
            catch (Properties.PropertyAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                this.traverse(Object.class, null, element, false).addToParent(result);
            }
        }
        return result;
    }

    class Element
    extends NameValue<Object> {
        public String tag;
        public final Class type;
        public final ArrayList<Attribute> attributes;
        public final ArrayList<Element> elements;

        Element(Class type, String name, Object value) {
            super(name, value);
            this.attributes = new ArrayList();
            this.elements = new ArrayList();
            this.tag = name;
            this.type = type;
        }

        @Override
        public void write() {
            XMLWriter.this.level++;
            String tag = this.tag == null ? "object" : this.tag;
            XMLWriter.this.print("<" + tag);
            Info info = (Info)XMLWriter.this.objectToInfo.get(this.value);
            if (info.count > 1) {
                if (info.id == UNDEFINED) {
                    info.id = XMLWriter.this.nextId(this.value.getClass());
                    XMLWriter.this.writeAttribute("id", info.id);
                } else {
                    XMLWriter.this.writeAttribute("idref", info.id);
                }
            }
            for (Attribute attribute : this.attributes) {
                attribute.write();
            }
            if (!this.elements.isEmpty()) {
                XMLWriter.this.out.println(">");
                for (Element element : this.elements) {
                    element.write();
                }
                XMLWriter.this.println("</" + tag + ">");
            } else {
                XMLWriter.this.out.println("/>");
            }
            XMLWriter.this.level--;
        }

        @Override
        public void addToParent(Element parent) {
            parent.elements.add(this);
        }
    }

    class ClassAttribute
    extends Attribute<Class> {
        public ClassAttribute(String name, Class value) {
            super(name, value);
        }

        @Override
        public void addToParent(Element parent) {
            if (parent.type != this.value) {
                if (parent.tag == null) {
                    parent.tag = Utilities.decapitalize(((Class)this.value).getSimpleName());
                } else {
                    super.addToParent(parent);
                }
            }
        }

        @Override
        public void write() {
            XMLWriter.this.writeAttribute(this.name, ((Class)this.value).getName());
        }
    }

    class Attribute<T>
    extends NameValue<T> {
        Attribute(String name, T value) {
            super(name, value);
        }

        @Override
        public void write() {
            XMLWriter.this.writeAttribute(this.name, this.value);
        }

        @Override
        public void addToParent(Element parent) {
            parent.attributes.add(this);
        }
    }

    abstract class NameValue<T> {
        public final String name;
        public final T value;

        NameValue(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public abstract void write();

        public abstract void addToParent(Element var1);
    }

    static class Info {
        String id = UNDEFINED;
        int count = 0;

        Info() {
        }
    }
}

