/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.ui.ColorPanel;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.plugins.xpathView.Config;
import org.jetbrains.annotations.NotNull;

public class ConfigUI
extends JPanel {
    private JCheckBox scrollToFirst;
    private JCheckBox useContextAtCursor;
    private JCheckBox highlightStartTagOnly;
    private JCheckBox addErrorStripe;
    private JCheckBox showInToolbar;
    private JCheckBox showInMainMenu;
    private ColorPanel chooseHighlight;
    private ColorPanel chooseContext;

    public ConfigUI(Config configuration) {
        this.init();
        this.setConfig(configuration);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel c = this;
        this.scrollToFirst = new JCheckBox("Scroll first hit into visible area");
        this.scrollToFirst.setMnemonic('S');
        this.useContextAtCursor = new JCheckBox("Use node at cursor as context node");
        this.useContextAtCursor.setMnemonic('N');
        this.useContextAtCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigUI.this.stateChanged();
            }
        });
        this.highlightStartTagOnly = new JCheckBox("Highlight only start tag instead of whole tag content");
        this.highlightStartTagOnly.setMnemonic('H');
        this.addErrorStripe = new JCheckBox("Add error stripe markers for each result");
        this.addErrorStripe.setMnemonic('A');
        this.showInToolbar = new JCheckBox("Show actions in Toolbar");
        this.showInToolbar.setMnemonic('T');
        this.showInToolbar.setToolTipText("Uncheck to remove XPath-related actions from the toolbar");
        this.showInMainMenu = new JCheckBox("Show actions in Main Menu");
        this.showInMainMenu.setMnemonic('M');
        this.showInMainMenu.setToolTipText("Uncheck to remove XPath-related actions from the Main-Menubar");
        JPanel settings = new JPanel(new BorderLayout());
        settings.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Settings", (boolean)true));
        ConfigUI configUI = c;
        c = new JPanel(new BorderLayout());
        configUI.add((Component)c, "North");
        c.add((Component)settings, "North");
        settings.add((Component)this.scrollToFirst, "North");
        JPanel jPanel = settings;
        settings = new JPanel(new BorderLayout());
        jPanel.add((Component)settings, "South");
        settings.add((Component)this.useContextAtCursor, "North");
        JPanel jPanel2 = settings;
        settings = new JPanel(new BorderLayout());
        jPanel2.add((Component)settings, "South");
        settings.add((Component)this.highlightStartTagOnly, "North");
        JPanel jPanel3 = settings;
        settings = new JPanel(new BorderLayout());
        jPanel3.add((Component)settings, "South");
        settings.add((Component)this.addErrorStripe, "North");
        JPanel jPanel4 = settings;
        settings = new JPanel(new BorderLayout());
        jPanel4.add((Component)settings, "South");
        settings.add((Component)this.showInToolbar, "North");
        JPanel jPanel5 = settings;
        settings = new JPanel(new BorderLayout());
        jPanel5.add((Component)settings, "South");
        settings.add((Component)this.showInMainMenu, "North");
        settings.add((Component)new JPanel(new BorderLayout()), "South");
        JPanel colors = new JPanel(new GridBagLayout());
        colors.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Colors", (boolean)true));
        JPanel jPanel6 = c;
        c = new JPanel(new BorderLayout());
        jPanel6.add((Component)c, "South");
        c.add((Component)colors, "North");
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        colors.add((Component)new JLabel("Highlight color:"), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        this.chooseHighlight = new ColorPanel();
        colors.add((Component)this.chooseHighlight, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        colors.add((Component)new JLabel("Context node color:"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        this.chooseContext = new ColorPanel();
        colors.add((Component)this.chooseContext, constraints);
    }

    @NotNull
    public Config getConfig() {
        Config config = new Config();
        config.setHighlightStartTagOnly(this.highlightStartTagOnly.isSelected());
        config.setUseContextAtCursor(this.useContextAtCursor.isSelected());
        config.setScrollToFirst(this.scrollToFirst.isSelected());
        config.setAddErrorStripe(this.addErrorStripe.isSelected());
        config.SHOW_IN_TOOLBAR = this.showInToolbar.isSelected();
        config.SHOW_IN_MAIN_MENU = this.showInMainMenu.isSelected();
        config.getAttributes().setBackgroundColor(this.chooseHighlight.getSelectedColor());
        if (this.useContextAtCursor.isSelected()) {
            config.getContextAttributes().setBackgroundColor(this.chooseContext.getSelectedColor());
        }
        Config config2 = config;
        if (config2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/ConfigUI", "getConfig"));
        }
        return config2;
    }

    public void setConfig(@NotNull Config configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/xpathView/ui/ConfigUI", "setConfig"));
        }
        this.scrollToFirst.setSelected(configuration.isScrollToFirst());
        this.highlightStartTagOnly.setSelected(configuration.isHighlightStartTagOnly());
        this.useContextAtCursor.setSelected(configuration.isUseContextAtCursor());
        this.addErrorStripe.setSelected(configuration.isAddErrorStripe());
        this.showInToolbar.setSelected(configuration.SHOW_IN_TOOLBAR);
        this.showInMainMenu.setSelected(configuration.SHOW_IN_MAIN_MENU);
        this.chooseHighlight.setSelectedColor(configuration.getAttributes().getBackgroundColor());
        this.chooseContext.setSelectedColor(configuration.getContextAttributes().getBackgroundColor());
        this.stateChanged();
    }

    private void stateChanged() {
        this.chooseContext.setEnabled(this.useContextAtCursor.isSelected());
    }

    public static void main(String[] args) {
        JFrame test = new JFrame("Config test");
        test.setDefaultCloseOperation(3);
        JPanel comp = new JPanel(new BorderLayout());
        comp.add((Component)new ConfigUI(new Config()), "Center");
        test.getContentPane().add(comp);
        test.setSize(450, 450);
        test.setVisible(true);
    }
}

