/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltCodeInsightUtil {
    public static final PsiElementFilter XSLT_PARAM_FILTER = new PsiElementFilter(){

        public boolean isAccepted(PsiElement element) {
            return element instanceof XmlTag && XsltSupport.isParam((XmlTag)element);
        }
    };
    public static final Comparator<PsiElement> POSITION_COMPARATOR = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            return o1.getTextOffset() - o2.getTextOffset();
        }
    };

    private XsltCodeInsightUtil() {
    }

    @Nullable
    public static XmlTag getTemplateTag(@NotNull PsiElement location, boolean isExpression, boolean requireName) {
        PsiElement p;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getTemplateTag"));
        }
        PsiElement psiElement = p = isExpression ? location.getContainingFile().getContext() : location;
        while ((p = PsiTreeUtil.getParentOfType((PsiElement)p, XmlTag.class)) != null) {
            XmlTag _p = (XmlTag)p;
            if (!XsltSupport.isTemplate(_p, requireName)) continue;
            return _p;
        }
        return null;
    }

    @Nullable
    public static XmlTag getTemplateTag(@NotNull PsiElement location, boolean isExpression) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getTemplateTag"));
        }
        return XsltCodeInsightUtil.getTemplateTag(location, isExpression, false);
    }

    @Nullable
    public static XsltTemplate getTemplate(@NotNull PsiElement location, boolean isExpression) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getTemplate"));
        }
        XmlTag templateTag = XsltCodeInsightUtil.getTemplateTag(location, isExpression);
        return templateTag != null ? XsltElementFactory.getInstance().wrapElement(templateTag, XsltTemplate.class) : null;
    }

    @Nullable
    public static PsiElement findFirstRealTagChild(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "findFirstRealTagChild"));
        }
        final PsiElement[] child = new PsiElement[1];
        xmlTag.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil$3", "execute"));
                }
                if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_TAG_END) {
                    child[0] = element.getNextSibling();
                    return false;
                }
                return true;
            }
        }, (PsiElement)xmlTag);
        return child[0];
    }

    @Nullable
    public static XPathExpression getXPathExpression(XsltElement xsltElement, String attributeName) {
        Object[] files;
        XmlAttribute attribute = xsltElement.getTag().getAttribute(attributeName, null);
        if (attribute != null && (files = XsltSupport.getFiles(attribute)).length > 0) {
            assert (files.length == 1) : "Unexpected number of XPathFiles in @" + attributeName + ": " + Arrays.toString(files);
            return (XPathExpression)PsiTreeUtil.getChildOfType((PsiElement)files[0], XPathExpression.class);
        }
        return null;
    }

    public static boolean areExpressionsEquivalent(XPathExpression x1, XPathExpression x2) {
        if (x1.getType() != x2.getType()) {
            return false;
        }
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)x1, (PsiElement)x2);
    }

    @Nullable
    public static XmlTag findLastParam(XmlTag templateTag) {
        ArrayList list = new ArrayList();
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(XSLT_PARAM_FILTER, list);
        templateTag.processElements((PsiElementProcessor)processor, (PsiElement)templateTag);
        return list.size() > 0 ? (XmlTag)list.get(list.size() - 1) : null;
    }

    @NotNull
    public static TextRange getRangeInsideHostingFile(XPathElement expr) {
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getContextOfType((PsiElement)expr, PsiLanguageInjectionHost.class, (boolean)true);
        assert (host != null);
        List psi = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        assert (psi != null);
        for (Pair pair : psi) {
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)pair.first), (PsiElement)expr, (boolean)false)) continue;
            TextRange textRange = expr.getTextRange().shiftRight(((TextRange)pair.second).getStartOffset() + host.getTextRange().getStartOffset());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getRangeInsideHostingFile"));
            }
            return textRange;
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getRangeInsideHostingFile"));
        }
        return null;
    }

    @NotNull
    public static TextRange getRangeInsideHost(XPathElement expr) {
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getContextOfType((PsiElement)expr, PsiLanguageInjectionHost.class, (boolean)true);
        assert (host != null);
        List psi = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        assert (psi != null);
        for (Pair pair : psi) {
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)pair.first), (PsiElement)expr, (boolean)false)) continue;
            TextRange textRange = (TextRange)pair.second;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getRangeInsideHost"));
            }
            return textRange;
        }
        assert (false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getRangeInsideHost"));
        }
        return null;
    }

    public static XmlTag findLastWithParam(XmlTag templateTag) {
        final XmlTag[] lastParam = new XmlTag[1];
        templateTag.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil$4", "execute"));
                }
                if (element instanceof XmlTag) {
                    if ("with-param".equals(((XmlTag)element).getLocalName())) {
                        lastParam[0] = (XmlTag)element;
                    } else {
                        return false;
                    }
                }
                return true;
            }
        }, (PsiElement)templateTag);
        return lastParam[0];
    }

    public static XmlTag findVariableInsertionPoint(XmlTag currentUsageTag, PsiElement usageBlock, final String referenceName, XmlTag ... moreUsages) {
        XmlTag[] subTags;
        XmlTag xmlTag;
        PsiElement t;
        XmlTag firstUsage;
        final TreeSet<PsiElement> usages = new TreeSet<PsiElement>(POSITION_COMPARATOR);
        usages.add((PsiElement)currentUsageTag);
        ContainerUtil.addAll(usages, (Object[])moreUsages);
        usageBlock.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof XPathVariableReference) {
                    this.visitXPathVariableReference((XPathVariableReference)element);
                } else {
                    super.visitElement(element);
                }
            }

            private void visitXPathVariableReference(XPathVariableReference reference) {
                if (referenceName.equals(reference.getReferencedName()) && reference.resolve() == null) {
                    usages.add(PsiTreeUtil.getContextOfType((PsiElement)reference, XmlTag.class, (boolean)true));
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (XsltSupport.isXPathAttribute(attribute)) {
                    PsiFile[] xpathFiles;
                    for (PsiFile xpathFile : xpathFiles = XsltSupport.getFiles(attribute)) {
                        xpathFile.accept((PsiElementVisitor)this);
                    }
                }
            }
        });
        Iterator it = usages.iterator();
        XmlTag tag = firstUsage = (XmlTag)it.next();
        while (it.hasNext() && (t = PsiTreeUtil.findCommonParent((PsiElement)tag, (PsiElement)(xmlTag = (XmlTag)it.next()))) instanceof XmlTag) {
            tag = (XmlTag)t;
        }
        for (XmlTag xmlTag2 : subTags = tag.getSubTags()) {
            if (xmlTag2.getTextOffset() > firstUsage.getTextOffset()) break;
            tag = xmlTag2;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return tag;
        }
        String parentName = parentTag.getLocalName();
        if ("apply-templates".equals(parentName) || "call-template".equals(parentName) || "when".equals(parentName) || "choose".equals(parentName)) {
            if ("when".equals(parentName)) {
                tag = tag.getParentTag();
            }
            assert (tag != null);
            tag = tag.getParentTag();
        }
        assert (tag != null);
        return tag;
    }

    @Nullable
    public static PsiElement getUsageBlock(XPathExpression reference) {
        XmlTag template = XsltCodeInsightUtil.getTemplateTag(reference, true);
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)reference, XmlTag.class, (boolean)true);
        assert (tag != null);
        return template != null ? template.getNavigationElement() : tag.getParentTag();
    }

    @NotNull
    public static XmlDocument getDocument(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getDocument"));
        }
        XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class, (boolean)false);
        assert (document != null);
        XmlDocument xmlDocument = document;
        if (xmlDocument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getDocument"));
        }
        return xmlDocument;
    }

    public static XmlDocument getDocument(@NotNull XsltElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil", "getDocument"));
        }
        return XsltCodeInsightUtil.getDocument((XmlElement)element.getTag());
    }

    @Nullable
    public static XPathType getDeclaredType(XmlTag element) {
        XmlAttribute typeAttr = element.getAttribute("as");
        if (typeAttr != null) {
            String value = typeAttr.getValue();
            XPath2Type returnType = value != null ? XPath2Type.fromName(QNameUtil.createQName(value, (PsiElement)element)) : null;
            return returnType != null ? returnType : XPathType.UNKNOWN;
        }
        return null;
    }
}

