/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring;

import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringActionHandler;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.refactoring.XsltExtractFunctionAction;
import org.intellij.lang.xpath.xslt.refactoring.introduceParameter.XsltIntroduceParameterAction;
import org.intellij.lang.xpath.xslt.refactoring.introduceVariable.XsltIntroduceVariableAction;
import org.jetbrains.annotations.NotNull;

public class XPathRefactoringSupportProvider
extends RefactoringSupportProvider {
    public boolean isAvailable(@NotNull PsiElement context) {
        XmlFile xmlFile;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/refactoring/XPathRefactoringSupportProvider", "isAvailable"));
        }
        PsiFile containingFile = context.getContainingFile();
        return containingFile instanceof XPathFile && (xmlFile = (XmlFile)PsiTreeUtil.getContextOfType((PsiElement)containingFile, (Class[])new Class[]{XmlFile.class})) != null && XsltSupport.isXsltFile((PsiFile)xmlFile);
    }

    public boolean isInplaceRenameAvailable(@NotNull PsiElement element, PsiElement context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/refactoring/XPathRefactoringSupportProvider", "isInplaceRenameAvailable"));
        }
        return element instanceof XsltVariable && element.getUseScope() instanceof LocalSearchScope;
    }

    public RefactoringActionHandler getIntroduceParameterHandler() {
        return new XsltIntroduceParameterAction();
    }

    public RefactoringActionHandler getIntroduceVariableHandler() {
        return new XsltIntroduceVariableAction();
    }

    public RefactoringActionHandler getExtractMethodHandler() {
        return new XsltExtractFunctionAction();
    }

    public boolean isSafeDeleteAvailable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/xslt/refactoring/XPathRefactoringSupportProvider", "isSafeDeleteAvailable"));
        }
        return element instanceof XPathVariable || element instanceof XsltTemplate;
    }
}

