/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.xpath.xslt.XsltConfig;
import org.intellij.lang.xpath.xslt.impl.XsltFormattingModelBuilder;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XsltConfigImpl
extends XsltConfig
implements JDOMExternalizable,
ApplicationComponent {
    public boolean SHOW_LINKED_FILES = true;

    XsltConfigImpl() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public void initComponent() {
        Language xmlLang = StdFileTypes.XML.getLanguage();
        XsltFormattingModelBuilder builder = new XsltFormattingModelBuilder((FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(xmlLang));
        LanguageFormatting.INSTANCE.addExplicitExtension((Object)xmlLang, (Object)builder);
        try {
            ActionManager.getInstance().getAction("IntroduceParameter").setInjectedContext(true);
        }
        catch (Exception e) {
            Logger.getInstance((String)XsltConfigImpl.class.getName()).error((Throwable)e);
        }
    }

    public void disposeComponent() {
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("XSLT-Support.Configuration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltConfigImpl", "getComponentName"));
        }
        return "XSLT-Support.Configuration";
    }

    @Override
    public boolean isShowLinkedFiles() {
        return this.SHOW_LINKED_FILES;
    }

    public static class UIImpl
    extends JPanel
    implements XsltConfig.UI {
        private final JCheckBox myShowLinkedFiles;
        private final XsltConfigImpl myConfig;

        public UIImpl(XsltConfigImpl config) {
            this.myConfig = config;
            this.setLayout(new BoxLayout(this, 1));
            this.myShowLinkedFiles = new JCheckBox("Show Associated Files in Project View");
            this.myShowLinkedFiles.setMnemonic('A');
            this.myShowLinkedFiles.setSelected(this.myConfig.SHOW_LINKED_FILES);
            this.add(this.myShowLinkedFiles);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(Box.createVerticalGlue(), "Center");
            JPanel panel = new JPanel(new FlowLayout(1));
            jPanel.add((Component)panel, "South");
            jPanel.setAlignmentX(0.0f);
            this.add(jPanel);
        }

        @Nls
        public String getDisplayName() {
            return "XSLT";
        }

        @Nullable
        @NonNls
        public String getHelpTopic() {
            return "settings.xslt";
        }

        public void disposeUIResources() {
        }

        public JComponent createComponent() {
            return this;
        }

        public boolean isModified() {
            return this.myConfig.SHOW_LINKED_FILES != this.myShowLinkedFiles.isSelected();
        }

        public void apply() {
            boolean oldValue = this.myConfig.SHOW_LINKED_FILES;
            this.myConfig.SHOW_LINKED_FILES = this.myShowLinkedFiles.isSelected();
            if (oldValue != this.myConfig.SHOW_LINKED_FILES) {
                Project[] projects;
                for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                    ProjectView.getInstance((Project)project).refresh();
                }
            }
        }

        public void reset() {
            this.myShowLinkedFiles.setSelected(this.myConfig.SHOW_LINKED_FILES);
        }

        @NotNull
        public String getId() {
            String string = this.getHelpTopic();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltConfigImpl$UIImpl", "getId"));
            }
            return string;
        }

        public Runnable enableSearch(String option) {
            return null;
        }
    }
}

