/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.VariableContext;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.intellij.lang.xpath.psi.XPathVariableDeclaration;
import org.intellij.lang.xpath.psi.XPathVariableHolder;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathVariableReferenceImpl
extends XPathElementImpl
implements XPathVariableReference {
    private static final TokenSet QNAME_FILTER = TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.VARIABLE_PREFIX, XPathTokenTypes.VARIABLE_NAME});

    public XPathVariableReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getReferencedName() {
        String string = this.getText().substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl", "getReferencedName"));
        }
        return string;
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathVariable xPathVariable = this.resolve();
        if (xPathVariable != null) {
            XPathType xPathType = xPathVariable.getType();
            if (xPathType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl", "getType"));
            }
            return xPathType;
        }
        XPathType xPathType = XPathType.UNKNOWN;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl", "getType"));
        }
        return xPathType;
    }

    public PsiReference getReference() {
        return this;
    }

    public PsiElement getElement() {
        return this;
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset() + 1;
    }

    public TextRange getRangeInElement() {
        return TextRange.from((int)1, (int)(this.getTextLength() - 1));
    }

    @Override
    @Nullable
    public XPathVariable resolve() {
        VariableContext context;
        if (this.getContainingFile().getLanguage() == XPathFileType.XPATH2.getLanguage()) {
            XPathVariableHolder f = (XPathVariableHolder)PsiTreeUtil.getParentOfType((PsiElement)this, XPathVariableHolder.class, (boolean)true);
            while (f != null) {
                XPathVariable variable = XPathVariableReferenceImpl.findVariable(f.getVariables(), this.getReferencedName());
                if (variable != null) {
                    return variable;
                }
                f = (XPathVariableHolder)PsiTreeUtil.getParentOfType((PsiElement)f, XPathVariableHolder.class, (boolean)true);
            }
        }
        if ((context = this.getXPathContext().getVariableContext()) == null) {
            return null;
        }
        return context.resolve(this);
    }

    @Nullable
    private static XPathVariable findVariable(XPathVariableDeclaration[] declarations, String referencedName) {
        for (XPathVariableDeclaration decl : declarations) {
            XPathVariable v = decl.getVariable();
            if (v == null || !referencedName.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.renameTo(newElementName);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl", "bindToElement"));
        }
        this.renameTo(((PsiNamedElement)element).getName());
        return this;
    }

    private void renameTo(String newElementName) {
        XPathVariableReference child = XPathChangeUtil.createVariableReference(this, newElementName);
        PrefixedNameImpl newName = (PrefixedNameImpl)child.getQName();
        PrefixedNameImpl oldName = (PrefixedNameImpl)this.getQName();
        assert (newName != null);
        assert (oldName != null);
        ASTNode localNode = newName.getLocalNode();
        this.getNode().replaceChild(oldName.getLocalNode(), localNode);
    }

    public boolean isReferenceTo(PsiElement element) {
        VariableContext context;
        if (element instanceof XPathVariable) {
            XPathVariable resolved = this.resolve();
            if (this.getReferencedName().equals(((XPathVariable)element).getName()) && element.equals(resolved)) {
                return true;
            }
        }
        if ((context = this.getXPathContext().getVariableContext()) != null) {
            return context.isReferenceTo(element, this);
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathVariableReferenceImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }

    @Override
    @Nullable
    public PrefixedName getQName() {
        ASTNode[] nodes = this.getNode().getChildren(QNAME_FILTER);
        if (nodes.length == 1) {
            return new PrefixedNameImpl(nodes[0]);
        }
        if (nodes.length == 2) {
            return new PrefixedNameImpl(nodes[0], nodes[1]);
        }
        return null;
    }

    public int hashCode() {
        return this.getReferencedName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathVariableReference(this);
    }
}

