/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixedNameImpl
implements PrefixedName {
    private final ASTNode prefixNode;
    private final ASTNode localNode;

    PrefixedNameImpl(@Nullable ASTNode prefixNode, @NotNull ASTNode localNode) {
        if (localNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/lang/xpath/psi/impl/PrefixedNameImpl", "<init>"));
        }
        this.prefixNode = prefixNode;
        this.localNode = localNode;
    }

    public PrefixedNameImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/psi/impl/PrefixedNameImpl", "<init>"));
        }
        this(null, node);
    }

    @Override
    public String getPrefix() {
        return this.prefixNode != null ? this.prefixNode.getText() : null;
    }

    @Override
    @NotNull
    public String getLocalName() {
        String string = this.localNode.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/PrefixedNameImpl", "getLocalName"));
        }
        return string;
    }

    public ASTNode getPrefixNode() {
        return this.prefixNode;
    }

    public ASTNode getLocalNode() {
        return this.localNode;
    }

    public String toString() {
        return this.prefixText() + this.localNode.getText();
    }

    private String prefixText() {
        return this.prefixNode != null ? this.prefixNode.getText() + ":" : "";
    }

    public boolean equals(Object object) {
        return object.getClass() == this.getClass() && ((PrefixedName)object).getLocalName().equals(this.getLocalName());
    }

    public int hashCode() {
        return this.getLocalName().hashCode();
    }
}

