/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.cacheBuilder.SimpleWordsScanner;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lexer.Lexer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathHighlighter;
import org.intellij.lang.xpath.XPathLexer;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.completion.CompletionLists;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.psi.XPathVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XPathLanguage
extends Language {
    public static final String ID = "XPath";

    XPathLanguage() {
        super(ID);
    }

    public XPathFileType getAssociatedFileType() {
        return XPathFileType.XPATH;
    }

    public static class XPathSyntaxHighlighterFactory
    extends SingleLazyInstanceSyntaxHighlighterFactory {
        @NotNull
        protected SyntaxHighlighter createHighlighter() {
            XPathHighlighter xPathHighlighter = new XPathHighlighter(false);
            if (xPathHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathSyntaxHighlighterFactory", "createHighlighter"));
            }
            return xPathHighlighter;
        }
    }

    public static class XPathNamesValidator
    implements NamesValidator {
        private final Lexer xPathLexer = XPathLexer.create(false);

        public synchronized boolean isIdentifier(@NotNull String text, Project project) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathNamesValidator", "isIdentifier"));
            }
            this.xPathLexer.start((CharSequence)text);
            assert (this.xPathLexer.getState() == 0);
            boolean b = this.xPathLexer.getTokenType() == XPathTokenTypes.NCNAME;
            this.xPathLexer.advance();
            if (this.xPathLexer.getTokenType() == null) {
                return b;
            }
            if (this.xPathLexer.getTokenType() == XPathTokenTypes.COL) {
                this.xPathLexer.advance();
                b = this.xPathLexer.getTokenType() == XPathTokenTypes.NCNAME;
                this.xPathLexer.advance();
                return b && this.xPathLexer.getTokenType() == null;
            }
            return false;
        }

        public boolean isKeyword(@NotNull String text, Project project) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathNamesValidator", "isKeyword"));
            }
            return CompletionLists.AXIS_NAMES.contains(text) || CompletionLists.NODE_TYPE_FUNCS.contains(text) || CompletionLists.OPERATORS.contains(text);
        }
    }

    public static class XPathFindUsagesProvider
    implements FindUsagesProvider {
        @Nullable
        public WordsScanner getWordsScanner() {
            return new SimpleWordsScanner();
        }

        public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "canFindUsagesFor"));
            }
            return psiElement instanceof XPathFunction || psiElement instanceof XPathVariable;
        }

        @Nullable
        public String getHelpId(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getHelpId"));
            }
            return null;
        }

        @NotNull
        public String getType(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getType"));
            }
            if (element instanceof XPathFunction) {
                if ("function" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getType"));
                }
                return "function";
            }
            if (element instanceof XPathVariable) {
                if ("variable" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getType"));
                }
                return "variable";
            }
            if ("unknown" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getType"));
            }
            return "unknown";
        }

        @NotNull
        public String getDescriptiveName(@NotNull PsiElement element) {
            String name;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getDescriptiveName"));
            }
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
            String string = element.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }

        @NotNull
        public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
            String name;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getNodeText"));
            }
            if (useFullName && element instanceof NavigationItem) {
                String text;
                NavigationItem navigationItem = (NavigationItem)element;
                ItemPresentation presentation = navigationItem.getPresentation();
                if (presentation != null && (text = presentation.getPresentableText()) != null) {
                    String string = text;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getNodeText"));
                    }
                    return string;
                }
                String name2 = navigationItem.getName();
                if (name2 != null) {
                    String string = name2;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getNodeText"));
                    }
                    return string;
                }
            }
            if (element instanceof PsiNamedElement && (name = ((PsiNamedElement)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getNodeText"));
                }
                return string;
            }
            String string = element.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/XPathLanguage$XPathFindUsagesProvider", "getNodeText"));
            }
            return string;
        }
    }

    public static class XPathPairedBraceMatcher
    implements PairedBraceMatcher {
        private BracePair[] myBracePairs;

        public BracePair[] getPairs() {
            if (this.myBracePairs == null) {
                this.myBracePairs = new BracePair[]{new BracePair(XPathTokenTypes.LPAREN, XPathTokenTypes.RPAREN, false), new BracePair(XPathTokenTypes.LBRACKET, XPathTokenTypes.RBRACKET, false)};
            }
            return this.myBracePairs;
        }

        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            return openingBraceOffset;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (lbraceType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/lang/xpath/XPathLanguage$XPathPairedBraceMatcher", "isPairedBracesAllowedBeforeType"));
            }
            return true;
        }
    }
}

