/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.incremental.groovy.GroovycOSProcessHandler;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.incremental.java.ClassPostProcessor;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class GroovyBuilder
extends ModuleLevelBuilder {
    private static final int ourOptimizeThreshold = Integer.parseInt(System.getProperty("groovyc.optimized.class.loading.threshold", "10"));
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.GroovyBuilder");
    private static final Key<Boolean> CHUNK_REBUILD_ORDERED = Key.create((String)"CHUNK_REBUILD_ORDERED");
    private static final Key<Map<String, String>> STUB_TO_SRC = Key.create((String)"STUB_TO_SRC");
    private static final Key<Boolean> FILES_MARKED_DIRTY_FOR_NEXT_ROUND = Key.create((String)"SRC_MARKED_DIRTY");
    private static final String GROOVY_EXTENSION = "groovy";
    private static final String GPP_EXTENSION = "gpp";
    private final boolean myForStubs;
    private final String myBuilderName;

    public GroovyBuilder(boolean forStubs) {
        super(forStubs ? BuilderCategory.SOURCE_GENERATOR : BuilderCategory.OVERWRITING_TRANSLATOR);
        this.myForStubs = forStubs;
        this.myBuilderName = "Groovy " + (forStubs ? "stub generator" : "compiler");
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException {
        long start = 0L;
        try {
            ModuleLevelBuilder.ExitCode exitCode;
            Map<ModuleBuildTarget, String> finalOutputs;
            JpsGroovySettings settings = JpsGroovySettings.getSettings(context.getProjectDescriptor().getProject());
            List<File> toCompile = this.collectChangedFiles(context, dirtyFilesHolder, settings);
            if (toCompile.isEmpty()) {
                ModuleLevelBuilder.ExitCode exitCode2 = this.hasFilesToCompileForNextRound(context) != false ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                return exitCode2;
            }
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("forStubs=" + this.myForStubs);
            }
            if ((finalOutputs = this.getCanonicalModuleOutputs(context, chunk)) == null) {
                ModuleLevelBuilder.ExitCode exitCode3 = ModuleLevelBuilder.ExitCode.ABORT;
                return exitCode3;
            }
            start = System.currentTimeMillis();
            Set<String> toCompilePaths = GroovyBuilder.getPathsToCompile(toCompile);
            JpsSdk<JpsDummyElement> jdk = GroovyBuilder.getJdk(chunk);
            String version = jdk == null ? SystemInfo.JAVA_RUNTIME_VERSION : jdk.getVersionString();
            boolean mayDependOnUtilJar = version != null && StringUtil.compareVersionNumbers((String)version, (String)"1.6") >= 0;
            boolean optimizeClassLoading = mayDependOnUtilJar && ourOptimizeThreshold != 0 && toCompilePaths.size() >= ourOptimizeThreshold;
            Map<String, String> class2Src = GroovyBuilder.buildClassToSourceMap(chunk, context, toCompilePaths, finalOutputs);
            String encoding = context.getProjectDescriptor().getEncodingConfiguration().getPreferredModuleChunkEncoding(chunk);
            ArrayList<String> patchers = new ArrayList<String>();
            for (GroovyBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(GroovyBuilderExtension.class)) {
                patchers.addAll(extension.getCompilationUnitPatchers(context, chunk));
            }
            Map<ModuleBuildTarget, String> generationOutputs = this.myForStubs ? GroovyBuilder.getStubGenerationOutputs(chunk, context) : finalOutputs;
            String compilerOutput = generationOutputs.get(chunk.representativeTarget());
            Collection<String> classpath = GroovyBuilder.generateClasspath(context, chunk);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Optimized class loading: " + optimizeClassLoading);
                LOG.debug("Groovyc classpath: " + classpath);
            }
            File tempFile = GroovycOSProcessHandler.fillFileWithGroovycParameters(compilerOutput, toCompilePaths, finalOutputs.values(), class2Src, encoding, patchers, optimizeClassLoading ? StringUtil.join(classpath, (String)File.pathSeparator) : "");
            GroovycOSProcessHandler handler = this.runGroovyc(context, chunk, tempFile, settings, classpath, optimizeClassLoading);
            Map<ModuleBuildTarget, Collection<GroovycOSProcessHandler.OutputItem>> compiled = GroovyBuilder.processCompiledFiles(context, chunk, generationOutputs, compilerOutput, handler);
            if (GroovyBuilder.checkChunkRebuildNeeded(context, handler)) {
                ModuleLevelBuilder.ExitCode exitCode4 = ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
                return exitCode4;
            }
            if (this.myForStubs) {
                GroovyBuilder.addStubRootsToJavacSourcePath(context, generationOutputs);
                GroovyBuilder.rememberStubSources(context, compiled);
            }
            for (CompilerMessage message : handler.getCompilerMessages(chunk.representativeTarget().getModule().getName())) {
                context.processMessage((BuildMessage)message);
            }
            if (!this.myForStubs && this.updateDependencies(context, chunk, dirtyFilesHolder, toCompile, compiled, outputConsumer)) {
                exitCode = ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED;
                return exitCode;
            }
            exitCode = this.hasFilesToCompileForNextRound(context) != false ? ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED : ModuleLevelBuilder.ExitCode.OK;
            return exitCode;
        }
        catch (Exception e) {
            throw new ProjectBuildException((Throwable)e);
        }
        finally {
            if (start > 0L && LOG.isDebugEnabled()) {
                LOG.debug(this.myBuilderName + " took " + (System.currentTimeMillis() - start) + " on " + chunk.getName());
            }
            if (!this.myForStubs) {
                FILES_MARKED_DIRTY_FOR_NEXT_ROUND.set((UserDataHolder)context, null);
            }
        }
    }

    private Boolean hasFilesToCompileForNextRound(CompileContext context) {
        return !this.myForStubs && (Boolean)FILES_MARKED_DIRTY_FOR_NEXT_ROUND.get((UserDataHolder)context, (Object)Boolean.FALSE) != false;
    }

    private static Set<String> getPathsToCompile(List<File> toCompile) {
        LinkedHashSet<String> toCompilePaths = new LinkedHashSet<String>();
        for (File file : toCompile) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path to compile: " + file.getPath());
            }
            toCompilePaths.add(FileUtil.toSystemIndependentName((String)file.getPath()));
        }
        return toCompilePaths;
    }

    private GroovycOSProcessHandler runGroovyc(final CompileContext context, final ModuleChunk chunk, File tempFile, JpsGroovySettings settings, Collection<String> compilationClassPath, boolean optimizeClassLoading) throws IOException {
        ArrayList<String> classpath = new ArrayList<String>();
        if (optimizeClassLoading) {
            classpath.add(GroovyBuilder.getGroovyRtRoot().getPath());
            classpath.add(ClasspathBootstrap.getResourcePath(Function.class));
            classpath.add(ClasspathBootstrap.getResourcePath(UrlClassLoader.class));
            classpath.add(ClasspathBootstrap.getResourceFile(THashMap.class).getPath());
        } else {
            classpath.addAll(compilationClassPath);
        }
        ArrayList programParams = ContainerUtilRt.newArrayList((Object[])new String[]{optimizeClassLoading ? "optimize" : "do_not_optimize", this.myForStubs ? "stubs" : "groovyc", tempFile.getPath()});
        if (settings.invokeDynamic) {
            programParams.add("--indy");
        }
        ArrayList vmParams = ContainerUtilRt.newArrayList();
        vmParams.add("-Xmx" + settings.heapSize + "m");
        vmParams.add("-Dfile.encoding=" + System.getProperty("file.encoding"));
        String grapeRoot = System.getProperty("grape.root");
        if (grapeRoot != null) {
            vmParams.add("-Dgrape.root=" + grapeRoot);
        }
        List cmd = ExternalProcessUtil.buildJavaCommandLine((String)GroovyBuilder.getJavaExecutable(chunk), (String)"org.jetbrains.groovy.compiler.rt.GroovycRunner", Collections.emptyList(), classpath, (List)vmParams, (List)programParams);
        Process process = Runtime.getRuntime().exec(ArrayUtil.toStringArray((Collection)cmd));
        Consumer<String> updater = new Consumer<String>(){

            public void consume(String s) {
                context.processMessage((BuildMessage)new ProgressMessage(s + " [" + chunk.getPresentableShortName() + "]"));
            }
        };
        GroovycOSProcessHandler handler = new GroovycOSProcessHandler(process, (Consumer)updater){

            protected Future<?> executeOnPooledThread(Runnable task) {
                return SharedThreadPool.getInstance().executeOnPooledThread(task);
            }
        };
        handler.startNotify();
        handler.waitFor();
        return handler;
    }

    private static boolean checkChunkRebuildNeeded(CompileContext context, GroovycOSProcessHandler handler) {
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context) || !handler.shouldRetry()) {
            return false;
        }
        if (CHUNK_REBUILD_ORDERED.get((UserDataHolder)context) != null) {
            CHUNK_REBUILD_ORDERED.set((UserDataHolder)context, null);
            return false;
        }
        CHUNK_REBUILD_ORDERED.set((UserDataHolder)context, (Object)Boolean.TRUE);
        LOG.info("Order chunk rebuild");
        return true;
    }

    private static void rememberStubSources(CompileContext context, Map<ModuleBuildTarget, Collection<GroovycOSProcessHandler.OutputItem>> compiled) {
        HashMap<String, String> stubToSrc = (HashMap<String, String>)STUB_TO_SRC.get((UserDataHolder)context);
        if (stubToSrc == null) {
            stubToSrc = new HashMap<String, String>();
            STUB_TO_SRC.set((UserDataHolder)context, stubToSrc);
        }
        for (Collection<GroovycOSProcessHandler.OutputItem> items : compiled.values()) {
            for (GroovycOSProcessHandler.OutputItem item : items) {
                stubToSrc.put(FileUtil.toSystemIndependentName((String)item.outputPath), item.sourcePath);
            }
        }
    }

    private static void addStubRootsToJavacSourcePath(CompileContext context, Map<ModuleBuildTarget, String> generationOutputs) {
        BuildRootIndex rootsIndex = context.getProjectDescriptor().getBuildRootIndex();
        for (ModuleBuildTarget target : generationOutputs.keySet()) {
            File root = new File(generationOutputs.get(target));
            rootsIndex.associateTempRoot(context, (BuildTarget)target, (BuildRootDescriptor)new JavaSourceRootDescriptor(root, target, true, true, "", Collections.emptySet()));
        }
    }

    private static Map<ModuleBuildTarget, Collection<GroovycOSProcessHandler.OutputItem>> processCompiledFiles(CompileContext context, ModuleChunk chunk, Map<ModuleBuildTarget, String> generationOutputs, String compilerOutput, GroovycOSProcessHandler handler) throws IOException {
        ProjectDescriptor pd = context.getProjectDescriptor();
        THashMap compiled = new THashMap();
        for (GroovycOSProcessHandler.OutputItem item : handler.getSuccessfullyCompiled()) {
            JavaSourceRootDescriptor rd;
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("compiled=" + item);
            }
            if ((rd = pd.getBuildRootIndex().findJavaRootDescriptor(context, new File(item.sourcePath))) != null) {
                String outputPath = GroovyBuilder.ensureCorrectOutput(chunk, item, generationOutputs, compilerOutput, rd.target);
                ArrayList<GroovycOSProcessHandler.OutputItem> items = (ArrayList<GroovycOSProcessHandler.OutputItem>)compiled.get(rd.target);
                if (items == null) {
                    items = new ArrayList<GroovycOSProcessHandler.OutputItem>();
                    compiled.put(rd.target, items);
                }
                items.add(new GroovycOSProcessHandler.OutputItem(outputPath, item.sourcePath));
                continue;
            }
            if (!Utils.IS_TEST_MODE && !LOG.isDebugEnabled()) continue;
            LOG.info("No java source root descriptor for th e item found =" + item);
        }
        return compiled;
    }

    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        JavaBuilderUtil.cleanupChunkResources((CompileContext)context);
        STUB_TO_SRC.set((UserDataHolder)context, null);
    }

    private static Map<ModuleBuildTarget, String> getStubGenerationOutputs(ModuleChunk chunk, CompileContext context) throws IOException {
        HashMap<ModuleBuildTarget, String> generationOutputs = new HashMap<ModuleBuildTarget, String>();
        File commonRoot = new File(context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot(), "groovyStubs");
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File targetRoot = new File(commonRoot, target.getModule().getName() + File.separator + target.getTargetType().getTypeId());
            if (!FileUtil.delete((File)targetRoot)) {
                throw new IOException("External make cannot clean " + targetRoot.getPath());
            }
            if (!targetRoot.mkdirs()) {
                throw new IOException("External make cannot create " + targetRoot.getPath());
            }
            generationOutputs.put(target, targetRoot.getPath());
        }
        return generationOutputs;
    }

    @Nullable
    private Map<ModuleBuildTarget, String> getCanonicalModuleOutputs(CompileContext context, ModuleChunk chunk) {
        HashMap<ModuleBuildTarget, String> finalOutputs = new HashMap<ModuleBuildTarget, String>();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File moduleOutputDir = target.getOutputDir();
            if (moduleOutputDir == null) {
                context.processMessage((BuildMessage)new CompilerMessage(this.myBuilderName, BuildMessage.Kind.ERROR, "Output directory not specified for module " + target.getModule().getName()));
                return null;
            }
            String moduleOutputPath = FileUtil.toCanonicalPath((String)moduleOutputDir.getPath());
            assert (moduleOutputPath != null);
            finalOutputs.put(target, moduleOutputPath.endsWith("/") ? moduleOutputPath : moduleOutputPath + "/");
        }
        return finalOutputs;
    }

    private static String ensureCorrectOutput(ModuleChunk chunk, GroovycOSProcessHandler.OutputItem item, Map<ModuleBuildTarget, String> generationOutputs, String compilerOutput, @NotNull ModuleBuildTarget srcTarget) throws IOException {
        if (srcTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jps/incremental/groovy/GroovyBuilder", "ensureCorrectOutput"));
        }
        if (chunk.getModules().size() > 1 && !srcTarget.equals((Object)chunk.representativeTarget())) {
            File output = new File(item.outputPath);
            String srcTargetOutput = generationOutputs.get(srcTarget);
            if (srcTargetOutput == null) {
                LOG.info("No output for " + srcTarget + "; outputs=" + generationOutputs + "; targets = " + chunk.getTargets());
                return item.outputPath;
            }
            File correctRoot = new File(srcTargetOutput);
            File correctOutput = new File(correctRoot, FileUtil.getRelativePath((File)new File(compilerOutput), (File)output));
            FileUtil.rename((File)output, (File)correctOutput);
            return correctOutput.getPath();
        }
        return item.outputPath;
    }

    private static String getJavaExecutable(ModuleChunk chunk) {
        JpsSdk<JpsDummyElement> sdk = GroovyBuilder.getJdk(chunk);
        return sdk != null ? JpsJavaSdkType.getJavaExecutable(sdk) : SystemProperties.getJavaHome() + "/bin/java";
    }

    private static JpsSdk<JpsDummyElement> getJdk(ModuleChunk chunk) {
        return ((JpsModule)chunk.getModules().iterator().next()).getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
    }

    private List<File> collectChangedFiles(CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, final JpsGroovySettings settings) throws IOException {
        final JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject());
        assert (configuration != null);
        final ArrayList<File> toCompile = new ArrayList<File>();
        dirtyFilesHolder.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>(){

            public boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor sourceRoot) throws IOException {
                String path = file.getPath();
                if (GroovyBuilder.isGroovyFile(path) && !configuration.isResourceFile(file, sourceRoot.root)) {
                    if (GroovyBuilder.this.myForStubs && settings.isExcludedFromStubGeneration(file)) {
                        return true;
                    }
                    toCompile.add(file);
                }
                return true;
            }
        });
        return toCompile;
    }

    private boolean updateDependencies(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, List<File> toCompile, Map<ModuleBuildTarget, Collection<GroovycOSProcessHandler.OutputItem>> successfullyCompiled, ModuleLevelBuilder.OutputConsumer outputConsumer) throws IOException {
        Mappings delta = context.getProjectDescriptor().dataManager.getMappings().createDelta();
        ArrayList<File> successfullyCompiledFiles = new ArrayList<File>();
        if (!successfullyCompiled.isEmpty()) {
            Callbacks.Backend callback = delta.getCallback();
            for (Map.Entry<ModuleBuildTarget, Collection<GroovycOSProcessHandler.OutputItem>> entry : successfullyCompiled.entrySet()) {
                ModuleBuildTarget target = entry.getKey();
                Collection<GroovycOSProcessHandler.OutputItem> compiled = entry.getValue();
                for (GroovycOSProcessHandler.OutputItem item : compiled) {
                    String sourcePath = FileUtil.toSystemIndependentName((String)item.sourcePath);
                    String outputPath = FileUtil.toSystemIndependentName((String)item.outputPath);
                    File outputFile = new File(outputPath);
                    File srcFile = new File(sourcePath);
                    try {
                        byte[] bytes = FileUtil.loadFileBytes((File)outputFile);
                        outputConsumer.registerCompiledClass((BuildTarget)target, new CompiledClass(outputFile, srcFile, GroovyBuilder.readClassName(bytes), new BinaryContent(bytes)));
                        callback.associate(outputPath, sourcePath, new ClassReader(bytes));
                    }
                    catch (Throwable e) {
                        String message = "Class dependency information may be incomplete! Error parsing generated class " + item.outputPath;
                        LOG.info(message, e);
                        context.processMessage((BuildMessage)new CompilerMessage(this.myBuilderName, BuildMessage.Kind.WARNING, message + "\n" + CompilerMessage.getTextFromThrowable((Throwable)e), sourcePath));
                    }
                    successfullyCompiledFiles.add(srcFile);
                }
            }
        }
        return JavaBuilderUtil.updateMappings((CompileContext)context, (Mappings)delta, dirtyFilesHolder, (ModuleChunk)chunk, toCompile, successfullyCompiledFiles);
    }

    private static String readClassName(byte[] classBytes) throws IOException {
        final Ref nameRef = Ref.create(null);
        new ClassReader(classBytes).accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                nameRef.set((Object)name.replace('/', '.'));
            }
        }, 7);
        return (String)nameRef.get();
    }

    private static Collection<String> generateClasspath(CompileContext context, ModuleChunk chunk) {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        cp.add(GroovyBuilder.getGroovyRtRoot().getPath());
        for (File file : ProjectPaths.getCompilationClasspathFiles((ModuleChunk)chunk, (boolean)chunk.containsTests(), (boolean)false, (boolean)false)) {
            cp.add(FileUtil.toCanonicalPath((String)file.getPath()));
        }
        for (GroovyBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(GroovyBuilderExtension.class)) {
            cp.addAll(extension.getCompilationClassPath(context, chunk));
        }
        return cp;
    }

    private static File getGroovyRtRoot() {
        File root = ClasspathBootstrap.getResourceFile(GroovyBuilder.class);
        if (root.isFile()) {
            return new File(root.getParentFile(), "groovy_rt.jar");
        }
        return new File(root.getParentFile(), "groovy_rt");
    }

    public static boolean isGroovyFile(String path) {
        return path.endsWith(".groovy") || path.endsWith(".gpp");
    }

    public List<String> getCompilableFileExtensions() {
        return Arrays.asList(GROOVY_EXTENSION, GPP_EXTENSION);
    }

    private static Map<String, String> buildClassToSourceMap(ModuleChunk chunk, CompileContext context, Set<String> toCompilePaths, Map<ModuleBuildTarget, String> finalOutputs) throws IOException {
        HashMap<String, String> class2Src = new HashMap<String, String>();
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(context.getProjectDescriptor().getProject());
        for (ModuleBuildTarget target : chunk.getTargets()) {
            String moduleOutputPath = finalOutputs.get(target);
            SourceToOutputMapping srcToOut = context.getProjectDescriptor().dataManager.getSourceToOutputMap((BuildTarget)target);
            for (String src : srcToOut.getSources()) {
                Collection outs;
                if (toCompilePaths.contains(src) || !GroovyBuilder.isGroovyFile(src) || configuration.getCompilerExcludes().isExcluded(new File(src)) || (outs = srcToOut.getOutputs(src)) == null) continue;
                for (String out : outs) {
                    if (!out.endsWith(".class") || !out.startsWith(moduleOutputPath)) continue;
                    String className = out.substring(moduleOutputPath.length(), out.length() - ".class".length()).replace('/', '.');
                    class2Src.put(className, src);
                }
            }
        }
        return class2Src;
    }

    public String toString() {
        return this.myBuilderName;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myBuilderName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyBuilder", "getPresentableName"));
        }
        return string;
    }

    static {
        JavaBuilder.registerClassPostProcessor((ClassPostProcessor)new RecompileStubSources());
    }

    private static class RecompileStubSources
    implements ClassPostProcessor {
        private RecompileStubSources() {
        }

        public void process(CompileContext context, OutputFileObject out) {
            Map stubToSrc = (Map)STUB_TO_SRC.get((UserDataHolder)context);
            if (stubToSrc == null) {
                return;
            }
            File src = out.getSourceFile();
            if (src == null) {
                return;
            }
            String groovy = (String)stubToSrc.get(FileUtil.toSystemIndependentName((String)src.getPath()));
            if (groovy == null) {
                return;
            }
            try {
                File groovyFile = new File(groovy);
                if (!FSOperations.isMarkedDirty((CompileContext)context, (File)groovyFile)) {
                    FSOperations.markDirty((CompileContext)context, (File)groovyFile);
                    FILES_MARKED_DIRTY_FOR_NEXT_ROUND.set((UserDataHolder)context, (Object)Boolean.TRUE);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

