/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;

@com.intellij.openapi.components.State(name="GithubProjectSettings", storages={@Storage(file="$WORKSPACE_FILE$")})
public class GithubProjectSettings
implements PersistentStateComponent<State> {
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static GithubProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubProjectSettings", "getInstance"));
        }
        return (GithubProjectSettings)ServiceManager.getService((Project)project, GithubProjectSettings.class);
    }

    @Nullable
    public String getCreatePullRequestDefaultBranch() {
        return this.myState.CREATE_PULL_REQUEST_DEFAULT_BRANCH;
    }

    public void setCreatePullRequestDefaultBranch(@NotNull String branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubProjectSettings", "setCreatePullRequestDefaultBranch"));
        }
        this.myState.CREATE_PULL_REQUEST_DEFAULT_BRANCH = branch;
    }

    @Nullable
    public GithubFullPath getCreatePullRequestDefaultRepo() {
        if (this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_USER == null || this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_NAME == null) {
            return null;
        }
        return new GithubFullPath(this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_USER, this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_NAME);
    }

    public void setCreatePullRequestDefaultRepo(@NotNull GithubFullPath repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/util/GithubProjectSettings", "setCreatePullRequestDefaultRepo"));
        }
        this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_USER = repo.getUser();
        this.myState.CREATE_PULL_REQUEST_DEFAULT_REPO_NAME = repo.getRepository();
    }

    public static class State {
        @Nullable
        public String CREATE_PULL_REQUEST_DEFAULT_BRANCH = null;
        @Nullable
        public String CREATE_PULL_REQUEST_DEFAULT_REPO_USER = null;
        @Nullable
        public String CREATE_PULL_REQUEST_DEFAULT_REPO_NAME = null;
    }
}

