/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.ui.GithubSelectForkPanel;
import org.jetbrains.plugins.github.util.GithubNotifications;

public class GithubSelectForkDialog
extends DialogWrapper {
    @NotNull
    private final GithubSelectForkPanel myPanel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Convertor<String, GithubFullPath> myCheckFork;
    private GithubFullPath myFullPath;

    public GithubSelectForkDialog(@NotNull Project project, @NotNull Set<GithubFullPath> forks, @NotNull Convertor<String, GithubFullPath> checkFork) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubSelectForkDialog", "<init>"));
        }
        if (forks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/ui/GithubSelectForkDialog", "<init>"));
        }
        if (checkFork == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/ui/GithubSelectForkDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myCheckFork = checkFork;
        this.myPanel = new GithubSelectForkPanel();
        this.myPanel.setUsers(ContainerUtil.map(forks, (Function)new Function<GithubFullPath, String>(){

            public String fun(GithubFullPath path) {
                return path.getUser();
            }
        }));
        this.setTitle("Select Base Fork Repository");
        this.init();
    }

    protected void doOKAction() {
        GithubFullPath path = (GithubFullPath)this.myCheckFork.convert((Object)this.myPanel.getUser());
        if (path == null) {
            GithubNotifications.showErrorDialog(this.myProject, "Can't Find Repository", "Can't find fork for selected user");
        } else {
            this.myFullPath = path;
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @NotNull
    public GithubFullPath getPath() {
        GithubFullPath githubFullPath = this.myFullPath;
        if (githubFullPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSelectForkDialog", "getPath"));
        }
        return githubFullPath;
    }

    public void testSetUser(@NotNull String user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubSelectForkDialog", "testSetUser"));
        }
        this.myPanel.setSelectedUser(user);
    }
}

