/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserDetailed;
import org.jetbrains.plugins.github.ui.GithubLoginPanel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubLoginDialog
extends DialogWrapper {
    protected static final Logger LOG = GithubUtil.LOG;
    protected final GithubLoginPanel myGithubLoginPanel;
    protected final GithubSettings mySettings;
    protected final Project myProject;
    protected GithubAuthData myAuthData;

    public GithubLoginDialog(@NotNull Project project, @NotNull GithubAuthData oldAuthData) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "<init>"));
        }
        if (oldAuthData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myGithubLoginPanel = new GithubLoginPanel(this);
        this.myGithubLoginPanel.setHost(oldAuthData.getHost());
        this.myGithubLoginPanel.setAuthType(oldAuthData.getAuthType());
        GithubAuthData.BasicAuth basicAuth = oldAuthData.getBasicAuth();
        if (basicAuth != null) {
            this.myGithubLoginPanel.setLogin(basicAuth.getLogin());
        }
        this.mySettings = GithubSettings.getInstance();
        if (this.mySettings.isSavePasswordMakesSense()) {
            this.myGithubLoginPanel.setSavePasswordSelected(this.mySettings.isSavePassword());
        } else {
            this.myGithubLoginPanel.setSavePasswordVisibleEnabled(false);
        }
        this.setTitle("Login to GitHub");
        this.setOKButtonText("Login");
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myGithubLoginPanel.getPanel();
    }

    protected String getHelpId() {
        return "login_to_github";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGithubLoginPanel.getPreferableFocusComponent();
    }

    protected void doOKAction() {
        final GithubAuthDataHolder authHolder = new GithubAuthDataHolder(this.myGithubLoginPanel.getAuthData());
        try {
            GithubUtil.computeValueInModal(this.myProject, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubUser, IOException>(){

                @NotNull
                public GithubUser convert(ProgressIndicator indicator) throws IOException {
                    GithubUserDetailed githubUserDetailed = GithubUtil.checkAuthData(GithubLoginDialog.this.myProject, authHolder, indicator);
                    if (githubUserDetailed == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginDialog$1", "convert"));
                    }
                    return githubUserDetailed;
                }
            });
            this.myAuthData = authHolder.getAuthData();
            if (this.mySettings.isSavePasswordMakesSense()) {
                this.mySettings.setSavePassword(this.myGithubLoginPanel.isSavePasswordSelected());
            }
            super.doOKAction();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.setErrorText("Can't login: " + GithubUtil.getErrorTextFromException(e));
        }
    }

    public boolean isSavePasswordSelected() {
        return this.myGithubLoginPanel.isSavePasswordSelected();
    }

    @NotNull
    public GithubAuthData getAuthData() {
        if (this.myAuthData == null) {
            throw new IllegalStateException("AuthData is not set");
        }
        GithubAuthData githubAuthData = this.myAuthData;
        if (githubAuthData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginDialog", "getAuthData"));
        }
        return githubAuthData;
    }

    public void clearErrors() {
        this.setErrorText(null);
    }
}

