/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestPanel;
import org.jetbrains.plugins.github.util.GithubProjectSettings;

public class GithubCreatePullRequestDialog
extends DialogWrapper {
    @NotNull
    private final GithubCreatePullRequestPanel myGithubCreatePullRequestPanel;
    @NotNull
    private final GithubCreatePullRequestWorker myWorker;
    @NotNull
    private final GithubProjectSettings myProjectSettings;

    public GithubCreatePullRequestDialog(@NotNull GithubCreatePullRequestWorker worker) {
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "<init>"));
        }
        super(worker.getProject(), true);
        this.myWorker = worker;
        this.myProjectSettings = GithubProjectSettings.getInstance(this.myWorker.getProject());
        this.myGithubCreatePullRequestPanel = new GithubCreatePullRequestPanel();
        this.myGithubCreatePullRequestPanel.getShowDiffButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GithubCreatePullRequestDialog.this.myWorker.showDiffDialog(GithubCreatePullRequestDialog.this.myGithubCreatePullRequestPanel.getBranch());
            }
        });
        this.myGithubCreatePullRequestPanel.getSelectForkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GithubCreatePullRequestDialog.this.showTargetDialog();
            }
        });
        this.myGithubCreatePullRequestPanel.getBranchComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && GithubCreatePullRequestDialog.this.myWorker.canShowDiff()) {
                    GithubCreatePullRequestDialog.this.myGithubCreatePullRequestPanel.setBusy(true);
                    GithubCreatePullRequestDialog.this.myWorker.getDiffDescriptionInPooledThread(GithubCreatePullRequestDialog.this.getTargetBranch(), new Consumer<GithubCreatePullRequestWorker.DiffDescription>(){

                        public void consume(final GithubCreatePullRequestWorker.DiffDescription info) {
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (info == null) {
                                        GithubCreatePullRequestDialog.this.myGithubCreatePullRequestPanel.setBusy(false);
                                        return;
                                    }
                                    if (GithubCreatePullRequestDialog.this.getTargetBranch().equals(info.getBranch())) {
                                        GithubCreatePullRequestDialog.this.myGithubCreatePullRequestPanel.setBusy(false);
                                        if (GithubCreatePullRequestDialog.this.myGithubCreatePullRequestPanel.isTitleDescriptionEmptyOrNotModified()) {
                                            GithubCreatePullRequestDialog.this.myGithubCreatePullRequestPanel.setTitle(info.getTitle());
                                            GithubCreatePullRequestDialog.this.myGithubCreatePullRequestPanel.setDescription(info.getDescription());
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
        this.setTitle("Create Pull Request - " + this.myWorker.getCurrentBranch());
        this.init();
    }

    public void show() {
        GithubFullPath defaultForkPath = this.myProjectSettings.getCreatePullRequestDefaultRepo();
        if (defaultForkPath != null) {
            this.setTarget(defaultForkPath);
        } else if (!this.showTargetDialog(true)) {
            this.close(1);
            return;
        }
        super.show();
    }

    private boolean showTargetDialog() {
        return this.showTargetDialog(false);
    }

    private boolean showTargetDialog(boolean firstTime) {
        GithubFullPath forkPath = this.myWorker.showTargetDialog(firstTime);
        if (forkPath == null) {
            return false;
        }
        return this.setTarget(forkPath);
    }

    private boolean setTarget(@NotNull GithubFullPath forkPath) {
        if (forkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "setTarget"));
        }
        GithubCreatePullRequestWorker.GithubTargetInfo forkInfo = this.myWorker.setTarget(forkPath);
        if (forkInfo == null) {
            return false;
        }
        this.myProjectSettings.setCreatePullRequestDefaultRepo(forkPath);
        this.myGithubCreatePullRequestPanel.setDiffEnabled(this.myWorker.canShowDiff());
        this.updateBranches(forkInfo.getBranches(), forkPath);
        return true;
    }

    private void updateBranches(@NotNull Collection<String> branches, @NotNull GithubFullPath forkPath) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "updateBranches"));
        }
        if (forkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "updateBranches"));
        }
        this.myGithubCreatePullRequestPanel.setBranches(branches);
        String configBranch = this.myProjectSettings.getCreatePullRequestDefaultBranch();
        if (configBranch != null) {
            this.myGithubCreatePullRequestPanel.setSelectedBranch(configBranch);
        }
        this.myGithubCreatePullRequestPanel.setForkName(forkPath.getFullName());
    }

    protected void doOKAction() {
        if (this.myWorker.checkAction(this.getTargetBranch())) {
            this.myProjectSettings.setCreatePullRequestDefaultBranch(this.getTargetBranch());
            this.myWorker.performAction(this.getRequestTitle(), this.getDescription(), this.getTargetBranch());
            super.doOKAction();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myGithubCreatePullRequestPanel.getPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myGithubCreatePullRequestPanel.getPreferredComponent();
    }

    protected String getHelpId() {
        return "github.create.pull.request.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreatePullRequestDialog";
    }

    @NotNull
    private String getRequestTitle() {
        String string = this.myGithubCreatePullRequestPanel.getTitle();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "getRequestTitle"));
        }
        return string;
    }

    @NotNull
    private String getDescription() {
        String string = this.myGithubCreatePullRequestPanel.getDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "getDescription"));
        }
        return string;
    }

    @NotNull
    private String getTargetBranch() {
        String string = this.myGithubCreatePullRequestPanel.getBranch();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "getTargetBranch"));
        }
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmptyOrSpaces((String)this.getRequestTitle())) {
            return new ValidationInfo("Title can't be empty'", this.myGithubCreatePullRequestPanel.getTitleTextField());
        }
        return null;
    }

    public void testSetRequestTitle(String title) {
        this.myGithubCreatePullRequestPanel.setTitle(title);
    }

    public void testSetBranch(String branch) {
        this.myGithubCreatePullRequestPanel.setBranches(Collections.singleton(branch));
    }

    public void testCreatePullRequest() {
        this.myWorker.performAction(this.getRequestTitle(), this.getDescription(), this.getTargetBranch());
    }

    public void testSetTarget(@NotNull GithubFullPath forkPath) {
        if (forkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestDialog", "testSetTarget"));
        }
        GithubCreatePullRequestWorker.GithubTargetInfo forkInfo = this.myWorker.setTarget(forkPath);
        if (forkInfo == null) {
            this.doCancelAction();
            return;
        }
        this.myGithubCreatePullRequestPanel.setDiffEnabled(this.myWorker.canShowDiff());
    }
}

