/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubFullPath {
    @NotNull
    private final String myUserName;
    @NotNull
    private final String myRepositoryName;

    public GithubFullPath(@NotNull String userName, @NotNull String repositoryName) {
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubFullPath", "<init>"));
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubFullPath", "<init>"));
        }
        this.myUserName = userName;
        this.myRepositoryName = repositoryName;
    }

    @NotNull
    public String getUser() {
        String string = this.myUserName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubFullPath", "getUser"));
        }
        return string;
    }

    @NotNull
    public String getRepository() {
        String string = this.myRepositoryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubFullPath", "getRepository"));
        }
        return string;
    }

    @NotNull
    public String getFullName() {
        String string = this.myUserName + '/' + this.myRepositoryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubFullPath", "getFullName"));
        }
        return string;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GithubFullPath that = (GithubFullPath)o;
        if (!this.myRepositoryName.equals(that.myRepositoryName)) {
            return false;
        }
        return this.myUserName.equals(that.myUserName);
    }

    public int hashCode() {
        int result = this.myUserName.hashCode();
        result = 31 * result + this.myRepositoryName.hashCode();
        return result;
    }
}

