/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsShortCommitDetails;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubShowCommitInBrowserAction;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShowCommitInBrowserFromLogAction
extends GithubShowCommitInBrowserAction {
    public void update(AnActionEvent e) {
        EventData eventData = GithubShowCommitInBrowserFromLogAction.collectData(e);
        e.getPresentation().setVisible(eventData != null && GithubUtil.isRepositoryOnGitHub(eventData.getRepository()));
        e.getPresentation().setEnabled(eventData != null);
    }

    @Nullable
    private static EventData collectData(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return null;
        }
        VcsShortCommitDetails commit = GithubShowCommitInBrowserFromLogAction.getCurrentlySelectedCommitInTheLog(e);
        if (commit == null) {
            return null;
        }
        VirtualFile root = commit.getRoot();
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(root);
        if (repository == null) {
            return null;
        }
        return new EventData(project, repository, commit);
    }

    @Nullable
    private static VcsShortCommitDetails getCurrentlySelectedCommitInTheLog(AnActionEvent e) {
        GitHeavyCommit heavyCommit = (GitHeavyCommit)e.getData(GitVcs.GIT_COMMIT);
        if (heavyCommit != null) {
            final VcsLogObjectsFactory factory = (VcsLogObjectsFactory)ServiceManager.getService((Project)e.getProject(), VcsLogObjectsFactory.class);
            List parents = ContainerUtil.map((Collection)heavyCommit.getParentsHashes(), (Function)new Function<String, Hash>(){

                public Hash fun(String s) {
                    return factory.createHash(s);
                }
            });
            return factory.createShortDetails(factory.createHash(heavyCommit.getHash().getValue()), parents, heavyCommit.getAuthorTime(), heavyCommit.getRoot(), heavyCommit.getSubject(), heavyCommit.getAuthor(), heavyCommit.getAuthorEmail());
        }
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VSC_LOG);
        if (log == null) {
            return null;
        }
        List selectedCommits = log.getSelectedCommits();
        if (selectedCommits.size() == 1) {
            return log.getDetailsIfAvailable((Hash)selectedCommits.get(0));
        }
        return null;
    }

    public void actionPerformed(AnActionEvent e) {
        EventData eventData = GithubShowCommitInBrowserFromLogAction.collectData(e);
        if (eventData != null) {
            GithubShowCommitInBrowserFromLogAction.openInBrowser(eventData.getProject(), eventData.getRepository(), eventData.getCommit().getHash().asString());
        }
    }

    private static class EventData {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRepository myRepository;
        @NotNull
        private final VcsShortCommitDetails myCommit;

        private EventData(@NotNull Project project, @NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction$EventData", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction$EventData", "<init>"));
            }
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction$EventData", "<init>"));
            }
            this.myProject = project;
            this.myRepository = repository;
            this.myCommit = commit;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction$EventData", "getProject"));
            }
            return project;
        }

        @NotNull
        public GitRepository getRepository() {
            GitRepository gitRepository = this.myRepository;
            if (gitRepository == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction$EventData", "getRepository"));
            }
            return gitRepository;
        }

        @NotNull
        public VcsShortCommitDetails getCommit() {
            VcsShortCommitDetails vcsShortCommitDetails = this.myCommit;
            if (vcsShortCommitDetails == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromLogAction$EventData", "getCommit"));
            }
            return vcsShortCommitDetails;
        }
    }
}

