/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDialog;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.util.GitCommitCompareInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubBranch;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubPullRequest;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubRepoDetailed;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.ui.GithubSelectForkDialog;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreatePullRequestWorker {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_CREATE_PULL_REQUEST = "Can't Create Pull Request";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepository myGitRepository;
    @NotNull
    private final GithubFullPath myPath;
    @NotNull
    private final String myRemoteName;
    @NotNull
    private final String myRemoteUrl;
    @NotNull
    private final String myCurrentBranch;
    @NotNull
    private final GithubAuthDataHolder myAuthHolder;
    @NotNull
    private final Map<String, FutureTask<DiffInfo>> myDiffInfos;
    private volatile GithubFullPath myForkPath;
    private volatile String myTargetRemote;

    private GithubCreatePullRequestWorker(@NotNull Project project, @NotNull Git git, @NotNull GitRepository gitRepository, @NotNull GithubFullPath path, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String currentBranch, @NotNull GithubAuthDataHolder authHolder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myGitRepository = gitRepository;
        this.myPath = path;
        this.myRemoteName = remoteName;
        this.myRemoteUrl = remoteUrl;
        this.myCurrentBranch = currentBranch;
        this.myAuthHolder = authHolder;
        this.myDiffInfos = new HashMap();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getCurrentBranch() {
        String string = this.myCurrentBranch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getCurrentBranch"));
        }
        return string;
    }

    public boolean canShowDiff() {
        return this.myTargetRemote != null;
    }

    @Nullable
    public static GithubCreatePullRequestWorker createPullRequestWorker(final @NotNull Project project, @Nullable VirtualFile file) {
        GithubAuthDataHolder authHolder;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequestWorker"));
        }
        Git git = (Git)ServiceManager.getService(Git.class);
        GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
        if (gitRepository == null) {
            GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "Can't find git repository");
            return null;
        }
        gitRepository.update();
        Pair<GitRemote, String> remote = GithubUtil.findGithubRemote(gitRepository);
        if (remote == null) {
            GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "Can't find GitHub remote");
            return null;
        }
        String remoteName = ((GitRemote)remote.getFirst()).getName();
        String remoteUrl = (String)remote.getSecond();
        GithubFullPath path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (path == null) {
            GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "Can't process remote: " + remoteUrl);
            return null;
        }
        GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
        if (currentBranch == null) {
            GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, "No current branch");
            return null;
        }
        try {
            authHolder = GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubAuthDataHolder, IOException>(){

                @NotNull
                public GithubAuthDataHolder convert(ProgressIndicator indicator) throws IOException {
                    GithubAuthDataHolder githubAuthDataHolder = GithubUtil.getValidAuthDataHolderFromConfig(project, indicator);
                    if (githubAuthDataHolder == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$1", "convert"));
                    }
                    return githubAuthDataHolder;
                }
            });
        }
        catch (GithubOperationCanceledException e) {
            return null;
        }
        catch (IOException e) {
            GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, e);
            return null;
        }
        return new GithubCreatePullRequestWorker(project, git, gitRepository, path, remoteName, remoteUrl, currentBranch.getName(), authHolder);
    }

    @Nullable
    public GithubTargetInfo setTarget(final @NotNull GithubFullPath forkPath) {
        if (forkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "setTarget"));
        }
        try {
            GithubInfo info = GithubUtil.computeValueInModal(this.myProject, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubInfo, IOException>(){

                @NotNull
                public GithubInfo convert(ProgressIndicator indicator) throws IOException {
                    GitFetchResult result;
                    String targetRemoteName;
                    GitRemote targetRemote = GithubUtil.findGithubRemote(GithubCreatePullRequestWorker.this.myGitRepository, forkPath);
                    String string = targetRemoteName = targetRemote == null ? null : targetRemote.getName();
                    if (targetRemoteName == null) {
                        final Ref responseRef = new Ref();
                        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                responseRef.set((Object)GithubNotifications.showYesNoDialog(GithubCreatePullRequestWorker.this.myProject, "Can't Find Remote", "Configure remote for '" + forkPath.getUser() + "'?"));
                            }
                        }, indicator.getModalityState());
                        if ((Integer)responseRef.get() == 0) {
                            targetRemoteName = GithubCreatePullRequestWorker.configureRemote(GithubCreatePullRequestWorker.this.myProject, GithubCreatePullRequestWorker.this.myGitRepository, forkPath);
                        }
                    }
                    List branches = ContainerUtil.map((Collection)GithubUtil.runTask(GithubCreatePullRequestWorker.this.myProject, GithubCreatePullRequestWorker.this.myAuthHolder, indicator, new ThrowableConvertor<GithubAuthData, List<GithubBranch>, IOException>(){

                        public List<GithubBranch> convert(@NotNull GithubAuthData auth) throws IOException {
                            if (auth == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$2$2", "convert"));
                            }
                            return GithubApiUtil.getRepoBranches(auth, forkPath.getUser(), forkPath.getRepository());
                        }
                    }), (Function)new Function<GithubBranch, String>(){

                        public String fun(GithubBranch githubBranch) {
                            return githubBranch.getName();
                        }
                    });
                    if (targetRemoteName != null && !(result = new GitFetcher(GithubCreatePullRequestWorker.this.myProject, indicator, false).fetch(GithubCreatePullRequestWorker.this.myGitRepository.getRoot(), targetRemoteName, null)).isSuccess()) {
                        GitFetcher.displayFetchResult((Project)GithubCreatePullRequestWorker.this.myProject, (GitFetchResult)result, null, (Collection)result.getErrors());
                        targetRemoteName = null;
                    }
                    GithubInfo githubInfo = new GithubInfo(branches, targetRemoteName);
                    if (githubInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$2", "convert"));
                    }
                    return githubInfo;
                }
            });
            this.myForkPath = forkPath;
            this.myTargetRemote = info.getTargetRemote();
            this.myDiffInfos.clear();
            if (this.canShowDiff()) {
                for (final String branch : info.getBranches()) {
                    this.myDiffInfos.put(branch, new FutureTask<DiffInfo>(new Callable<DiffInfo>(){

                        @Override
                        @Nullable
                        public DiffInfo call() throws Exception {
                            return GithubCreatePullRequestWorker.loadDiffInfo(GithubCreatePullRequestWorker.this.myProject, GithubCreatePullRequestWorker.this.myGitRepository, GithubCreatePullRequestWorker.this.myCurrentBranch, GithubCreatePullRequestWorker.this.myTargetRemote + "/" + branch);
                        }
                    }));
                }
            }
            return new GithubTargetInfo(info.getBranches());
        }
        catch (GithubOperationCanceledException e) {
            return null;
        }
        catch (IOException e) {
            GithubNotifications.showErrorDialog(this.myProject, CANNOT_CREATE_PULL_REQUEST, (Exception)e);
            return null;
        }
    }

    public void showDiffDialog(@NotNull String branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "showDiffDialog"));
        }
        if (this.canShowDiff()) {
            DiffInfo info = this.getDiffInfoWithModal(branch);
            if (info == null) {
                GithubNotifications.showErrorDialog(this.myProject, "Can't Show Diff", "Can't get diff info");
                return;
            }
            GitCompareBranchesDialog dialog = new GitCompareBranchesDialog(this.myProject, info.getTo(), info.getFrom(), info.getInfo(), this.myGitRepository);
            dialog.show();
        }
    }

    @Nullable
    public GithubFullPath showTargetDialog() {
        return this.showTargetDialog(false);
    }

    @Nullable
    public GithubFullPath showTargetDialog(boolean firstTime) {
        final GithubInfo2 info = GithubCreatePullRequestWorker.getAvailableForksInModal(this.myProject, this.myGitRepository, this.myAuthHolder, this.myPath);
        if (info == null) {
            return null;
        }
        if (firstTime) {
            if (info.getForks().size() == 1) {
                return info.getForks().iterator().next();
            }
            if (info.getForks().size() == 2) {
                Iterator<GithubFullPath> it = info.getForks().iterator();
                GithubFullPath path1 = it.next();
                GithubFullPath path2 = it.next();
                if (this.myPath.equals(path1)) {
                    return path2;
                }
                if (this.myPath.equals(path2)) {
                    return path1;
                }
            }
        }
        Convertor<String, GithubFullPath> getForkPath = new Convertor<String, GithubFullPath>(){

            @Nullable
            public GithubFullPath convert(final @NotNull String user) {
                if (user == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$4", "convert"));
                }
                return GithubUtil.computeValueInModal(GithubCreatePullRequestWorker.this.myProject, "Access to GitHub", new Convertor<ProgressIndicator, GithubFullPath>(){

                    @Nullable
                    public GithubFullPath convert(ProgressIndicator indicator) {
                        return GithubCreatePullRequestWorker.findRepositoryByUser(GithubCreatePullRequestWorker.this.myProject, GithubCreatePullRequestWorker.this.myAuthHolder, indicator, user, info.getForks(), info.getSource());
                    }
                });
            }
        };
        GithubSelectForkDialog dialog = new GithubSelectForkDialog(this.myProject, info.getForks(), getForkPath);
        DialogManager.show((DialogWrapper)dialog);
        if (!dialog.isOK()) {
            return null;
        }
        return dialog.getPath();
    }

    public boolean checkAction(@NotNull String targetBranch) {
        if (targetBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "checkAction"));
        }
        DiffInfo info = this.getDiffInfoWithModal(targetBranch);
        if (info == null) {
            return true;
        }
        if (info.getInfo().getBranchToHeadCommits(this.myGitRepository).isEmpty()) {
            GithubNotifications.showWarningDialog(this.myProject, CANNOT_CREATE_PULL_REQUEST, "Can't create empty pull request: the branch" + this.getCurrentBranch() + " in fully merged to the branch " + targetBranch + ".");
            return false;
        }
        if (info.getInfo().getHeadToBranchCommits(this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, "The branch" + targetBranch + " in not fully merged to the branch " + this.getCurrentBranch(), "Do you want to proceed anyway?") == 0;
        }
        return true;
    }

    public void performAction(final @NotNull String title, final @NotNull String description, final @NotNull String targetBranch) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "performAction"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "performAction"));
        }
        if (targetBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "performAction"));
        }
        final Project project = this.myProject;
        new Task.Backgroundable(this.myProject, "Creating pull request..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$5", "run"));
                }
                LOG.info("Pushing current branch");
                indicator.setText("Pushing current branch...");
                GitCommandResult result = GithubCreatePullRequestWorker.this.myGit.push(GithubCreatePullRequestWorker.this.myGitRepository, GithubCreatePullRequestWorker.this.myRemoteName, GithubCreatePullRequestWorker.this.myRemoteUrl, GithubCreatePullRequestWorker.this.myCurrentBranch, true, new GitLineHandlerListener[0]);
                if (!result.success()) {
                    GithubNotifications.showError(project, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "Push failed:<br/>" + result.getErrorOutputAsHtmlString());
                    return;
                }
                String headBranch = GithubCreatePullRequestWorker.this.myPath.getUser() + ":" + GithubCreatePullRequestWorker.this.myCurrentBranch;
                LOG.info("Creating pull request");
                indicator.setText("Creating pull request...");
                GithubPullRequest request = GithubCreatePullRequestWorker.createPullRequest(project, GithubCreatePullRequestWorker.this.myAuthHolder, indicator, GithubCreatePullRequestWorker.this.myForkPath, title, description, headBranch, targetBranch);
                if (request == null) {
                    return;
                }
                GithubNotifications.showInfoURL(project, "Successfully created pull request", "Pull request #" + request.getNumber(), request.getHtmlUrl());
            }
        }.queue();
    }

    @Nullable
    private static String configureRemote(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull GithubFullPath forkPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "configureRemote"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "configureRemote"));
        }
        if (forkPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "configureRemote"));
        }
        String url = GithubUrlUtil.getCloneUrl(forkPath);
        if (GithubUtil.addGithubRemote(project, gitRepository, forkPath.getUser(), url)) {
            return forkPath.getUser();
        }
        return null;
    }

    @Nullable
    private static GithubPullRequest createPullRequest(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, final @NotNull GithubFullPath targetRepo, final @NotNull String title, final @NotNull String description, final @NotNull String head, final @NotNull String base) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (targetRepo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (head == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        try {
            return GithubUtil.runTask(project, authHolder, indicator, new ThrowableConvertor<GithubAuthData, GithubPullRequest, IOException>(){

                @NotNull
                public GithubPullRequest convert(@NotNull GithubAuthData auth) throws IOException {
                    if (auth == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$6", "convert"));
                    }
                    GithubPullRequest githubPullRequest = GithubApiUtil.createPullRequest(auth, targetRepo.getUser(), targetRepo.getRepository(), title, description, head, base);
                    if (githubPullRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$6", "convert"));
                    }
                    return githubPullRequest;
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, e);
            return null;
        }
    }

    @Nullable
    private DiffInfo getDiffInfo(@NotNull String branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDiffInfo"));
        }
        try {
            FutureTask<DiffInfo> future = this.myDiffInfos.get(branch);
            if (future == null) {
                return null;
            }
            future.run();
            return future.get();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private DiffInfo getDiffInfoWithModal(final @NotNull String branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDiffInfoWithModal"));
        }
        return GithubUtil.computeValueInModal(this.myProject, "Collecting diff data...", new Convertor<ProgressIndicator, DiffInfo>(){

            @Nullable
            public DiffInfo convert(ProgressIndicator indicator) {
                return GithubCreatePullRequestWorker.this.getDiffInfo(branch);
            }
        });
    }

    public void getDiffDescriptionInPooledThread(final @NotNull String branch, final @NotNull Consumer<DiffDescription> after) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDiffDescriptionInPooledThread"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDiffDescriptionInPooledThread"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                after.consume((Object)GithubCreatePullRequestWorker.getDefaultDescriptionMessage(branch, GithubCreatePullRequestWorker.this.getDiffInfo(branch), GithubCreatePullRequestWorker.this.myGitRepository));
            }
        });
    }

    @Nullable
    private static DiffInfo loadDiffInfo(@NotNull Project project, @NotNull GitRepository repository, @NotNull String currentBranch, @NotNull String targetBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "loadDiffInfo"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "loadDiffInfo"));
        }
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "loadDiffInfo"));
        }
        if (targetBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "loadDiffInfo"));
        }
        try {
            List commits1 = GitHistoryUtils.history((Project)project, (VirtualFile)repository.getRoot(), (String[])new String[]{".." + targetBranch});
            List commits2 = GitHistoryUtils.history((Project)project, (VirtualFile)repository.getRoot(), (String[])new String[]{targetBranch + ".."});
            Collection diff = GitChangeUtils.getDiff((Project)repository.getProject(), (VirtualFile)repository.getRoot(), (String)targetBranch, (String)currentBranch, null);
            GitCommitCompareInfo info = new GitCommitCompareInfo(GitCommitCompareInfo.InfoType.BRANCH_TO_HEAD);
            info.put(repository, diff);
            info.put(repository, Pair.create((Object)commits1, (Object)commits2));
            return new DiffInfo(info, currentBranch, targetBranch);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static DiffDescription getDefaultDescriptionMessage(@NotNull String branch, @Nullable DiffInfo info, @NotNull GitRepository gitRepository) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
        }
        if (info == null) {
            DiffDescription diffDescription = new DiffDescription(branch, null, null);
            if (diffDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
            }
            return diffDescription;
        }
        if (info.getInfo().getBranchToHeadCommits(gitRepository).size() != 1) {
            DiffDescription diffDescription = new DiffDescription(branch, info.getFrom(), null);
            if (diffDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
            }
            return diffDescription;
        }
        GitCommit commit = (GitCommit)info.getInfo().getBranchToHeadCommits(gitRepository).get(0);
        DiffDescription diffDescription = new DiffDescription(branch, commit.getSubject(), commit.getFullMessage());
        if (diffDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
        }
        return diffDescription;
    }

    @Nullable
    private static GithubInfo2 getAvailableForksInModal(final @NotNull Project project, final @NotNull GitRepository gitRepository, final @NotNull GithubAuthDataHolder authHolder, final @NotNull GithubFullPath path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getAvailableForksInModal"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getAvailableForksInModal"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getAvailableForksInModal"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getAvailableForksInModal"));
        }
        try {
            return GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubInfo2, IOException>(){

                @NotNull
                public GithubInfo2 convert(ProgressIndicator indicator) throws IOException {
                    HashSet<GithubFullPath> forks = new HashSet<GithubFullPath>();
                    GithubRepoDetailed repo = GithubUtil.runTask(project, authHolder, indicator, new ThrowableConvertor<GithubAuthData, GithubRepoDetailed, IOException>(){

                        @NotNull
                        public GithubRepoDetailed convert(@NotNull GithubAuthData auth) throws IOException {
                            if (auth == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$9$1", "convert"));
                            }
                            GithubRepoDetailed githubRepoDetailed = GithubApiUtil.getDetailedRepoInfo(auth, path.getUser(), path.getRepository());
                            if (githubRepoDetailed == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$9$1", "convert"));
                            }
                            return githubRepoDetailed;
                        }
                    });
                    forks.add(path);
                    if (repo.getParent() != null) {
                        forks.add(repo.getParent().getFullPath());
                    }
                    if (repo.getSource() != null) {
                        forks.add(repo.getSource().getFullPath());
                    }
                    forks.addAll(GithubCreatePullRequestWorker.getAvailableForksFromGit(gitRepository));
                    GithubRepo forkTreeRoot = repo.getSource() == null ? repo : repo.getSource();
                    GithubInfo2 githubInfo2 = new GithubInfo2(forks, forkTreeRoot);
                    if (githubInfo2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$9", "convert"));
                    }
                    return githubInfo2;
                }
            });
        }
        catch (GithubOperationCanceledException e) {
            return null;
        }
        catch (IOException e) {
            GithubNotifications.showErrorDialog(project, CANNOT_CREATE_PULL_REQUEST, (Exception)e);
            return null;
        }
    }

    @NotNull
    private static List<GithubFullPath> getAvailableForksFromGit(@NotNull GitRepository gitRepository) {
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getAvailableForksFromGit"));
        }
        ArrayList<GithubFullPath> forks = new ArrayList<GithubFullPath>();
        block0: for (GitRemoteBranch remoteBranch : gitRepository.getBranches().getRemoteBranches()) {
            for (String url : remoteBranch.getRemote().getUrls()) {
                GithubFullPath path;
                if (!GithubUrlUtil.isGithubUrl(url) || (path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url)) == null) continue;
                forks.add(path);
                continue block0;
            }
        }
        ArrayList<GithubFullPath> arrayList = forks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getAvailableForksFromGit"));
        }
        return arrayList;
    }

    @Nullable
    private static GithubFullPath findRepositoryByUser(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, final @NotNull String user, @NotNull Set<GithubFullPath> forks, final @NotNull GithubRepo source) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        if (forks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        for (GithubFullPath path : forks) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)user, (CharSequence)path.getUser())) continue;
            return path;
        }
        try {
            return GithubUtil.runTask(project, authHolder, indicator, new ThrowableConvertor<GithubAuthData, GithubFullPath, IOException>(){

                @Nullable
                public GithubFullPath convert(@NotNull GithubAuthData auth) throws IOException {
                    if (auth == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$10", "convert"));
                    }
                    try {
                        GithubRepoDetailed target = GithubApiUtil.getDetailedRepoInfo(auth, user, source.getName());
                        if (target.getSource() != null && StringUtil.equals((CharSequence)target.getSource().getUserName(), (CharSequence)source.getUserName())) {
                            return target.getFullPath();
                        }
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    GithubRepo fork = GithubApiUtil.findForkByUser(auth, source.getUserName(), source.getName(), user);
                    if (fork != null) {
                        return fork.getFullPath();
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, CANNOT_CREATE_PULL_REQUEST, e);
            return null;
        }
    }

    public static class DiffDescription {
        @NotNull
        private final String myBranch;
        @Nullable
        private final String myTitle;
        @Nullable
        private final String myDescription;

        public DiffDescription(@NotNull String branch, @Nullable String title, @Nullable String description) {
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffDescription", "<init>"));
            }
            this.myBranch = branch;
            this.myTitle = title;
            this.myDescription = description;
        }

        @NotNull
        public String getBranch() {
            String string = this.myBranch;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffDescription", "getBranch"));
            }
            return string;
        }

        @Nullable
        public String getTitle() {
            return this.myTitle;
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }
    }

    private static class DiffInfo {
        @NotNull
        private final GitCommitCompareInfo myInfo;
        @NotNull
        private final String myFrom;
        @NotNull
        private final String myTo;

        private DiffInfo(@NotNull GitCommitCompareInfo info, @NotNull String from, @NotNull String to) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "<init>"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "<init>"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "<init>"));
            }
            this.myInfo = info;
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public GitCommitCompareInfo getInfo() {
            GitCommitCompareInfo gitCommitCompareInfo = this.myInfo;
            if (gitCommitCompareInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "getInfo"));
            }
            return gitCommitCompareInfo;
        }

        @NotNull
        public String getFrom() {
            String string = this.myFrom;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "getFrom"));
            }
            return string;
        }

        @NotNull
        public String getTo() {
            String string = this.myTo;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "getTo"));
            }
            return string;
        }
    }

    public static class GithubTargetInfo {
        @NotNull
        private final List<String> myBranches;

        private GithubTargetInfo(@NotNull List<String> branches) {
            if (branches == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubTargetInfo", "<init>"));
            }
            this.myBranches = branches;
        }

        @NotNull
        public List<String> getBranches() {
            List<String> list = this.myBranches;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubTargetInfo", "getBranches"));
            }
            return list;
        }
    }

    private static class GithubInfo2 {
        @NotNull
        private final Set<GithubFullPath> myForks;
        @NotNull
        private final GithubRepo mySource;

        private GithubInfo2(@NotNull Set<GithubFullPath> forks, @NotNull GithubRepo source) {
            if (forks == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubInfo2", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubInfo2", "<init>"));
            }
            this.myForks = forks;
            this.mySource = source;
        }

        @NotNull
        public Set<GithubFullPath> getForks() {
            Set<GithubFullPath> set = this.myForks;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubInfo2", "getForks"));
            }
            return set;
        }

        @NotNull
        public GithubRepo getSource() {
            GithubRepo githubRepo = this.mySource;
            if (githubRepo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubInfo2", "getSource"));
            }
            return githubRepo;
        }
    }

    private static class GithubInfo {
        @NotNull
        private final List<String> myBranches;
        @Nullable
        private final String myTargetRemote;

        private GithubInfo(@NotNull List<String> repo, @Nullable String targetRemote) {
            if (repo == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubInfo", "<init>"));
            }
            this.myBranches = repo;
            this.myTargetRemote = targetRemote;
        }

        @NotNull
        public List<String> getBranches() {
            List<String> list = this.myBranches;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$GithubInfo", "getBranches"));
            }
            return list;
        }

        @Nullable
        public String getTargetRemote() {
            return this.myTargetRemote;
        }
    }
}

