/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import com.intellij.tasks.trello.model.TrelloLabel;
import com.intellij.tasks.trello.model.TrelloList;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class TrelloUtil {
    public static final Pattern TRELLO_ID_PATTERN = Pattern.compile("[a-z0-9]{24}");
    public static final Gson GSON = TrelloUtil.buildGson();
    public static final String TRELLO_API_BASE_URL = "https://api.trello.com/1";
    public static final Type LIST_OF_CARDS_TYPE = new TypeToken<List<TrelloCard>>(){}.getType();
    public static final Type LIST_OF_BOARDS_TYPE = new TypeToken<List<TrelloBoard>>(){}.getType();
    public static final Type LIST_OF_LISTS_TYPE = new TypeToken<List<TrelloList>>(){}.getType();
    public static final Type LIST_OF_COMMENTS_TYPE = new TypeToken<List<TrelloCommentAction>>(){}.getType();

    private static Gson buildGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        gson.registerTypeAdapter(TrelloLabel.LabelColor.class, (Object)new LabelColorDeserializer());
        return gson.create();
    }

    private static class LabelColorDeserializer
    implements JsonDeserializer<TrelloLabel.LabelColor> {
        private LabelColorDeserializer() {
        }

        public TrelloLabel.LabelColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TrelloLabel.LabelColor.valueOf(json.getAsString().toUpperCase());
        }
    }

    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private static final DateFormat ISO8601_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS'Z'");

        private DateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String dateString = json.getAsString();
            try {
                return ISO8601_DATETIME_FORMAT.parse(dateString);
            }
            catch (ParseException e) {
                throw new JsonParseException("Error parsing date: " + dateString, (Throwable)e);
            }
        }

        static {
            ISO8601_DATETIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }
}

