/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.google.gson.JsonParseException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.trello.TrelloTask;
import com.intellij.tasks.trello.TrelloUtil;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloList;
import com.intellij.tasks.trello.model.TrelloUser;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Trello")
public final class TrelloRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.trello.TrelloRepository");
    private TrelloUser myCurrentUser;
    private TrelloBoard myCurrentBoard;
    private TrelloList myCurrentList;

    public TrelloRepository() {
    }

    public TrelloRepository(TaskRepositoryType type) {
        super(type);
    }

    public TrelloRepository(TrelloRepository other) {
        super((BaseRepositoryImpl)other);
        this.myCurrentUser = other.myCurrentUser;
        this.myCurrentBoard = other.myCurrentBoard;
        this.myCurrentList = other.myCurrentList;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TrelloRepository repository = (TrelloRepository)((Object)o);
        if (!Comparing.equal((Object)this.myCurrentUser, (Object)repository.myCurrentUser)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myCurrentBoard, (Object)repository.myCurrentBoard)) {
            return false;
        }
        return Comparing.equal((Object)this.myCurrentList, (Object)repository.myCurrentList);
    }

    public BaseRepository clone() {
        return new TrelloRepository(this);
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        List<TrelloCard> cards = this.fetchCards();
        return (Task[])ContainerUtil.map2Array(cards, Task.class, (Function)new Function<TrelloCard, Task>(){

            public Task fun(TrelloCard card) {
                return new TrelloTask(card, (TaskRepository)TrelloRepository.this);
            }
        });
    }

    @Nullable
    public Task findTask(String id) throws Exception {
        String url = "https://api.trello.com/1/cards/" + id + "?actions=commentCard";
        try {
            return new TrelloTask(this.makeRequestAndDeserializeJsonResponse(url, TrelloCard.class), (TaskRepository)this);
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nullable
    public TrelloUser getCurrentUser() {
        return this.myCurrentUser;
    }

    public void setCurrentUser(TrelloUser currentUser) {
        this.myCurrentUser = currentUser;
    }

    @Nullable
    public TrelloBoard getCurrentBoard() {
        return this.myCurrentBoard;
    }

    public void setCurrentBoard(TrelloBoard currentBoard) {
        this.myCurrentBoard = currentBoard;
    }

    @Nullable
    public TrelloList getCurrentList() {
        return this.myCurrentList;
    }

    public void setCurrentList(TrelloList currentList) {
        this.myCurrentList = currentList;
    }

    protected void configureHttpMethod(HttpMethod method) {
        if (StringUtil.isEmpty((String)this.myPassword)) {
            return;
        }
        String params = EncodingUtil.formUrlEncode((NameValuePair[])new NameValuePair[]{new NameValuePair("token", this.myPassword), new NameValuePair("key", "d6ec3709f7141007e150de64d4701181")}, (String)"utf-8");
        String oldParams = method.getQueryString();
        method.setQueryString(StringUtil.isEmpty((String)oldParams) ? params : oldParams + "&" + params);
    }

    @Nullable
    public String extractId(String taskName) {
        return TrelloUtil.TRELLO_ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    @NotNull
    public TrelloUser fetchUserByToken() throws Exception {
        TrelloUser trelloUser;
        try {
            String url = "https://api.trello.com/1/members/me";
            trelloUser = this.makeRequestAndDeserializeJsonResponse(url, TrelloUser.class);
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial user info", (Throwable)e);
            this.myCurrentBoard = null;
            this.myCurrentList = null;
            throw e;
        }
        if (trelloUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchUserByToken"));
        }
        return trelloUser;
    }

    @NotNull
    public TrelloBoard fetchBoardById(@NotNull String id) throws Exception {
        TrelloBoard trelloBoard;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/trello/TrelloRepository", "fetchBoardById"));
        }
        String url = "https://api.trello.com/1/boards/" + id;
        try {
            trelloBoard = this.makeRequestAndDeserializeJsonResponse(url, TrelloBoard.class);
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial board info", (Throwable)e);
            throw e;
        }
        if (trelloBoard == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchBoardById"));
        }
        return trelloBoard;
    }

    @NotNull
    public TrelloList fetchListById(@NotNull String id) throws Exception {
        TrelloList trelloList;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/trello/TrelloRepository", "fetchListById"));
        }
        String url = "https://api.trello.com/1/lists/" + id;
        try {
            trelloList = this.makeRequestAndDeserializeJsonResponse(url, TrelloList.class);
        }
        catch (Exception e) {
            LOG.warn("Error while fetching initial list info" + id, (Throwable)e);
            throw e;
        }
        if (trelloList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchListById"));
        }
        return trelloList;
    }

    @NotNull
    public List<TrelloList> fetchBoardLists() throws Exception {
        if (this.myCurrentBoard == null) {
            throw new IllegalStateException("Board not set");
        }
        String url = "https://api.trello.com/1/boards/" + this.myCurrentBoard.getId() + "/lists";
        List list = (List)this.makeRequestAndDeserializeJsonResponse(url, TrelloUtil.LIST_OF_LISTS_TYPE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchBoardLists"));
        }
        return list;
    }

    @NotNull
    public List<TrelloBoard> fetchUserBoards() throws Exception {
        if (this.myCurrentUser == null) {
            throw new IllegalStateException("User not set");
        }
        String url = "https://api.trello.com/1/members/me/boards?filter=open";
        List list = (List)this.makeRequestAndDeserializeJsonResponse(url, TrelloUtil.LIST_OF_BOARDS_TYPE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchUserBoards"));
        }
        return list;
    }

    @NotNull
    private List<TrelloCard> fetchCards() throws Exception {
        String baseUrl;
        boolean fromList = false;
        if (this.myCurrentList != null) {
            baseUrl = "https://api.trello.com/1/lists/" + this.myCurrentList.getId() + "/cards";
            fromList = true;
        } else if (this.myCurrentBoard != null) {
            baseUrl = "https://api.trello.com/1/boards/" + this.myCurrentBoard.getId() + "/cards";
        } else if (this.myCurrentUser != null) {
            baseUrl = "https://api.trello.com/1/members/me/cards";
        } else {
            throw new IllegalStateException("Not configured");
        }
        String allCardsUrl = baseUrl + "?filter=all";
        List cards = (List)this.makeRequestAndDeserializeJsonResponse(allCardsUrl, TrelloUtil.LIST_OF_CARDS_TYPE);
        LOG.debug("Total " + cards.size() + " cards downloaded");
        List filtered = ContainerUtil.filter((Collection)cards, (Condition)new Condition<TrelloCard>(){

            public boolean value(TrelloCard card) {
                return card.getIdMembers().contains(TrelloRepository.this.myCurrentUser.getId());
            }
        });
        LOG.debug("Total " + filtered.size() + " cards after filtering");
        if (!fromList) {
            String visibleCardsUrl = baseUrl + "?filter=visible&fields=none";
            List visibleCards = (List)this.makeRequestAndDeserializeJsonResponse(visibleCardsUrl, TrelloUtil.LIST_OF_CARDS_TYPE);
            LOG.debug("Total " + visibleCards.size() + " visible cards");
            Set visibleCardsIDs = ContainerUtil.map2Set((Collection)visibleCards, (Function)new Function<TrelloCard, String>(){

                public String fun(TrelloCard card) {
                    return card.getId();
                }
            });
            for (TrelloCard card : filtered) {
                card.setVisible(visibleCardsIDs.contains(card.getId()));
            }
        }
        List list = filtered;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "fetchCards"));
        }
        return list;
    }

    private String makeRequest(String url) throws Exception {
        GetMethod method = new GetMethod(url);
        this.configureHttpMethod((HttpMethod)method);
        return this.executeMethod((HttpMethod)method);
    }

    private String executeMethod(HttpMethod method) throws Exception {
        HttpClient client = this.getHttpClient();
        client.executeMethod(method);
        String entityContent = StreamUtil.readText((InputStream)method.getResponseBodyAsStream(), (String)"utf-8");
        LOG.debug(entityContent);
        if (method.getStatusCode() != 200) {
            Header header = method.getResponseHeader("Content-Type");
            if (header != null && header.getValue().startsWith("text/plain")) {
                throw new Exception("Request failed. Reason: " + StringUtil.capitalize((String)entityContent));
            }
            throw new Exception("Request failed with HTTP error: " + method.getStatusText());
        }
        return entityContent;
    }

    @NotNull
    private <T> T makeRequestAndDeserializeJsonResponse(String url, Type type) throws Exception {
        String entityStream = this.makeRequest(url);
        Object object = TrelloUtil.GSON.fromJson(entityStream, type);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        return (T)object;
    }

    @NotNull
    private <T> T makeRequestAndDeserializeJsonResponse(String url, Class<T> cls) throws Exception {
        String entityStream = this.makeRequest(url);
        Object object = TrelloUtil.GSON.fromJson(entityStream, cls);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/trello/TrelloRepository", "makeRequestAndDeserializeJsonResponse"));
        }
        return (T)object;
    }

    public String getPresentableName() {
        String pseudoUrl = "trello.com";
        if (this.myCurrentBoard != null) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentBoard.getName();
        }
        if (this.myCurrentList != null) {
            pseudoUrl = pseudoUrl + "/" + this.myCurrentList.getName();
        }
        return pseudoUrl;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        GetMethod method = new GetMethod("https://api.trello.com/1/members/me/cards?limit=1");
        this.configureHttpMethod((HttpMethod)method);
        return new BaseRepositoryImpl.HttpTestConnection<GetMethod>(method){

            protected void doTest(GetMethod method) throws Exception {
                TrelloRepository.this.executeMethod((HttpMethod)method);
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.myPassword);
    }

    public String getUrl() {
        return "trello.com";
    }

    protected int getFeatures() {
        return super.getFeatures() & 0xFFFFFFEF;
    }
}

