/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.redmine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.redmine.RedmineRepositoryType;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import icons.TasksIcons;
import java.io.InputStream;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;

@Tag(value="Redmine")
public class RedmineRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.redmine.RedmineRepository");
    private Pattern myPattern;
    private String myAPIKey;
    private String myProjectId;

    public RedmineRepository() {
    }

    public RedmineRepository(RedmineRepositoryType type) {
        super((TaskRepositoryType)type);
    }

    public RedmineRepository(RedmineRepository other) {
        super((BaseRepositoryImpl)other);
        this.setAPIKey(other.myAPIKey);
        this.setProjectId(other.myProjectId);
    }

    public void testConnection() throws Exception {
        this.getIssues("", 10, 0L);
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        List<Element> children = this.getIssues(query, max);
        List tasks = ContainerUtil.mapNotNull(children, (Function)new NullableFunction<Element, Task>(){

            public Task fun(Element o) {
                return RedmineRepository.this.createIssue(o);
            }
        });
        return tasks.toArray(new Task[tasks.size()]);
    }

    @Nullable
    private Task createIssue(Element element) {
        final String id = element.getChildText("id");
        if (id == null) {
            return null;
        }
        final String summary = element.getChildText("subject");
        if (summary == null) {
            return null;
        }
        Element status = element.getChild("status");
        final boolean isClosed = status == null || "Closed".equals(status.getAttributeValue("name"));
        final String description = element.getChildText("description");
        final Ref updated = new Ref();
        final Ref created = new Ref();
        try {
            updated.set((Object)RedmineRepository.parseDate(element, "updated_on"));
            created.set((Object)RedmineRepository.parseDate(element, "created_on"));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
        }
        return new Task(){

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                String id2 = RedmineRepository.this.getRealId(this.getId());
                return id2 != null ? RedmineRepository.this.getUrl() + "/issues/" + id2 : null;
            }

            @NotNull
            public String getId() {
                String string = RedmineRepository.this.myProjectId + "-" + id;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineRepository$2", "getId"));
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = summary;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineRepository$2", "getSummary"));
                }
                return string;
            }

            public String getDescription() {
                return description;
            }

            @NotNull
            public Comment[] getComments() {
                Comment[] commentArray = new Comment[]{};
                if (commentArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineRepository$2", "getComments"));
                }
                return commentArray;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = TasksIcons.Redmine;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineRepository$2", "getIcon"));
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = TaskType.BUG;
                if (taskType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/redmine/RedmineRepository$2", "getType"));
                }
                return taskType;
            }

            public Date getUpdated() {
                return (Date)updated.get();
            }

            public Date getCreated() {
                return (Date)created.get();
            }

            public boolean isClosed() {
                return isClosed;
            }

            public TaskRepository getRepository() {
                return RedmineRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }
        };
    }

    @Nullable
    private static Date parseDate(Element element, String name) throws ParseException {
        Date parsed;
        String date = element.getChildText(name);
        if (date.matches(".*\\+\\d\\d:\\d\\d")) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd'T'HH:mm:ss", Locale.US);
            int timeZoneIndex = date.length() - 6;
            format.setTimeZone(TimeZone.getTimeZone("GMT" + date.substring(timeZoneIndex)));
            return format.parse(date.substring(0, timeZoneIndex));
        }
        try {
            parsed = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US).parse(date);
        }
        catch (ParseException e) {
            parsed = TaskUtil.parseDate(date);
        }
        return parsed;
    }

    public boolean isConfigured() {
        return super.isConfigured() && !StringUtil.isEmpty((String)this.myProjectId);
    }

    private List<Element> getIssues(@Nullable String query, int max) throws Exception {
        Element element;
        boolean hasQuery;
        boolean hasKey;
        String url = "/projects/" + this.myProjectId + "/issues.xml?";
        boolean bl = hasKey = !StringUtil.isEmpty((String)this.myAPIKey) && !this.isUseHttpAuthentication();
        if (hasKey) {
            url = url + "key=" + this.myAPIKey;
        }
        if (hasKey) {
            url = url + "&";
        }
        url = url + RedmineRepository.encodeUrl((String)"fields[]") + "=status_id&" + RedmineRepository.encodeUrl((String)"operators[status_id]") + "=o&" + RedmineRepository.encodeUrl((String)"values[status_id][]") + "=1";
        boolean bl2 = hasQuery = !StringUtil.isEmpty((String)query);
        if (hasQuery) {
            url = url + "&" + RedmineRepository.encodeUrl((String)"fields[]") + "=subject&" + RedmineRepository.encodeUrl((String)"operators[subject]") + "=" + RedmineRepository.encodeUrl((String)"~") + "&" + RedmineRepository.encodeUrl((String)"values[subject][]") + "=" + RedmineRepository.encodeUrl((String)query);
        }
        if (max >= 0) {
            url = url + "&per_page=" + RedmineRepository.encodeUrl((String)String.valueOf(max));
        }
        HttpMethod method = this.doREST(url, false);
        String response = method.getResponseBodyAsString();
        StringReader stream = new StringReader(response);
        InputSource source = new InputSource(stream);
        source.setEncoding("UTF-8");
        try {
            element = new SAXBuilder(false).build(source).getRootElement();
        }
        catch (Throwable t) {
            LOG.error("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode(), t, new String[]{response});
            throw new Exception("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode() + "\n" + response);
        }
        if (!"issues".equals(element.getName())) {
            LOG.warn("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode());
            throw new Exception("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode() + "\n" + element.getText());
        }
        return element.getChildren("issue");
    }

    private HttpMethod doREST(String request, boolean post) throws Exception {
        HttpClient client = this.getHttpClient();
        client.getParams().setContentCharset("UTF-8");
        String uri = this.getUrl() + request;
        PostMethod method = post ? new PostMethod(uri) : new GetMethod(uri);
        this.configureHttpMethod((HttpMethod)method);
        client.executeMethod((HttpMethod)method);
        return method;
    }

    @Nullable
    public Task findTask(String id) throws Exception {
        String realId = this.getRealId(id);
        if (realId == null) {
            return null;
        }
        HttpMethod method = this.doREST("/issues/" + realId + ".xml", false);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        return element.getName().equals("issue") ? this.createIssue(element) : null;
    }

    public BaseRepository clone() {
        return new RedmineRepository(this);
    }

    @Nullable
    private String getRealId(String id) {
        String start = this.myProjectId + "-";
        return id.startsWith(start) ? id.substring(start.length()) : null;
    }

    @Nullable
    public String extractId(String taskName) {
        Matcher matcher = this.myPattern.matcher(taskName);
        return matcher.find() ? matcher.group(1) : null;
    }

    public String getAPIKey() {
        return this.myAPIKey;
    }

    public void setAPIKey(String APIKey) {
        this.myAPIKey = APIKey;
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(String projectId) {
        this.myProjectId = projectId;
        this.myPattern = Pattern.compile("(" + projectId + "\\-\\d+):\\s+");
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof RedmineRepository)) {
            return false;
        }
        RedmineRepository that = (RedmineRepository)((Object)o);
        if (this.getAPIKey() != null ? !this.getAPIKey().equals(that.getAPIKey()) : that.getAPIKey() != null) {
            return false;
        }
        return !(this.getProjectId() != null ? !this.getProjectId().equals(that.getProjectId()) : that.getProjectId() != null);
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + "/projects" + (!StringUtil.isEmpty((String)this.getProjectId()) ? "/" + this.getProjectId() : "");
    }

    protected int getFeatures() {
        return super.getFeatures() | 1;
    }
}

