/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.SimpleComment;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.pivotal.PivotalTrackerRepositoryType;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="PivotalTracker")
public class PivotalTrackerRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.pivotal.PivotalTrackerRepository");
    private static final String API_URL = "/services/v3";
    private Pattern myPattern;
    private String myProjectId;
    private String myAPIKey;

    public PivotalTrackerRepository() {
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("http://www.pivotaltracker.com");
        }
        this.myCommitMessageFormat = "[fixes #{number}] {summary}";
    }

    public PivotalTrackerRepository(PivotalTrackerRepositoryType type) {
        super((TaskRepositoryType)type);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("http://www.pivotaltracker.com");
        }
    }

    private PivotalTrackerRepository(PivotalTrackerRepository other) {
        super((BaseRepositoryImpl)other);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("http://www.pivotaltracker.com");
        }
        this.setProjectId(other.myProjectId);
        this.setAPIKey(other.myAPIKey);
    }

    public void testConnection() throws Exception {
        this.getIssues("", 10, 0L);
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.getProjectId()) && StringUtil.isNotEmpty((String)this.getAPIKey());
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        List<Element> children = this.getStories(query, max);
        List tasks = ContainerUtil.mapNotNull(children, (Function)new NullableFunction<Element, Task>(){

            public Task fun(Element o) {
                return PivotalTrackerRepository.this.createIssue(o);
            }
        });
        return tasks.toArray(new Task[tasks.size()]);
    }

    private List<Element> getStories(@Nullable String query, int max) throws Exception {
        String url = "/services/v3/projects/" + this.myProjectId + "/stories";
        url = url + "?filter=" + PivotalTrackerRepository.encodeUrl((String)"state:started,unstarted,unscheduled,rejected");
        if (!StringUtil.isEmpty((String)query)) {
            url = url + PivotalTrackerRepository.encodeUrl((String)(" \"" + query + '\"'));
        }
        if (max >= 0) {
            url = url + "&limit=" + PivotalTrackerRepository.encodeUrl((String)String.valueOf(max));
        }
        LOG.info("Getting all the stories with url: " + url);
        HttpMethod method = this.doREST(url, HTTPMethod.GET);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        if (!"stories".equals(element.getName())) {
            LOG.warn("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode());
            throw new Exception("Error fetching issues for: " + url + ", HTTP status code: " + method.getStatusCode() + "\n" + element.getText());
        }
        return element.getChildren("story");
    }

    @Nullable
    private Task createIssue(Element element) {
        final String id = element.getChildText("id");
        if (id == null) {
            return null;
        }
        final String summary = element.getChildText("name");
        if (summary == null) {
            return null;
        }
        final String type = element.getChildText("story_type");
        if (type == null) {
            return null;
        }
        final Comment[] comments = PivotalTrackerRepository.parseComments(element.getChild("notes"));
        final boolean isClosed = "accepted".equals(element.getChildText("state")) || "delivered".equals(element.getChildText("state")) || "finished".equals(element.getChildText("state"));
        final String description = element.getChildText("description");
        final Ref updated = new Ref();
        final Ref created = new Ref();
        try {
            updated.set((Object)PivotalTrackerRepository.parseDate(element, "updated_at"));
            created.set((Object)PivotalTrackerRepository.parseDate(element, "created_at"));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
        }
        return new Task(){

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                String id2 = PivotalTrackerRepository.this.getRealId(this.getId());
                return id2 != null ? PivotalTrackerRepository.this.getUrl() + "/story/show/" + id2 : null;
            }

            @NotNull
            public String getId() {
                String string = PivotalTrackerRepository.this.myProjectId + "-" + id;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/pivotal/PivotalTrackerRepository$2", "getId"));
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = summary;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/pivotal/PivotalTrackerRepository$2", "getSummary"));
                }
                return string;
            }

            public String getDescription() {
                return description;
            }

            @NotNull
            public Comment[] getComments() {
                if (comments == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/pivotal/PivotalTrackerRepository$2", "getComments"));
                }
                return comments;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = IconLoader.getIcon((String)this.getCustomIcon(), LocalTask.class);
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/pivotal/PivotalTrackerRepository$2", "getIcon"));
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = TaskType.OTHER;
                if (taskType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/pivotal/PivotalTrackerRepository$2", "getType"));
                }
                return taskType;
            }

            public Date getUpdated() {
                return (Date)updated.get();
            }

            public Date getCreated() {
                return (Date)created.get();
            }

            public boolean isClosed() {
                return isClosed;
            }

            public TaskRepository getRepository() {
                return PivotalTrackerRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }

            @NotNull
            public String getCustomIcon() {
                String string = "/icons/pivotal/" + type + ".png";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/pivotal/PivotalTrackerRepository$2", "getCustomIcon"));
                }
                return string;
            }
        };
    }

    private static Comment[] parseComments(Element notes) {
        if (notes == null) {
            return Comment.EMPTY_ARRAY;
        }
        ArrayList<SimpleComment> result = new ArrayList<SimpleComment>();
        for (Element note : notes.getChildren("note")) {
            String text = note.getChildText("text");
            if (text == null) continue;
            Ref date = new Ref();
            try {
                date.set((Object)PivotalTrackerRepository.parseDate(note, "noted_at"));
            }
            catch (ParseException e) {
                LOG.warn((Throwable)e);
            }
            String author = note.getChildText("author");
            result.add(new SimpleComment((Date)date.get(), author, text));
        }
        return result.toArray(new Comment[result.size()]);
    }

    @Nullable
    private static Date parseDate(Element element, String name) throws ParseException {
        String date = element.getChildText(name);
        return TaskUtil.parseDate(date);
    }

    private HttpMethod doREST(String request, HTTPMethod type) throws Exception {
        HttpClient client = this.getHttpClient();
        client.getParams().setContentCharset("UTF-8");
        String uri = this.getUrl() + request;
        PostMethod method = type == HTTPMethod.POST ? new PostMethod(uri) : (type == HTTPMethod.PUT ? new PutMethod(uri) : new GetMethod(uri));
        this.configureHttpMethod((HttpMethod)method);
        client.executeMethod((HttpMethod)method);
        return method;
    }

    @Nullable
    public Task findTask(String id) throws Exception {
        String realId = this.getRealId(id);
        if (realId == null) {
            return null;
        }
        String url = "/services/v3/projects/" + this.myProjectId + "/stories/" + realId;
        LOG.info("Retrieving issue by id: " + url);
        HttpMethod method = this.doREST(url, HTTPMethod.GET);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        return element.getName().equals("story") ? this.createIssue(element) : null;
    }

    @Nullable
    private String getRealId(String id) {
        String[] split = id.split("\\-");
        String projectId = split[0];
        return Comparing.strEqual((String)projectId, (String)this.myProjectId) ? split[1] : null;
    }

    @Nullable
    public String extractId(String taskName) {
        Matcher matcher = this.myPattern.matcher(taskName);
        return matcher.find() ? matcher.group(1) : null;
    }

    public BaseRepository clone() {
        return new PivotalTrackerRepository(this);
    }

    protected void configureHttpMethod(HttpMethod method) {
        method.addRequestHeader("X-TrackerToken", this.myAPIKey);
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(String projectId) {
        this.myProjectId = projectId;
        this.myPattern = Pattern.compile("(" + projectId + "\\-\\d+):\\s+");
    }

    public String getAPIKey() {
        return this.myAPIKey;
    }

    public void setAPIKey(String APIKey) {
        this.myAPIKey = APIKey;
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (!StringUtil.isEmpty((String)this.getProjectId()) ? "/" + this.getProjectId() : "");
    }

    @Nullable
    public String getTaskComment(Task task) {
        if (this.isShouldFormatCommitMessage()) {
            String id = task.getId();
            String realId = this.getRealId(id);
            return realId != null ? this.myCommitMessageFormat.replace("{id}", realId).replace("{project}", this.myProjectId) + " " + task.getSummary() : null;
        }
        return super.getTaskComment(task);
    }

    public void setTaskState(Task task, TaskState state) throws Exception {
        String stateName;
        String realId = this.getRealId(task.getId());
        if (realId == null) {
            return;
        }
        switch (state) {
            case IN_PROGRESS: {
                stateName = "started";
                break;
            }
            case RESOLVED: {
                stateName = "finished";
                break;
            }
            default: {
                return;
            }
        }
        String url = "/services/v3/projects/" + this.myProjectId + "/stories/" + realId;
        url = url + "?" + PivotalTrackerRepository.encodeUrl((String)"story[current_state]") + "=" + PivotalTrackerRepository.encodeUrl((String)stateName);
        LOG.info("Updating issue state by id: " + url);
        HttpMethod method = this.doREST(url, HTTPMethod.PUT);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        if (!element.getName().equals("story")) {
            if (element.getName().equals("errors")) {
                throw new Exception(PivotalTrackerRepository.extractErrorMessage(element));
            }
            LOG.warn("Error setting state for: " + url + ", HTTP status code: " + method.getStatusCode());
            throw new Exception(String.format("Cannot set state '%s' for issue.", stateName));
        }
    }

    @NotNull
    private static String extractErrorMessage(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/pivotal/PivotalTrackerRepository", "extractErrorMessage"));
        }
        String string = StringUtil.notNullize((String)element.getChild("error").getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/pivotal/PivotalTrackerRepository", "extractErrorMessage"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof PivotalTrackerRepository)) {
            return false;
        }
        PivotalTrackerRepository that = (PivotalTrackerRepository)((Object)o);
        if (this.getAPIKey() != null ? !this.getAPIKey().equals(that.getAPIKey()) : that.getAPIKey() != null) {
            return false;
        }
        if (this.getProjectId() != null ? !this.getProjectId().equals(that.getProjectId()) : that.getProjectId() != null) {
            return false;
        }
        if (this.getCommitMessageFormat() != null ? !this.getCommitMessageFormat().equals(that.getCommitMessageFormat()) : that.getCommitMessageFormat() != null) {
            return false;
        }
        return this.isShouldFormatCommitMessage() == that.isShouldFormatCommitMessage();
    }

    protected int getFeatures() {
        return super.getFeatures() | 1;
    }
}

