/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskUtil {
    private static SimpleDateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static Pattern ISO8601_DATE_PATTERN;
    private static final JsonDeserializer<Date> DATE_DESERIALIZER;

    public static String formatTask(@NotNull Task task, String format) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "formatTask"));
        }
        return format.replace("{id}", task.getId()).replace("{number}", task.getNumber()).replace("{project}", task.getProject() == null ? "" : task.getProject()).replace("{summary}", task.getSummary());
    }

    @Nullable
    public static String getChangeListComment(Task task) {
        TaskRepository repository = task.getRepository();
        if (repository == null || !repository.isShouldFormatCommitMessage()) {
            return null;
        }
        return TaskUtil.formatTask(task, repository.getCommitMessageFormat());
    }

    public static String getTrimmedSummary(Task task) {
        String text = task.isIssue() ? task.getId() + ": " + task.getSummary() : task.getSummary();
        return StringUtil.first((String)text, (int)60, (boolean)true);
    }

    @Nullable
    public static Date parseDate(@NotNull String s) {
        String milliseconds;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "parseDate"));
        }
        Matcher m = ISO8601_DATE_PATTERN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String datePart = m.group(1).replace('/', '-');
        String timePart = m.group(2);
        if (timePart == null) {
            timePart = "00:00:00";
        }
        milliseconds = (milliseconds = m.group(3)) == null ? "000" : milliseconds.substring(1, 4);
        String timezone = m.group(4);
        if (timezone == null || timezone.equals("Z")) {
            timezone = "+0000";
        } else if (timezone.length() == 3) {
            timezone = timezone + "00";
        } else if (timezone.length() == 6) {
            timezone = timezone.substring(0, 3) + timezone.substring(4, 6);
        }
        String canonicalForm = String.format("%sT%s.%s%s", datePart, timePart, milliseconds, timezone);
        try {
            return ISO8601_DATE_FORMAT.parse(canonicalForm);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "formatDate"));
        }
        return ISO8601_DATE_FORMAT.format(date);
    }

    public static boolean tasksEqual(@NotNull Task t1, @NotNull Task t2) {
        if (t1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (!t1.getId().equals(t2.getId())) {
            return false;
        }
        if (!t1.getSummary().equals(t2.getSummary())) {
            return false;
        }
        if (t1.isClosed() != t2.isClosed()) {
            return false;
        }
        if (t1.isIssue() != t2.isIssue()) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getState(), (Object)t2.getState())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getType(), (Object)t2.getType())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getDescription(), (String)t2.getDescription())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getCreated(), (Object)t2.getCreated())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getUpdated(), (Object)t2.getUpdated())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getIssueUrl(), (String)t2.getIssueUrl())) {
            return false;
        }
        if (!Comparing.equal((Object[])t1.getComments(), (Object[])t2.getComments())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getIcon(), (Object)t2.getIcon())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getCustomIcon(), (String)t2.getCustomIcon())) {
            return false;
        }
        return Comparing.equal((Object)t1.getRepository(), (Object)t2.getRepository());
    }

    public static boolean tasksEqual(@NotNull List<? extends Task> tasks1, @NotNull List<? extends Task> tasks2) {
        if (tasks1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (tasks2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (tasks1.size() != tasks2.size()) {
            return false;
        }
        for (int i = 0; i < tasks1.size(); ++i) {
            if (TaskUtil.tasksEqual(tasks1.get(i), tasks2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean tasksEqual(@NotNull Task[] task1, @NotNull Task[] task2) {
        if (task1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        return TaskUtil.tasksEqual(Arrays.asList(task1), Arrays.asList(task2));
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull Element element) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(element));
        }
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull InputStream xml) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JDOMUtil.loadDocument((InputStream)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull String xml) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JDOMUtil.loadDocument((CharSequence)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatJsonToLog(@NotNull Logger logger, @NotNull String json) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "prettyFormatJsonToLog"));
        }
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/impl/TaskUtil", "prettyFormatJsonToLog"));
        }
        if (logger.isDebugEnabled()) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson.toJson((JsonElement)gson.fromJson(json, JsonElement.class)));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    public static GsonBuilder installDateDeserializer(GsonBuilder builder) {
        return builder.registerTypeAdapter(Date.class, DATE_DESERIALIZER);
    }

    @NotNull
    public static String encodeUrl(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/impl/TaskUtil", "encodeUrl"));
        }
        try {
            string = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is not supported");
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskUtil", "encodeUrl"));
        }
        return string;
    }

    static {
        ISO8601_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        ISO8601_DATE_PATTERN = Pattern.compile("(\\d{4}[/-]\\d{2}[/-]\\d{2})(?:[ T](\\d{2}:\\d{2}:\\d{2})(.\\d{3,})?([+-]\\d{2}:\\d{2}|[+-]\\d{4}|[+-]\\d{2}|Z)?)?");
        DATE_DESERIALIZER = new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return TaskUtil.parseDate(json.getAsString());
            }
        };
    }
}

