/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitlabTask
extends Task {
    private final GitlabIssue myIssue;
    private final GitlabRepository myRepository;
    private final GitlabProject myProject;

    public GitlabTask(@NotNull GitlabRepository respository, @NotNull GitlabProject project, @NotNull GitlabIssue issue) {
        if (respository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/gitlab/GitlabTask", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/gitlab/GitlabTask", "<init>"));
        }
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/tasks/gitlab/GitlabTask", "<init>"));
        }
        this.myRepository = respository;
        this.myIssue = issue;
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.myIssue.getId());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getId"));
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myIssue.getTitle();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getSummary"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public Comment[] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getComments"));
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksIcons.Gitlab;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.BUG;
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getType"));
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myIssue.getUpdatedAt();
    }

    @Nullable
    public Date getCreated() {
        return this.myIssue.getCreatedAt();
    }

    public boolean isClosed() {
        return this.myIssue.getState().equals("closed");
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        return this.myProject.getWebUrl() + "/issues/" + this.myIssue.getLocalId();
    }
}

