/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.util.Comparing;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.gitlab.GitlabTask;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.httpclient.ResponseUtil;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Gitlab")
public class GitlabRepository
extends NewBaseRepositoryImpl {
    @NonNls
    public static final String REST_API_PATH_PREFIX = "/api/v3/";
    public static final Gson GSON = TaskUtil.installDateDeserializer(new GsonBuilder()).create();
    public static final TypeToken<List<GitlabProject>> LIST_OF_PROJECTS_TYPE = new TypeToken<List<GitlabProject>>(){};
    public static final TypeToken<List<GitlabIssue>> LIST_OF_ISSUES_TYPE = new TypeToken<List<GitlabIssue>>(){};
    public static final GitlabProject UNSPECIFIED_PROJECT = new GitlabProject(){

        @Override
        public String getName() {
            return "-- from all projects --";
        }

        @Override
        public int getId() {
            return -1;
        }
    };
    private GitlabProject myCurrentProject;

    public GitlabRepository() {
    }

    public GitlabRepository(TaskRepositoryType type) {
        super(type);
    }

    public GitlabRepository(GitlabRepository other) {
        super(other);
        this.myCurrentProject = other.myCurrentProject;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GitlabRepository repository = (GitlabRepository)((Object)o);
        return Comparing.equal((Object)this.myCurrentProject, (Object)repository.myCurrentProject);
    }

    public int hashCode() {
        return this.myCurrentProject != null ? this.myCurrentProject.hashCode() : 0;
    }

    public GitlabRepository clone() {
        return new GitlabRepository(this);
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        return (Task[])ContainerUtil.map2Array(this.fetchIssues(), GitlabTask.class, (Function)new Function<GitlabIssue, GitlabTask>(){

            public GitlabTask fun(GitlabIssue issue) {
                return new GitlabTask(GitlabRepository.this, GitlabRepository.this.myCurrentProject, issue);
            }
        });
    }

    @Nullable
    public Task findTask(String id) throws Exception {
        return new GitlabTask(this, this.myCurrentProject, this.fetchIssue(Integer.parseInt(id)));
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            private HttpGet myRequest;
            {
                this.myRequest = new HttpGet(GitlabRepository.this.getIssuesUrl());
            }

            protected void doTest() throws Exception {
                HttpResponse response = GitlabRepository.this.getHttpClient().execute((HttpUriRequest)this.myRequest);
                StatusLine statusLine = response.getStatusLine();
                if (statusLine != null && statusLine.getStatusCode() != 200) {
                    throw new Exception(statusLine.getReasonPhrase());
                }
            }

            public void cancel() {
                this.myRequest.abort();
            }
        };
    }

    @NotNull
    List<GitlabProject> fetchProjects() throws Exception {
        HttpGet request = new HttpGet(this.getRestApiUrl("projects"));
        ResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject> handler = new ResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject>(GSON, LIST_OF_PROJECTS_TYPE);
        List list = (List)this.getHttpClient().execute((HttpUriRequest)request, handler);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabRepository", "fetchProjects"));
        }
        return list;
    }

    @NotNull
    GitlabProject fetchProject(int id) throws Exception {
        HttpGet request = new HttpGet(this.getRestApiUrl("project", id));
        GitlabProject gitlabProject = (GitlabProject)this.getHttpClient().execute((HttpUriRequest)request, new ResponseUtil.GsonSingleObjectDeserializer<GitlabProject>(GSON, GitlabProject.class));
        if (gitlabProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabRepository", "fetchProject"));
        }
        return gitlabProject;
    }

    @NotNull
    List<GitlabIssue> fetchIssues() throws Exception {
        ResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue> handler = new ResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue>(GSON, LIST_OF_ISSUES_TYPE);
        List list = (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(this.getIssuesUrl()), handler);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabRepository", "fetchIssues"));
        }
        return list;
    }

    private String getIssuesUrl() {
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            return this.getRestApiUrl("projects", this.myCurrentProject.getId(), "issues");
        }
        return this.getRestApiUrl("issues");
    }

    @NotNull
    GitlabIssue fetchIssue(int id) throws Exception {
        HttpGet request = new HttpGet(this.getRestApiUrl("issues", id));
        ResponseUtil.GsonSingleObjectDeserializer<GitlabIssue> handler = new ResponseUtil.GsonSingleObjectDeserializer<GitlabIssue>(GSON, GitlabIssue.class);
        GitlabIssue gitlabIssue = (GitlabIssue)this.getHttpClient().execute((HttpUriRequest)request, handler);
        if (gitlabIssue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabRepository", "fetchIssue"));
        }
        return gitlabIssue;
    }

    public boolean isConfigured() {
        return super.isConfigured() && !this.myPassword.isEmpty();
    }

    @Override
    @NotNull
    public String getRestApiPathPrefix() {
        if (REST_API_PATH_PREFIX == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabRepository", "getRestApiPathPrefix"));
        }
        return REST_API_PATH_PREFIX;
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader((Header)new BasicHeader("PRIVATE-TOKEN", GitlabRepository.this.myPassword));
            }
        };
    }

    public void setCurrentProject(GitlabProject currentProject) {
        this.myCurrentProject = currentProject.getId() == -1 ? UNSPECIFIED_PROJECT : currentProject;
    }

    public GitlabProject getCurrentProject() {
        return this.myCurrentProject;
    }
}

