/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericTask;
import com.intellij.tasks.generic.HighlightedSelectorsTable;
import com.intellij.tasks.generic.ResponseHandler;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectorBasedResponseHandler
extends ResponseHandler {
    private static final Logger LOG = Logger.getInstance(SelectorBasedResponseHandler.class);
    @NonNls
    protected static final String TASKS = "tasks";
    @NonNls
    protected static final String SUMMARY = "summary";
    @NonNls
    protected static final String DESCRIPTION = "description";
    @NonNls
    protected static final String ISSUE_URL = "issueUrl";
    @NonNls
    protected static final String CLOSED = "closed";
    @NonNls
    protected static final String UPDATED = "updated";
    @NonNls
    protected static final String CREATED = "created";
    @NonNls
    protected static final String SINGLE_TASK_ID = "singleTask-id";
    @NonNls
    protected static final String SINGLE_TASK_SUMMARY = "singleTask-summary";
    @NonNls
    protected static final String SINGLE_TASK_DESCRIPTION = "singleTask-description";
    @NonNls
    protected static final String SINGLE_TASK_ISSUE_URL = "singleTask-issueUrl";
    @NonNls
    protected static final String SINGLE_TASK_CLOSED = "singleTask-closed";
    @NonNls
    protected static final String SINGLE_TASK_UPDATED = "singleTask-updated";
    @NonNls
    protected static final String SINGLE_TASK_CREATED = "singleTask-created";
    @NonNls
    protected static final String ID = "id";
    protected LinkedHashMap<String, Selector> mySelectors = new LinkedHashMap();

    protected SelectorBasedResponseHandler() {
    }

    protected SelectorBasedResponseHandler(GenericRepository repository) {
        super(repository);
        this.setSelectors(ContainerUtil.newArrayList((Object[])new Selector[]{new Selector(TASKS), new Selector(ID), new Selector(SUMMARY), new Selector(DESCRIPTION), new Selector(UPDATED), new Selector(CREATED), new Selector(CLOSED), new Selector(ISSUE_URL), new Selector(SINGLE_TASK_ID), new Selector(SINGLE_TASK_SUMMARY), new Selector(SINGLE_TASK_DESCRIPTION), new Selector(SINGLE_TASK_UPDATED), new Selector(SINGLE_TASK_CREATED), new Selector(SINGLE_TASK_CLOSED), new Selector(SINGLE_TASK_ISSUE_URL)}));
    }

    @Tag(value="selectors")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false)
    @NotNull
    public List<Selector> getSelectors() {
        ArrayList<Selector> arrayList = new ArrayList<Selector>(this.mySelectors.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "getSelectors"));
        }
        return arrayList;
    }

    public void setSelectors(@NotNull List<Selector> selectors) {
        if (selectors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "setSelectors"));
        }
        this.mySelectors.clear();
        for (Selector selector : selectors) {
            this.mySelectors.put(selector.getName(), selector);
        }
    }

    @NotNull
    protected Selector getSelector(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "getSelector"));
        }
        Selector selector = this.mySelectors.get(name);
        if (selector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "getSelector"));
        }
        return selector;
    }

    @NotNull
    protected String getSelectorPath(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "getSelectorPath"));
        }
        Selector s = this.getSelector(name);
        String string = s.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "getSelectorPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getConfigurationComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "getConfigurationComponent"));
        }
        FileType fileType = this.getResponseType().getSelectorFileType();
        HighlightedSelectorsTable table = new HighlightedSelectorsTable(fileType, project, this.getSelectors());
        JBScrollPane jBScrollPane = new JBScrollPane((Component)((Object)table));
        if (jBScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "getConfigurationComponent"));
        }
        return jBScrollPane;
    }

    @Override
    public SelectorBasedResponseHandler clone() {
        SelectorBasedResponseHandler clone = (SelectorBasedResponseHandler)super.clone();
        clone.mySelectors = new LinkedHashMap(this.mySelectors.size());
        for (Selector selector : this.mySelectors.values()) {
            clone.mySelectors.put(selector.getName(), selector.clone());
        }
        return clone;
    }

    @Override
    public boolean isConfigured() {
        Selector idSelector = this.getSelector(ID);
        if (StringUtil.isEmpty((String)idSelector.getPath())) {
            return false;
        }
        Selector summarySelector = this.getSelector(SUMMARY);
        return !StringUtil.isEmpty((String)summarySelector.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorBasedResponseHandler)) {
            return false;
        }
        SelectorBasedResponseHandler handler = (SelectorBasedResponseHandler)o;
        return this.mySelectors.equals(handler.mySelectors);
    }

    public int hashCode() {
        return this.mySelectors.hashCode();
    }

    @Override
    @NotNull
    public final Task[] parseIssues(@NotNull String response, int max) throws Exception {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "parseIssues"));
        }
        if (StringUtil.isEmpty((String)this.getSelectorPath(TASKS)) || StringUtil.isEmpty((String)this.getSelectorPath(ID)) || StringUtil.isEmpty((String)this.getSelectorPath(SUMMARY))) {
            throw new Exception("Selectors 'tasks', 'id' and 'summary' are mandatory");
        }
        List<Object> tasks = this.selectTasksList(response, max);
        LOG.debug(String.format("Total %d tasks extracted from response", tasks.size()));
        ArrayList<GenericTask> result = new ArrayList<GenericTask>(tasks.size());
        for (Object context : tasks) {
            String id = this.selectString(this.getSelector(ID), context);
            String summary = this.selectString(this.getSelector(SUMMARY), context);
            assert (id != null && summary != null);
            GenericTask task = new GenericTask(id, summary, (TaskRepository)this.myRepository);
            if (!this.myRepository.getDownloadTasksInSeparateRequests()) {
                Date created;
                Date updated;
                Boolean closed;
                String issueUrl;
                String description = this.selectString(this.getSelector(DESCRIPTION), context);
                if (description != null) {
                    task.setDescription(description);
                }
                if ((issueUrl = this.selectString(this.getSelector(ISSUE_URL), context)) != null) {
                    task.setIssueUrl(issueUrl);
                }
                if ((closed = this.selectBoolean(this.getSelector(CLOSED), context)) != null) {
                    task.setClosed(closed);
                }
                if ((updated = this.selectDate(this.getSelector(UPDATED), context)) != null) {
                    task.setUpdated(updated);
                }
                if ((created = this.selectDate(this.getSelector(CREATED), context)) != null) {
                    task.setCreated(created);
                }
            }
            result.add(task);
        }
        Task[] taskArray = result.toArray(new Task[result.size()]);
        if (taskArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "parseIssues"));
        }
        return taskArray;
    }

    @Nullable
    private Date selectDate(@NotNull Selector selector, @NotNull Object context) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "selectDate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "selectDate"));
        }
        String s = this.selectString(selector, context);
        if (s == null) {
            return null;
        }
        return TaskUtil.parseDate(s);
    }

    @Nullable
    protected Boolean selectBoolean(@NotNull Selector selector, @NotNull Object context) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "selectBoolean"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "selectBoolean"));
        }
        String s = this.selectString(selector, context);
        if (s == null) {
            return null;
        }
        if ((s = s.trim().toLowerCase()).equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new Exception(String.format("Expression '%s' should match boolean value. Got '%s' instead", selector.getName(), s));
    }

    @NotNull
    protected abstract List<Object> selectTasksList(@NotNull String var1, int var2) throws Exception;

    @Nullable
    protected abstract String selectString(@NotNull Selector var1, @NotNull Object var2) throws Exception;

    @Override
    @Nullable
    public final Task parseIssue(@NotNull String response) throws Exception {
        Date created;
        Date updated;
        Boolean closed;
        String issueUrl;
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/generic/SelectorBasedResponseHandler", "parseIssue"));
        }
        if (StringUtil.isEmpty((String)this.getSelectorPath(SINGLE_TASK_ID)) || StringUtil.isEmpty((String)this.getSelectorPath(SINGLE_TASK_SUMMARY))) {
            throw new Exception("Selectors 'singleTask-id' and 'singleTask-summary' are mandatory");
        }
        String id = this.selectString(this.getSelector(SINGLE_TASK_ID), response);
        String summary = this.selectString(this.getSelector(SINGLE_TASK_SUMMARY), response);
        assert (id != null && summary != null);
        GenericTask task = new GenericTask(id, summary, (TaskRepository)this.myRepository);
        String description = this.selectString(this.getSelector(SINGLE_TASK_DESCRIPTION), response);
        if (description != null) {
            task.setDescription(description);
        }
        if ((issueUrl = this.selectString(this.getSelector(SINGLE_TASK_ISSUE_URL), response)) != null) {
            task.setIssueUrl(issueUrl);
        }
        if ((closed = this.selectBoolean(this.getSelector(SINGLE_TASK_CLOSED), response)) != null) {
            task.setClosed(closed);
        }
        if ((updated = this.selectDate(this.getSelector(SINGLE_TASK_UPDATED), response)) != null) {
            task.setUpdated(updated);
        }
        if ((created = this.selectDate(this.getSelector(SINGLE_TASK_CREATED), response)) != null) {
            task.setCreated(created);
        }
        return task;
    }
}

