/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.TemplateVariable;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public class GenericRepositoryUtil {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{(\\w[-\\w]*)\\}");

    public static HttpMethod getPostMethodFromURL(String requestUrl) {
        int n = requestUrl.indexOf(63);
        if (n == -1) {
            return new PostMethod(requestUrl);
        }
        PostMethod postMethod = new PostMethod(requestUrl.substring(0, n));
        Object[] queryParams = requestUrl.substring(n + 1).split("&");
        postMethod.addParameters((NameValuePair[])ContainerUtil.map2Array((Object[])queryParams, NameValuePair.class, (Function)new Function<String, NameValuePair>(){

            public NameValuePair fun(String s) {
                String[] nv = s.split("=");
                if (nv.length == 1) {
                    return new NameValuePair(nv[0], "");
                }
                return new NameValuePair(nv[0], nv[1]);
            }
        }));
        return postMethod;
    }

    public static String substituteTemplateVariables(String s, Collection<TemplateVariable> variables) throws Exception {
        return GenericRepositoryUtil.substituteTemplateVariables(s, variables, true);
    }

    public static String substituteTemplateVariables(String s, Collection<TemplateVariable> variables, boolean escape) throws Exception {
        HashMap lookup = new HashMap();
        for (TemplateVariable v : variables) {
            lookup.put(v.getName(), v.getValue());
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = PLACEHOLDER_PATTERN.matcher(s);
        while (m.find()) {
            String name = m.group(1);
            String replacement = (String)lookup.get(name);
            if (replacement == null) {
                throw new Exception(String.format("Template variable '%s' is undefined", name));
            }
            if (escape && !name.equals("serverUrl")) {
                m.appendReplacement(sb, URLEncoder.encode(replacement, "utf-8"));
                continue;
            }
            m.appendReplacement(sb, replacement);
        }
        return m.appendTail(sb).toString();
    }

    public static List<String> createPlaceholdersList(GenericRepository repository) {
        return GenericRepositoryUtil.createPlaceholdersList(repository.getAllTemplateVariables());
    }

    public static List<String> createPlaceholdersList(List<TemplateVariable> variables) {
        return ContainerUtil.map2List(variables, (Function)new Function<TemplateVariable, String>(){

            public String fun(TemplateVariable variable) {
                return String.format("{%s}", variable.getName());
            }
        });
    }

    public static String prettifyVariableName(String variableName) {
        String prettyName = variableName.replace('_', ' ');
        return StringUtil.capitalizeWords((String)prettyName, (boolean)true);
    }

    public static <T> List<T> concat(List<? extends T> list, T ... values) {
        return ContainerUtil.concat((boolean)true, list, (Object[])values);
    }
}

