/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.tasks.context.WorkingContextProvider;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class OpenEditorsContextProvider
extends WorkingContextProvider {
    private final FileEditorManagerImpl myFileEditorManager;

    public OpenEditorsContextProvider(FileEditorManager fileEditorManager) {
        this.myFileEditorManager = fileEditorManager instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager : null;
    }

    @NotNull
    public String getId() {
        if ("editors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/context/OpenEditorsContextProvider", "getId"));
        }
        return "editors";
    }

    @NotNull
    public String getDescription() {
        if ("Open editors and positions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/context/OpenEditorsContextProvider", "getDescription"));
        }
        return "Open editors and positions";
    }

    public void saveContext(Element element) {
        if (this.myFileEditorManager != null) {
            this.myFileEditorManager.writeExternal(element);
        }
    }

    public void loadContext(Element element) {
        if (this.myFileEditorManager != null) {
            this.myFileEditorManager.readExternal(element);
            this.myFileEditorManager.getMainSplitters().openFiles();
        }
    }

    public void clearContext() {
        if (this.myFileEditorManager != null) {
            this.myFileEditorManager.closeAllFiles();
            this.myFileEditorManager.getMainSplitters().clear();
        }
    }
}

