/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.SwitchTaskAction;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchTaskCombo
extends ComboBoxAction
implements DumbAware {
    private static final Key<ComboBoxAction.ComboBoxButton> BUTTON_KEY = Key.create((String)"SWITCH_TASK_BUTTON");

    public void actionPerformed(AnActionEvent e) {
        IdeFrameImpl ideFrame = SwitchTaskCombo.findFrame(e);
        ComboBoxAction.ComboBoxButton button = (ComboBoxAction.ComboBoxButton)ideFrame.getRootPane().getClientProperty(BUTTON_KEY);
        if (button == null || !button.isShowing()) {
            return;
        }
        button.showPopup();
    }

    private static IdeFrameImpl findFrame(AnActionEvent e) {
        return (IdeFrameImpl)IJSwingUtilities.findParentOfType((Component)((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)), IdeFrameImpl.class);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        return new ComboBoxAction.ComboBoxButton(presentation){

            public void addNotify() {
                super.addNotify();
                IdeFrame frame = (IdeFrame)UIUtil.getParentOfType(IdeFrame.class, (Component)((Object)this));
                assert (frame != null);
                frame.getComponent().getRootPane().putClientProperty(BUTTON_KEY, (Object)this);
            }

            protected JBPopup createPopup(Runnable onDispose) {
                return SwitchTaskAction.createPopup(DataManager.getInstance().getDataContext((Component)((Object)this)), onDispose, false);
            }
        };
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/SwitchTaskCombo", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (project == null || project.isDisposed() || "MainMenu".equals(e.getPlace()) && SwitchTaskCombo.findFrame(e) == null) {
            presentation.setEnabled(false);
            presentation.setText("");
            presentation.setIcon(null);
        } else {
            TaskManager taskManager = TaskManager.getManager((Project)project);
            LocalTask activeTask = taskManager.getActiveTask();
            presentation.setVisible(true);
            presentation.setEnabled(true);
            if (SwitchTaskCombo.isImplicit(activeTask) && taskManager.getAllRepositories().length == 0 && !TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO) {
                presentation.setVisible(false);
            } else {
                String s = SwitchTaskCombo.getText(activeTask);
                presentation.setText(s);
                presentation.setIcon(activeTask.getIcon());
                presentation.setDescription(activeTask.getSummary());
            }
        }
    }

    private static boolean isImplicit(LocalTask activeTask) {
        return activeTask.isDefault() && Comparing.equal((Object)activeTask.getCreated(), (Object)activeTask.getUpdated());
    }

    private static String getText(LocalTask activeTask) {
        String text = activeTask.getPresentableName();
        return StringUtil.first((String)text, (int)50, (boolean)true);
    }
}

