/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiManager;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.ConfigureServersAction;
import com.intellij.tasks.actions.OpenTaskDialog;
import com.intellij.tasks.actions.TaskCellRenderer;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.doc.TaskPsiElement;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GotoTaskAction
extends GotoActionBase
implements DumbAware {
    public static final CreateNewTaskAction CREATE_NEW_TASK_ACTION = new CreateNewTaskAction();
    public static final String ID = "tasks.goto";

    public GotoTaskAction() {
        this.getTemplatePresentation().setText("Open Task...");
        this.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
    }

    protected void gotoActionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        this.perform(project);
    }

    void perform(final Project project) {
        final Ref shiftPressed = Ref.create((Object)false);
        final ChooseByNamePopup popup = ChooseByNamePopup.createPopup((Project)project, (ChooseByNameModel)new GotoTaskPopupModel(project), (ChooseByNameItemProvider)new ChooseByNameItemProvider(){

            @NotNull
            public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
                if (base == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/GotoTaskAction$1", "filterNames"));
                }
                if (names == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/actions/GotoTaskAction$1", "filterNames"));
                }
                if (pattern == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/tasks/actions/GotoTaskAction$1", "filterNames"));
                }
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/GotoTaskAction$1", "filterNames"));
                }
                return list;
            }

            public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
                boolean cachedTasksFound;
                if (base == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/GotoTaskAction$1", "filterElements"));
                }
                if (pattern == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/actions/GotoTaskAction$1", "filterElements"));
                }
                if (cancelled == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/tasks/actions/GotoTaskAction$1", "filterElements"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/tasks/actions/GotoTaskAction$1", "filterElements"));
                }
                CREATE_NEW_TASK_ACTION.setTaskName(pattern);
                if (!consumer.process((Object)CREATE_NEW_TASK_ACTION)) {
                    return false;
                }
                List<Task> cachedAndLocalTasks = TaskSearchSupport.getLocalAndCachedTasks(TaskManager.getManager((Project)project), pattern, everywhere);
                boolean bl = cachedTasksFound = !cachedAndLocalTasks.isEmpty();
                if (!GotoTaskAction.processTasks(cachedAndLocalTasks, (Processor<Object>)consumer, cachedTasksFound, cancelled, PsiManager.getInstance((Project)project))) {
                    return false;
                }
                List<Task> tasks = TaskSearchSupport.getRepositoriesTasks(TaskManager.getManager((Project)project), pattern, base.getMaximumListSizeLimit(), 0L, true, everywhere, cancelled);
                tasks.removeAll(cachedAndLocalTasks);
                return GotoTaskAction.processTasks(tasks, (Processor<Object>)consumer, cachedTasksFound, cancelled, PsiManager.getInstance((Project)project));
            }
        }, null, (boolean)false, (int)0);
        popup.setShowListForEmptyPattern(true);
        popup.setSearchInAnyPlace(true);
        popup.setFixLostTyping(false);
        popup.setAdText("<html>Press SHIFT to merge with current context<br/>Pressing " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("QuickJavaDoc")) + " would show task description and comments</html>");
        popup.registerAction("shiftPressed", KeyStroke.getKeyStroke("shift pressed SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)true);
            }
        });
        popup.registerAction("shiftReleased", KeyStroke.getKeyStroke("released SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)false);
            }
        });
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{new ConfigureServersAction(){

            @Override
            protected void serversChanged() {
                popup.rebuildList(true);
            }
        }});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(0);
        actionToolbar.updateActionsImmediately();
        actionToolbar.getComponent().setFocusable(false);
        actionToolbar.getComponent().setBorder(null);
        popup.setToolArea(actionToolbar.getComponent());
        popup.setMaximumListSizeLimit(10);
        popup.setListSizeIncreasing(10);
        this.showNavigationPopup((GotoActionBase.GotoActionCallback)new GotoActionBase.GotoActionCallback<Object>(){

            public void elementChosen(ChooseByNamePopup popup, Object element) {
                TaskManager taskManager = TaskManager.getManager((Project)project);
                if (element instanceof TaskPsiElement) {
                    Task task = ((TaskPsiElement)((Object)element)).getTask();
                    LocalTask localTask = taskManager.findTask(task.getId());
                    if (localTask != null) {
                        taskManager.activateTask((Task)localTask, (Boolean)shiftPressed.get() == false);
                    } else {
                        GotoTaskAction.showOpenTaskDialog(project, task);
                    }
                } else if (element == CREATE_NEW_TASK_ACTION) {
                    LocalTask localTask = taskManager.createLocalTask(CREATE_NEW_TASK_ACTION.getTaskName());
                    GotoTaskAction.showOpenTaskDialog(project, (Task)localTask);
                }
            }
        }, null, popup);
    }

    private static boolean processTasks(List<Task> tasks, Processor<Object> consumer, boolean cachedTasksFound, ProgressIndicator cancelled, PsiManager psiManager) {
        if (!(cachedTasksFound || tasks.isEmpty() || consumer.process((Object)"non-prefix matches:"))) {
            return false;
        }
        for (Task task : tasks) {
            cancelled.checkCanceled();
            if (consumer.process((Object)new TaskPsiElement(psiManager, task))) continue;
            return false;
        }
        return true;
    }

    private static void showOpenTaskDialog(final Project project, final Task task) {
        JBPopup hint = DocumentationManager.getInstance((Project)project).getDocInfoHint();
        if (hint != null) {
            hint.cancel();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                new OpenTaskDialog(project, task).show();
            }
        });
    }

    public static class CreateNewTaskAction {
        private String taskName;

        public String getActionText() {
            return "Create New Task '" + this.taskName + "'";
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskName() {
            return this.taskName;
        }
    }

    private static class GotoTaskPopupModel
    extends SimpleChooseByNameModel {
        private ListCellRenderer myListCellRenderer;

        protected GotoTaskPopupModel(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/actions/GotoTaskAction$GotoTaskPopupModel", "<init>"));
            }
            super(project, "Enter task name:", null);
            this.myListCellRenderer = new TaskCellRenderer(project);
        }

        public String[] getNames() {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        protected Object[] getElementsByName(String name, String pattern) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public ListCellRenderer getListCellRenderer() {
            return this.myListCellRenderer;
        }

        public String getElementName(Object element) {
            if (element instanceof TaskPsiElement) {
                return TaskUtil.getTrimmedSummary(((TaskPsiElement)((Object)element)).getTask());
            }
            if (element == CREATE_NEW_TASK_ACTION) {
                return CREATE_NEW_TASK_ACTION.getActionText();
            }
            return null;
        }

        public String getCheckBoxName() {
            return "Include closed tasks";
        }

        public void saveInitialCheckBoxState(boolean state) {
            ((TaskManagerImpl)TaskManager.getManager((Project)this.getProject())).getState().searchClosedTasks = state;
        }

        public boolean loadInitialCheckBoxState() {
            return ((TaskManagerImpl)TaskManager.getManager((Project)this.getProject())).getState().searchClosedTasks;
        }
    }
}

