/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomProperty;
import com.intellij.lang.ant.validation.AntInspection;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntMissingPropertiesFileInspection
extends AntInspection {
    @NonNls
    private static final String SHORT_NAME = "AntMissingPropertiesFileInspection";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AntBundle.message("ant.missing.properties.file.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        PsiFileSystemItem file;
        AntDomProperty property;
        String fileName;
        if (element instanceof AntDomProperty && (fileName = (property = (AntDomProperty)element).getFile().getStringValue()) != null && !((file = (PsiFileSystemItem)property.getFile().getValue()) instanceof PropertiesFile)) {
            holder.createProblem(property.getFile(), AntBundle.message("file.doesnt.exist", fileName), new LocalQuickFix[0]);
        }
    }
}

