/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.PropertyProviderFinder;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetResolver
extends PropertyProviderFinder {
    private List<String> myDeclaredTargetRefs;
    @Nullable
    private AntDomTarget myContextTarget;
    private Result myResult;

    private TargetResolver(@NotNull Collection<String> declaredDependencyRefs, @Nullable AntDomTarget contextElement) {
        if (declaredDependencyRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/dom/TargetResolver", "<init>"));
        }
        super(contextElement);
        this.myResult = new Result();
        this.myDeclaredTargetRefs = new ArrayList<String>(declaredDependencyRefs);
        this.myContextTarget = contextElement;
    }

    @NotNull
    public static Result resolve(@NotNull AntDomProject project, @Nullable AntDomTarget contextTarget, @NotNull String declaredTargetRef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/dom/TargetResolver", "resolve"));
        }
        if (declaredTargetRef == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/lang/ant/dom/TargetResolver", "resolve"));
        }
        Result result = TargetResolver.resolve(project, contextTarget, Arrays.asList(declaredTargetRef));
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/TargetResolver", "resolve"));
        }
        return result;
    }

    public static Result resolve(AntDomProject project, AntDomTarget contextTarget, @NotNull Collection<String> declaredTargetRefs) {
        if (declaredTargetRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/lang/ant/dom/TargetResolver", "resolve"));
        }
        TargetResolver resolver = new TargetResolver(declaredTargetRefs, contextTarget);
        resolver.execute(project, null);
        Result result = resolver.getResult();
        result.setVariants(resolver.getDiscoveredTargets());
        return result;
    }

    public static void validateDuplicateTargets(AntDomProject project, final TargetSink sink) {
        TargetResolver resolver = new TargetResolver(Collections.emptyList(), null){

            @Override
            protected void duplicateTargetFound(AntDomTarget existingTarget, AntDomTarget duplicatingTarget, String taregetEffectiveName) {
                sink.duplicateTargetDetected(existingTarget, duplicatingTarget, taregetEffectiveName);
            }

            @Override
            protected void stageCompleted(PropertyProviderFinder.Stage completedStage, PropertyProviderFinder.Stage startingStage) {
                if (PropertyProviderFinder.Stage.RESOLVE_MAP_BUILDING_STAGE.equals((Object)completedStage)) {
                    this.stop();
                }
            }
        };
        resolver.execute(project, null);
    }

    @Override
    protected void targetDefined(AntDomTarget target, String targetEffectiveName, Map<String, Pair<AntDomTarget, String>> dependenciesMap) {
        if (this.myContextTarget != null && this.myDeclaredTargetRefs.size() > 0 && target.equals(this.myContextTarget)) {
            Iterator<String> it = this.myDeclaredTargetRefs.iterator();
            while (it.hasNext()) {
                String declaredRef = it.next();
                Pair<AntDomTarget, String> result = dependenciesMap.get(declaredRef);
                if (result == null) continue;
                this.myResult.add(declaredRef, result);
                it.remove();
            }
            this.stop();
        }
    }

    @Override
    protected void stageCompleted(PropertyProviderFinder.Stage completedStage, PropertyProviderFinder.Stage startingStage) {
        if (completedStage == PropertyProviderFinder.Stage.RESOLVE_MAP_BUILDING_STAGE) {
            if (this.myDeclaredTargetRefs.size() > 0) {
                Iterator<String> it = this.myDeclaredTargetRefs.iterator();
                while (it.hasNext()) {
                    String declaredRef = it.next();
                    AntDomTarget result = this.getTargetByName(declaredRef);
                    if (result == null) continue;
                    this.myResult.add(declaredRef, (Pair<AntDomTarget, String>)new Pair((Object)result, (Object)declaredRef));
                    it.remove();
                }
            }
            this.stop();
        }
    }

    @NotNull
    public Result getResult() {
        Result result = this.myResult;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/TargetResolver", "getResult"));
        }
        return result;
    }

    @Override
    protected void propertyProviderFound(PropertiesProvider propertiesProvider) {
    }

    public static interface TargetSink {
        public void duplicateTargetDetected(AntDomTarget var1, AntDomTarget var2, String var3);
    }

    public static class Result {
        private String myRefsString;
        private Map<String, Pair<AntDomTarget, String>> myMap = new HashMap();
        private Map<String, AntDomTarget> myVariants;

        void add(String declaredTargetRef, Pair<AntDomTarget, String> pair) {
            this.myMap.put(declaredTargetRef, pair);
        }

        void setVariants(Map<String, AntDomTarget> variants) {
            this.myVariants = variants;
        }

        public String getRefsString() {
            return this.myRefsString;
        }

        public void setRefsString(String refsString) {
            this.myRefsString = refsString;
        }

        @NotNull
        public Collection<String> getTargetReferences() {
            Set<String> set = Collections.unmodifiableSet(this.myMap.keySet());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/TargetResolver$Result", "getTargetReferences"));
            }
            return set;
        }

        @Nullable
        public Pair<AntDomTarget, String> getResolvedTarget(String declaredTargetRef) {
            return this.myMap.get(declaredTargetRef);
        }

        @NotNull
        public Map<String, AntDomTarget> getVariants() {
            Map<String, AntDomTarget> map = this.myVariants != null ? this.myVariants : Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/TargetResolver$Result", "getVariants"));
            }
            return map;
        }
    }
}

