/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomMacroDef;
import com.intellij.lang.ant.dom.AntDomMacrodefAttribute;
import com.intellij.lang.ant.dom.AntDomReferenceBase;
import com.intellij.lang.ant.dom.AntStringResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDomMacrodefAttributeReference
extends AntDomReferenceBase {
    public AntDomMacrodefAttributeReference(PsiElement element, TextRange range) {
        super(element, range, true);
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("unknown.macro.attribute", this.getCanonicalText());
    }

    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)MyResolver.INSTANCE, false, false);
    }

    @NotNull
    public Object[] getVariants() {
        AntDomMacroDef parentMacrodef = this.getParentMacrodef();
        if (parentMacrodef != null) {
            ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
            for (AntDomMacrodefAttribute attribute : parentMacrodef.getMacroAttributes()) {
                String attribName = attribute.getName().getStringValue();
                if (attribName == null || attribName.length() <= 0) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((String)attribName);
                LookupElement element = AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder);
                variants.add(element);
            }
            Object[] objectArray = ContainerUtil.toArray(variants, (Object[])new Object[variants.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomMacrodefAttributeReference", "getVariants"));
            }
            return objectArray;
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomMacrodefAttributeReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    private AntDomMacroDef getParentMacrodef() {
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
        if (domElement == null) {
            return null;
        }
        return (AntDomMacroDef)domElement.getParentOfType(AntDomMacroDef.class, false);
    }

    private static class MyResolver
    implements ResolveCache.Resolver {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        public PsiElement resolve(@NotNull PsiReference psiReference, boolean incompleteCode) {
            if (psiReference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/dom/AntDomMacrodefAttributeReference$MyResolver", "resolve"));
            }
            PsiElement element = psiReference.getElement();
            if (element == null) {
                return null;
            }
            DomElement domElement = DomUtil.getDomElement((PsiElement)element);
            if (domElement == null) {
                return null;
            }
            AntDomMacroDef macrodef = (AntDomMacroDef)domElement.getParentOfType(AntDomMacroDef.class, false);
            if (macrodef == null) {
                return null;
            }
            String name = AntStringResolver.computeString(domElement, psiReference.getCanonicalText());
            for (AntDomMacrodefAttribute attribute : macrodef.getMacroAttributes()) {
                if (!name.equals(attribute.getName().getStringValue())) continue;
                DomTarget target = DomTarget.getTarget((DomElement)attribute);
                return target != null ? PomService.convertToPsi((PsiTarget)target) : null;
            }
            return null;
        }
    }
}

