/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.actions.TargetActionStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntToolwindowRegistrar
extends AbstractProjectComponent {
    public AntToolwindowRegistrar(Project project) {
        super(project);
    }

    public void projectOpened() {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        String prefix = AntConfiguration.getActionIdPrefix(this.myProject);
        ActionManager actionManager = ActionManager.getInstance();
        for (Keymap keymap : keymapManager.getAllKeymaps()) {
            for (String id : keymap.getActionIds()) {
                if (!id.startsWith(prefix) || actionManager.getAction(id) != null) continue;
                actionManager.registerAction(id, (AnAction)new TargetActionStub(id, this.myProject));
            }
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        final DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        compilerManager.addBeforeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfiguration config = AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                ((AntConfigurationBase)config).ensureInitialized();
                return config.executeTargetBeforeCompile(dataContext);
            }
        });
        compilerManager.addAfterTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                AntConfiguration config = AntConfiguration.getInstance(AntToolwindowRegistrar.this.myProject);
                ((AntConfigurationBase)config).ensureInitialized();
                return config.executeTargetAfterCompile(dataContext);
            }
        });
    }

    public void projectClosed() {
        String[] oldIds;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (String oldId : oldIds = actionManager.getActionIds(AntConfiguration.getActionIdPrefix(this.myProject))) {
            actionManager.unregisterAction(oldId);
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("AntToolwindowRegistrar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/impl/AntToolwindowRegistrar", "getComponentName"));
        }
        return "AntToolwindowRegistrar";
    }
}

